/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class CompilingEvaluatorUtils {
    public static ClassLoaderReference getClassLoader(EvaluationContext context2, DebugProcess process2) throws EvaluateException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        ClassType loaderClass = (ClassType)process2.findClass(context2, "java.net.URLClassLoader", context2.getClassLoader());
        Method ctorMethod = loaderClass.concreteMethodByName("<init>", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V");
        ClassLoaderReference reference = (ClassLoaderReference)process2.newInstance(context2, loaderClass, ctorMethod, Arrays.asList(CompilingEvaluatorUtils.createURLArray(context2), context2.getClassLoader()));
        CompilingEvaluatorUtils.keep(reference, context2);
        return reference;
    }

    public static void keep(ObjectReference reference, EvaluationContext context2) {
        ((SuspendContextImpl)context2.getSuspendContext()).keep(reference);
    }

    public static byte[] changeSuperToMagicAccessor(byte[] bytes2) {
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){

            public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
                if ("java/lang/Object".equals(superName)) {
                    superName = "sun/reflect/MagicAccessorImpl";
                }
                super.visit(version, access, name2, signature, superName, interfaces);
            }
        };
        new ClassReader(bytes2).accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    public static ArrayReference mirrorOf(byte[] bytes2, EvaluationContext context2, DebugProcess process2) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        ArrayType arrayClass = (ArrayType)process2.findClass(context2, "byte[]", context2.getClassLoader());
        ArrayReference reference = process2.newInstance(arrayClass, bytes2.length);
        CompilingEvaluatorUtils.keep(reference, context2);
        for (int i = 0; i < bytes2.length; ++i) {
            reference.setValue(i, (Value)((VirtualMachineProxyImpl)process2.getVirtualMachineProxy()).mirrorOf(bytes2[i]));
        }
        return reference;
    }

    public static void defineClass(@NotNull String className, byte[] bytecodes, @NotNull EvaluationContext context2, @NotNull DebugProcess process2, @NotNull ClassLoaderReference classLoader) throws ClassNotLoadedException, EvaluateException, InvalidTypeException {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/idea/debugger/evaluate/CompilingEvaluatorUtils", "defineClass"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/debugger/evaluate/CompilingEvaluatorUtils", "defineClass"));
        }
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/idea/debugger/evaluate/CompilingEvaluatorUtils", "defineClass"));
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "org/jetbrains/kotlin/idea/debugger/evaluate/CompilingEvaluatorUtils", "defineClass"));
        }
        VirtualMachineProxyImpl proxy = (VirtualMachineProxyImpl)process2.getVirtualMachineProxy();
        Method defineMethod = ((ClassType)classLoader.referenceType()).concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
        byte[] bytes2 = CompilingEvaluatorUtils.changeSuperToMagicAccessor(bytecodes);
        ArrayList<Value> args = new ArrayList<Value>();
        StringReference name2 = proxy.mirrorOf(className);
        CompilingEvaluatorUtils.keep(name2, context2);
        args.add(name2);
        args.add(CompilingEvaluatorUtils.mirrorOf(bytes2, context2, process2));
        args.add(proxy.mirrorOf(0));
        args.add(proxy.mirrorOf(bytes2.length));
        process2.invokeMethod(context2, (ObjectReference)classLoader, defineMethod, args);
    }

    private static ArrayReference createURLArray(EvaluationContext context2) throws EvaluateException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        DebugProcess process2 = context2.getDebugProcess();
        ArrayType arrayType = (ArrayType)process2.findClass(context2, "java.net.URL[]", context2.getClassLoader());
        ArrayReference arrayRef = arrayType.newInstance(1);
        CompilingEvaluatorUtils.keep(arrayRef, context2);
        ClassType classType = (ClassType)process2.findClass(context2, "java.net.URL", context2.getClassLoader());
        VirtualMachineProxyImpl proxy = (VirtualMachineProxyImpl)process2.getVirtualMachineProxy();
        StringReference url = proxy.mirrorOf("file:a");
        CompilingEvaluatorUtils.keep(url, context2);
        ObjectReference reference = process2.newInstance(context2, classType, classType.concreteMethodByName("<init>", "(Ljava/lang/String;)V"), Collections.singletonList(url));
        CompilingEvaluatorUtils.keep(reference, context2);
        arrayRef.setValues(Collections.singletonList(reference));
        return arrayRef;
    }
}

