/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.idea.decompiler.DecompilerPackage;
import org.jetbrains.kotlin.idea.decompiler.KotlinClsFileBase;
import org.jetbrains.kotlin.idea.stubindex.JetSourceFilterScope;
import org.jetbrains.kotlin.idea.vfilefinder.JsVirtualFileFinderFactory;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinderFactory;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public final class DecompiledNavigationUtils {
    @Nullable
    public static JetDeclaration getDeclarationFromDecompiledClassFile(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "getDeclarationFromDecompiledClassFile"));
        }
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "getDeclarationFromDecompiledClassFile"));
        }
        if (DescriptorUtils.isLocal(referencedDescriptor)) {
            return null;
        }
        VirtualFile virtualFile = DecompiledNavigationUtils.findVirtualFileContainingDescriptor(project, referencedDescriptor);
        if (virtualFile == null || !DecompilerPackage.isKotlinJvmCompiledFile(virtualFile) && !DecompilerPackage.isKotlinJsMetaFile(virtualFile)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (!(psiFile instanceof KotlinClsFileBase)) {
            return null;
        }
        return ((KotlinClsFileBase)psiFile).getDeclarationForDescriptor(referencedDescriptor);
    }

    @Nullable
    private static VirtualFile findVirtualFileContainingDescriptor(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "findVirtualFileContainingDescriptor"));
        }
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "findVirtualFileContainingDescriptor"));
        }
        if (ErrorUtils.isError(referencedDescriptor)) {
            return null;
        }
        ClassId containerClassId = DecompiledNavigationUtils.getContainerClassId(referencedDescriptor);
        if (containerClassId == null) {
            return null;
        }
        GlobalSearchScope scopeToSearchIn = JetSourceFilterScope.kotlinSourceAndClassFiles(GlobalSearchScope.allScope((Project)project), project);
        VirtualFileFinderFactory virtualFileFinderFactory = DecompiledNavigationUtils.isFromKotlinJavasriptMetadata(referencedDescriptor) ? JsVirtualFileFinderFactory.SERVICE.getInstance(project) : JvmVirtualFileFinderFactory.SERVICE.getInstance(project);
        VirtualFileFinder fileFinder = virtualFileFinderFactory.create(scopeToSearchIn);
        return fileFinder.findVirtualFileWithHeader(containerClassId);
    }

    private static boolean isFromKotlinJavasriptMetadata(@NotNull DeclarationDescriptor referencedDescriptor) {
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "isFromKotlinJavasriptMetadata"));
        }
        PackageFragmentDescriptor packageFragmentDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, PackageFragmentDescriptor.class, false);
        return packageFragmentDescriptor instanceof KotlinJavascriptPackageFragment;
    }

    @Nullable
    private static ClassId getContainerClassId(@NotNull DeclarationDescriptor referencedDescriptor) {
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "getContainerClassId"));
        }
        ClassOrPackageFragmentDescriptor containerDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, ClassOrPackageFragmentDescriptor.class, false);
        if (containerDescriptor instanceof PackageFragmentDescriptor) {
            return PackageClassUtils.getPackageClassId(((PackageFragmentDescriptor)containerDescriptor).getFqName());
        }
        if (containerDescriptor instanceof ClassDescriptor) {
            if (containerDescriptor.getContainingDeclaration() instanceof ClassDescriptor || ExpressionTypingUtils.isLocal(containerDescriptor.getContainingDeclaration(), containerDescriptor)) {
                return DecompiledNavigationUtils.getContainerClassId(containerDescriptor.getContainingDeclaration());
            }
            return DescriptorUtilPackage.getClassId((ClassDescriptor)containerDescriptor);
        }
        return null;
    }

    private DecompiledNavigationUtils() {
    }
}

