/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeAlignmentStrategy {
    private static final NodeAlignmentStrategy NULL_STRATEGY = NodeAlignmentStrategy.fromTypes(AlignmentStrategy.wrap(null, (IElementType[])new IElementType[0]));

    public static NodeAlignmentStrategy getNullStrategy() {
        return NULL_STRATEGY;
    }

    public static NodeAlignmentStrategy fromTypes(AlignmentStrategy strategy) {
        return new AlignmentStrategyWrapper(strategy);
    }

    @Nullable
    public abstract Alignment getAlignment(@NotNull ASTNode var1);

    public static class AlignmentStrategyWrapper
    extends NodeAlignmentStrategy {
        private final AlignmentStrategy internalStrategy;

        public AlignmentStrategyWrapper(@NotNull AlignmentStrategy internalStrategy) {
            if (internalStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalStrategy", "org/jetbrains/kotlin/idea/formatter/NodeAlignmentStrategy$AlignmentStrategyWrapper", "<init>"));
            }
            this.internalStrategy = internalStrategy;
        }

        @Override
        @Nullable
        public Alignment getAlignment(@NotNull ASTNode node2) {
            if (node2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/idea/formatter/NodeAlignmentStrategy$AlignmentStrategyWrapper", "getAlignment"));
            }
            ASTNode parent = node2.getTreeParent();
            if (parent != null) {
                return this.internalStrategy.getAlignment(parent.getElementType(), node2.getElementType());
            }
            return this.internalStrategy.getAlignment(node2.getElementType());
        }
    }
}

