/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.JetHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.JetHighlightingLexer;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.JetTokens;

public class JetHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1 = new HashMap<IElementType, TextAttributesKey>();
    private static final Map<IElementType, TextAttributesKey> keys2 = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        JetHighlightingLexer jetHighlightingLexer = new JetHighlightingLexer();
        if (jetHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/JetHighlighter", "getHighlightingLexer"));
        }
        return jetHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = JetHighlighter.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/JetHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    static {
        JetHighlighter.fillMap(keys1, (TokenSet)JetTokens.KEYWORDS, (TextAttributesKey)JetHighlightingColors.KEYWORD);
        keys1.put(JetTokens.AS_SAFE, JetHighlightingColors.KEYWORD);
        keys1.put(JetTokens.INTEGER_LITERAL, JetHighlightingColors.NUMBER);
        keys1.put(JetTokens.FLOAT_LITERAL, JetHighlightingColors.NUMBER);
        JetHighlighter.fillMap(keys1, (TokenSet)TokenSet.andNot((TokenSet)JetTokens.OPERATIONS, (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER, JetTokens.AT}), JetTokens.KEYWORDS})), (TextAttributesKey)JetHighlightingColors.OPERATOR_SIGN);
        keys1.put(JetTokens.LPAR, JetHighlightingColors.PARENTHESIS);
        keys1.put(JetTokens.RPAR, JetHighlightingColors.PARENTHESIS);
        keys1.put(JetTokens.LBRACE, JetHighlightingColors.BRACES);
        keys1.put(JetTokens.RBRACE, JetHighlightingColors.BRACES);
        keys1.put(JetTokens.LBRACKET, JetHighlightingColors.BRACKETS);
        keys1.put(JetTokens.RBRACKET, JetHighlightingColors.BRACKETS);
        keys1.put(JetTokens.COMMA, JetHighlightingColors.COMMA);
        keys1.put(JetTokens.SEMICOLON, JetHighlightingColors.SEMICOLON);
        keys1.put(JetTokens.DOT, JetHighlightingColors.DOT);
        keys1.put(JetTokens.ARROW, JetHighlightingColors.ARROW);
        keys1.put(JetTokens.OPEN_QUOTE, JetHighlightingColors.STRING);
        keys1.put(JetTokens.CLOSING_QUOTE, JetHighlightingColors.STRING);
        keys1.put(JetTokens.REGULAR_STRING_PART, JetHighlightingColors.STRING);
        keys1.put(JetTokens.LONG_TEMPLATE_ENTRY_END, JetHighlightingColors.STRING_ESCAPE);
        keys1.put(JetTokens.LONG_TEMPLATE_ENTRY_START, JetHighlightingColors.STRING_ESCAPE);
        keys1.put(JetTokens.SHORT_TEMPLATE_ENTRY_START, JetHighlightingColors.STRING_ESCAPE);
        keys1.put(JetTokens.ESCAPE_SEQUENCE, JetHighlightingColors.STRING_ESCAPE);
        keys1.put(JetTokens.CHARACTER_LITERAL, JetHighlightingColors.STRING);
        keys1.put(JetTokens.EOL_COMMENT, JetHighlightingColors.LINE_COMMENT);
        keys1.put(JetTokens.SHEBANG_COMMENT, JetHighlightingColors.LINE_COMMENT);
        keys1.put(JetTokens.BLOCK_COMMENT, JetHighlightingColors.BLOCK_COMMENT);
        keys1.put(JetTokens.DOC_COMMENT, JetHighlightingColors.DOC_COMMENT);
        JetHighlighter.fillMap(keys1, (TokenSet)KDocTokens.KDOC_HIGHLIGHT_TOKENS, (TextAttributesKey)JetHighlightingColors.DOC_COMMENT);
        keys1.put(KDocTokens.TAG_NAME, JetHighlightingColors.KDOC_TAG);
        keys2.put(KDocTokens.TAG_NAME, JetHighlightingColors.DOC_COMMENT);
        keys1.put(TokenType.BAD_CHARACTER, JetHighlightingColors.BAD_CHARACTER);
    }
}

