/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.IntentionsPackage$Utils$d82a7ea7;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingIntention;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.PsiPackage;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u001a\u0006))\"+Z7pm\u0016\u0014%/Y2fg&sG/\u001a8uS>t'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\u000bS:$XM\u001c;j_:\u001c(\"\u0007&fiN+GN\u001a+be\u001e,G/\u001b8h\u0013:$XM\u001c;j_:T!CS3u\u00052|7m[#yaJ,7o]5p]*\u0019\u0001o]5\u000b\rqJg.\u001b;?\u0015\u001d\t\u0007\u000f\u001d7z)>Tq!\u001a7f[\u0016tGO\u0003\u0004fI&$xN\u001d\u0006\u0007\u000b\u0012LGo\u001c:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&TA!\u00168ji*q\u0001.\u00198eY\u0016\u001cu.\\7f]R\u001c(\"C2p]N$(/^2u\u00155QU\r^#yaJ,7o]5p]*)!\r\\8dW*q\u0011n]!qa2L7-\u00192mKR{'bC2be\u0016$xJ\u001a4tKRT1!\u00138u\u0015\u001d\u0011un\u001c7fC:t\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\n!=QA\u0001\u0003\u0006\u0011!)!\u0001b\u0003\t\r\u0015\u0019AA\u0002E\u0007\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u00119\u0001\u0012\u0003\u0007\u0001\u000b\t!9\u0001c\u0002\u0006\u0005\u00111\u0001RB\u0003\u0004\t\u000fA!\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001BC\u0003\u0004\t\u001dAA\u0002\u0004\u0001\u0006\u0007\u00119\u0001\u0012\u0004\u0007\u0001\t\ra)!\u0007\u0004\u0006\u0003!\u0019\u0011bA\u0005\u0003\u000b\u0005AA!,\u000f\u0005\u0017a)QT\u0002\u0003\u0001\u0011\u0017i!!B\u0001\t\tA\u001b\u0001!(\u0004\u0005\u0001!1QBA\u0003\u0002\u0011\u001b\u00016\u0011A\u0011\u0003\u000b\u0005Ay!U\u0002\b\t\u0015I\u0011\u0001\u0002\u0001\u000e\u0003!AQ\"\u0001E\t[s!\u0011\u0001G\u0005\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0001;\u001b!\u0001\u0001#\u0006\u000e\u0005\u0015\t\u0001\u0002\u0002)\u0004\u0002\u0005\u0012Q!\u0001E\b#\u000e9A!C\u0005\u0002\t\u0001i\u0011\u0001c\u0005\u000e\u0003!AQ\u0016\b\u0003\f1-ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001\u0005\u0005!\u000e\u0001QT\u0002\u0003\u0001\u0011/i!!B\u0001\t\u0015A\u001b\t!\t\u0002\u0006\u0003!U\u0011kA\u0004\u0005\u0017%\tA\u0011A\u0007\u0002\u0011!i\u0011\u0001\"\u00026\u0017\u0015QAa9\u0001\u0019\n\u0005\u0012Q!\u0001E\u0003#\u000e\u0019A\u0011B\u0005\u0002\t\u0001\u0001"})
public final class RemoveBracesIntention
extends JetSelfTargetingIntention<JetBlockExpression> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(RemoveBracesIntention.class);
    }

    @Override
    public boolean isApplicableTo(@JetValueParameter(name="element") @NotNull JetBlockExpression element, @JetValueParameter(name="caretOffset") int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element.getStatements().size() != 1) {
            return false;
        }
        PsiElement psiElement = element.getParent();
        if (!(psiElement instanceof JetContainerNode)) {
            psiElement = null;
        }
        JetContainerNode jetContainerNode = (JetContainerNode)psiElement;
        if (jetContainerNode == null) {
            return false;
        }
        JetContainerNode containerNode = jetContainerNode;
        PsiElement psiElement2 = element.getLBrace();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement lBrace = psiElement2;
        PsiElement psiElement3 = element.getRBrace();
        if (psiElement3 == null) {
            return false;
        }
        PsiElement rBrace = psiElement3;
        if (!lBrace.getTextRange().containsOffset(caretOffset) && !rBrace.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        String string = IntentionsPackage$Utils$d82a7ea7.description(containerNode);
        if (string == null) {
            return false;
        }
        String description = string;
        this.setText("Remove braces from '" + description + "' statement");
        return true;
    }

    @Override
    public void applyTo(@JetValueParameter(name="element") @NotNull JetBlockExpression element, @JetValueParameter(name="editor") @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JetElement statement = (JetElement)KotlinPackage.single(element.getStatements());
        PsiElement psiElement = element.getParent();
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetContainerNode");
        }
        JetContainerNode containerNode = (JetContainerNode)psiElement;
        PsiElement psiElement2 = containerNode.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetExpression");
        }
        JetExpression construct = (JetExpression)psiElement2;
        this.handleComments(construct, element);
        PsiElement psiElement3 = statement.copy();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"statement.copy()");
        PsiElement newElement = element.replace(psiElement3);
        if (construct instanceof JetDoWhileExpression) {
            PsiElement psiElement4 = newElement.getParent();
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            psiElement4.addAfter(PsiPackage.JetPsiFactory((PsiElement)element).createNewLine(), newElement);
        }
    }

    private final void handleComments(@JetValueParameter(name="construct") JetExpression construct, @JetValueParameter(name="block") JetBlockExpression block) {
        PsiElement sibling;
        PsiElement psiElement = block.getFirstChild();
        Object object = sibling = psiElement != null ? psiElement.getNextSibling() : null;
        while (sibling != null) {
            if (sibling instanceof PsiComment) {
                JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)construct);
                if (construct.getPrevSibling() instanceof PsiWhiteSpace) {
                    PsiElement psiElement2 = construct.getPrevSibling();
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement2.replace(psiFactory.createNewLine());
                }
                PsiElement psiElement3 = construct.getParent();
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement commentElement = psiElement3.addBefore(sibling, construct.getPrevSibling());
                PsiElement psiElement4 = construct.getParent();
                if (psiElement4 == null) {
                    Intrinsics.throwNpe();
                }
                psiElement4.addBefore(psiFactory.createNewLine(), commentElement);
            }
            sibling = sibling.getNextSibling();
        }
    }

    public RemoveBracesIntention() {
        super(JetBlockExpression.class, "Remove braces", null, false, 12, null);
    }
}

