/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ktSignature;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.idea.ktSignature.KotlinSignatureInJavaMarkerProvider;

public class ShowKotlinSignaturesAction
extends ToggleAction {
    public ShowKotlinSignaturesAction() {
        super("Show Kotlin Signatures");
    }

    public boolean isSelected(AnActionEvent e) {
        Project project = e.getProject();
        return project != null && KotlinSignatureInJavaMarkerProvider.isMarkersEnabled(project);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setVisible(false);
        PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (psiFile != null && psiFile.getLanguage() == JavaLanguage.INSTANCE) {
            e.getPresentation().setVisible(true);
        }
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Project project = e.getProject();
        assert (project != null);
        KotlinSignatureInJavaMarkerProvider.setMarkersEnabled(project, state);
    }
}

