/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.parameterInfo;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.ReferenceVariantsHelper;
import org.jetbrains.kotlin.lexer.JetSingleValueToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.JetVisibilityChecker;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class JetFunctionParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JetValueArgumentList, Pair<? extends FunctionDescriptor, ResolutionFacade>, JetValueArgument> {
    public static final Color GREEN_BACKGROUND = new JBColor(new Color(231, 254, 234), (Color)Gray._100);

    @NotNull
    public JetValueArgument[] getActualParameters(@NotNull JetValueArgumentList arguments2) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "getActualParameters"));
        }
        List<JetValueArgument> argumentList2 = arguments2.getArguments();
        JetValueArgument[] jetValueArgumentArray = argumentList2.toArray(new JetValueArgument[argumentList2.size()]);
        if (jetValueArgumentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "getActualParameters"));
        }
        return jetValueArgumentArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        JetSingleValueToken jetSingleValueToken = JetTokens.COMMA;
        if (jetSingleValueToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return jetSingleValueToken;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        JetSingleValueToken jetSingleValueToken = JetTokens.RBRACE;
        if (jetSingleValueToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return jetSingleValueToken;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = Collections.singleton(JetCallElement.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<Class<JetFunction>> set = Collections.singleton(JetFunction.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    @NotNull
    public Class<JetValueArgumentList> getArgumentListClass() {
        if (JetValueArgumentList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "getArgumentListClass"));
        }
        return JetValueArgumentList.class;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context2) {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public Object[] getParametersForDocumentation(Pair<? extends FunctionDescriptor, ResolutionFacade> p, ParameterInfoContext context2) {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public JetValueArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "findElementForParameterInfo"));
        }
        return JetFunctionParameterInfoHandler.findCall(context2);
    }

    public void showParameterInfo(@NotNull JetValueArgumentList element, @NotNull CreateParameterInfoContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "showParameterInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "showParameterInfo"));
        }
        context2.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public JetValueArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return JetFunctionParameterInfoHandler.findCallAndUpdateContext(context2);
    }

    public void updateParameterInfo(@NotNull JetValueArgumentList argumentList2, @NotNull UpdateParameterInfoContext context2) {
        if (argumentList2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "updateParameterInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "updateParameterInfo"));
        }
        if (context2.getParameterOwner() != argumentList2) {
            context2.removeHint();
        }
        int offset = context2.getOffset();
        int i = 0;
        for (ASTNode child = argumentList2.getNode().getFirstChildNode(); child != null && child.getStartOffset() < offset; child = child.getTreeNext()) {
            if (child.getElementType() != JetTokens.COMMA) continue;
            ++i;
        }
        context2.setCurrentParameter(i);
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    private static String renderParameter(ValueParameterDescriptor parameter, boolean named) {
        StringBuilder builder = new StringBuilder();
        if (named) {
            builder.append("[");
        }
        if (parameter.getVarargElementType() != null) {
            builder.append("vararg ");
        }
        builder.append(parameter.getName()).append(": ").append(DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(JetFunctionParameterInfoHandler.getActualParameterType(parameter)));
        if (parameter.hasDefaultValue()) {
            PsiElement parameterDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
            builder.append(" = ").append(JetFunctionParameterInfoHandler.getDefaultExpressionString(parameterDeclaration));
        }
        if (named) {
            builder.append("]");
        }
        return builder.toString();
    }

    private static String getDefaultExpressionString(@Nullable PsiElement parameterDeclaration) {
        JetExpression defaultValue;
        if (parameterDeclaration instanceof JetParameter && (defaultValue = ((JetParameter)parameterDeclaration).getDefaultValue()) != null) {
            String defaultExpression = defaultValue.getText();
            if (defaultExpression.length() <= 32) {
                return defaultExpression;
            }
            if (defaultValue instanceof JetConstantExpression || defaultValue instanceof JetStringTemplateExpression) {
                if (defaultExpression.startsWith("\"")) {
                    return "\"...\"";
                }
                if (defaultExpression.startsWith("'")) {
                    return "'...'";
                }
            }
        }
        return "...";
    }

    private static JetType getActualParameterType(ValueParameterDescriptor descriptor2) {
        JetType paramType = descriptor2.getType();
        if (descriptor2.getVarargElementType() != null) {
            paramType = descriptor2.getVarargElementType();
        }
        return paramType;
    }

    public void updateUI(Pair<? extends FunctionDescriptor, ResolutionFacade> itemToShow, @NotNull ParameterInfoUIContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/parameterInfo/JetFunctionParameterInfoHandler", "updateUI"));
        }
        if (context2 == null || context2.getParameterOwner() == null || !context2.getParameterOwner().isValid()) {
            context2.setUIComponentEnabled(false);
            return;
        }
        PsiElement parameterOwner = context2.getParameterOwner();
        if (!(parameterOwner instanceof JetValueArgumentList)) {
            context2.setUIComponentEnabled(false);
            return;
        }
        JetValueArgumentList argumentList2 = (JetValueArgumentList)parameterOwner;
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)itemToShow.first;
        ResolutionFacade resolutionFacade = (ResolutionFacade)itemToShow.second;
        List<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters();
        List<JetValueArgument> valueArguments2 = argumentList2.getArguments();
        int currentParameterIndex = context2.getCurrentParameterIndex();
        int boldStartOffset = -1;
        int boldEndOffset = -1;
        boolean isGrey = false;
        boolean isDeprecated = KotlinBuiltIns.isDeprecated(functionDescriptor);
        boolean[] usedIndexes = new boolean[valueParameters.size()];
        Arrays.fill(usedIndexes, false);
        boolean namedMode = false;
        if (!JetFunctionParameterInfoHandler.isIndexValid(valueParameters, currentParameterIndex)) {
            isGrey = true;
        }
        StringBuilder builder = new StringBuilder();
        PsiElement owner = context2.getParameterOwner();
        BindingContext bindingContext2 = resolutionFacade.analyze((JetElement)owner, BodyResolveMode.FULL);
        for (int i = 0; i < valueParameters.size(); ++i) {
            boolean highlightParameter;
            if (i != 0) {
                builder.append(", ");
            }
            boolean bl = highlightParameter = i == currentParameterIndex || !namedMode && i < currentParameterIndex && ((ValueParameterDescriptor)Iterables.getLast(valueParameters)).getVarargElementType() != null;
            if (highlightParameter) {
                boldStartOffset = builder.length();
            }
            if (!namedMode) {
                if (valueArguments2.size() > i) {
                    JetValueArgument argument = valueArguments2.get(i);
                    if (argument.isNamed()) {
                        namedMode = true;
                    } else {
                        ValueParameterDescriptor param = valueParameters.get(i);
                        builder.append(JetFunctionParameterInfoHandler.renderParameter(param, false));
                        if (i <= currentParameterIndex && !JetFunctionParameterInfoHandler.isArgumentTypeValid(bindingContext2, argument, param)) {
                            isGrey = true;
                        }
                        usedIndexes[i] = true;
                    }
                } else {
                    ValueParameterDescriptor param = valueParameters.get(i);
                    builder.append(JetFunctionParameterInfoHandler.renderParameter(param, false));
                }
            }
            if (namedMode) {
                JetValueArgument argument;
                boolean takeAnyArgument = true;
                if (valueArguments2.size() > i && (argument = valueArguments2.get(i)).isNamed()) {
                    for (int j = 0; j < valueParameters.size(); ++j) {
                        JetSimpleNameExpression referenceExpression = argument.getArgumentName().getReferenceExpression();
                        ValueParameterDescriptor param = valueParameters.get(j);
                        if (referenceExpression == null || usedIndexes[j] || !param.getName().equals(referenceExpression.getReferencedNameAsName())) continue;
                        takeAnyArgument = false;
                        usedIndexes[j] = true;
                        builder.append(JetFunctionParameterInfoHandler.renderParameter(param, true));
                        if (i >= currentParameterIndex || JetFunctionParameterInfoHandler.isArgumentTypeValid(bindingContext2, argument, param)) break;
                        isGrey = true;
                        break;
                    }
                }
                if (takeAnyArgument) {
                    if (i < currentParameterIndex) {
                        isGrey = true;
                    }
                    for (int j = 0; j < valueParameters.size(); ++j) {
                        ValueParameterDescriptor param = valueParameters.get(j);
                        if (usedIndexes[j]) continue;
                        usedIndexes[j] = true;
                        builder.append(JetFunctionParameterInfoHandler.renderParameter(param, true));
                        break;
                    }
                }
            }
            if (!highlightParameter) continue;
            boldEndOffset = builder.length();
        }
        if (valueParameters.size() == 0) {
            builder.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        assert (!builder.toString().isEmpty()) : "A message about 'no parameters' or some parameters should be present: " + functionDescriptor;
        Color color = JetFunctionParameterInfoHandler.isResolvedToDescriptor(argumentList2, functionDescriptor, bindingContext2) != false ? GREEN_BACKGROUND : context2.getDefaultParameterColor();
        context2.setupUIComponentPresentation(builder.toString(), boldStartOffset, boldEndOffset, isGrey, isDeprecated, false, color);
    }

    private static boolean isArgumentTypeValid(BindingContext bindingContext2, JetValueArgument argument, ValueParameterDescriptor param) {
        if (argument.getArgumentExpression() != null) {
            JetType paramType = JetFunctionParameterInfoHandler.getActualParameterType(param);
            JetType exprType = bindingContext2.getType(argument.getArgumentExpression());
            return exprType == null || JetTypeChecker.DEFAULT.isSubtypeOf(exprType, paramType);
        }
        return false;
    }

    private static boolean isIndexValid(List<ValueParameterDescriptor> valueParameters, int index2) {
        return index2 < valueParameters.size() || valueParameters.size() > 0 && ((ValueParameterDescriptor)Iterables.getLast(valueParameters)).getVarargElementType() != null;
    }

    private static Boolean isResolvedToDescriptor(JetValueArgumentList argumentList2, FunctionDescriptor functionDescriptor, BindingContext bindingContext2) {
        DeclarationDescriptor declarationDescriptor;
        JetSimpleNameExpression callNameExpression = JetFunctionParameterInfoHandler.getCallSimpleNameExpression(argumentList2);
        if (callNameExpression != null && (declarationDescriptor = bindingContext2.get(BindingContext.REFERENCE_TARGET, callNameExpression)) != null && declarationDescriptor == functionDescriptor) {
            return true;
        }
        return false;
    }

    private static JetValueArgumentList findCall(CreateParameterInfoContext context2) {
        PsiFile file = context2.getFile();
        if (!(file instanceof JetFile)) {
            return null;
        }
        JetValueArgumentList argumentList2 = (JetValueArgumentList)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(context2.getOffset()), JetValueArgumentList.class);
        if (argumentList2 == null) {
            return null;
        }
        JetSimpleNameExpression callNameExpression = JetFunctionParameterInfoHandler.getCallSimpleNameExpression(argumentList2);
        if (callNameExpression == null) {
            return null;
        }
        PsiReference[] references = callNameExpression.getReferences();
        if (references.length == 0) {
            return null;
        }
        ResolutionFacade resolutionFacade = ResolvePackage.getResolutionFacade(callNameExpression.getContainingJetFile());
        BindingContext bindingContext2 = resolutionFacade.analyze(callNameExpression, BodyResolveMode.FULL);
        JetScope scope2 = bindingContext2.get(BindingContext.RESOLUTION_SCOPE, callNameExpression);
        final DeclarationDescriptor placeDescriptor = scope2 != null ? scope2.getContainingDeclaration() : null;
        Function1<DeclarationDescriptor, Boolean> visibilityFilter = new Function1<DeclarationDescriptor, Boolean>(){

            public Boolean invoke(DeclarationDescriptor descriptor2) {
                return placeDescriptor == null || JetVisibilityChecker.isVisible(placeDescriptor, descriptor2);
            }
        };
        final Name refName = callNameExpression.getReferencedNameAsName();
        Function1<Name, Boolean> nameFilter = new Function1<Name, Boolean>(){

            public Boolean invoke(Name name2) {
                return name2.equals(refName);
            }
        };
        Collection<DeclarationDescriptor> variants2 = new ReferenceVariantsHelper(bindingContext2, (Function1<? super DeclarationDescriptor, ? extends Boolean>)visibilityFilter).getReferenceVariants(callNameExpression, new DescriptorKindFilter(11, Collections.emptyList()), false, (Function1<? super Name, ? extends Boolean>)nameFilter);
        ArrayList<Pair> itemsToShow = new ArrayList<Pair>();
        for (DeclarationDescriptor variant : variants2) {
            if (variant instanceof FunctionDescriptor) {
                itemsToShow.add(Pair.create((Object)((FunctionDescriptor)variant), (Object)resolutionFacade));
                continue;
            }
            if (!(variant instanceof ClassDescriptor)) continue;
            for (ConstructorDescriptor constructorDescriptor : ((ClassDescriptor)variant).getConstructors()) {
                itemsToShow.add(Pair.create((Object)constructorDescriptor, (Object)resolutionFacade));
            }
        }
        context2.setItemsToShow(ArrayUtil.toObjectArray(itemsToShow));
        return argumentList2;
    }

    @Nullable
    private static JetSimpleNameExpression getCallSimpleNameExpression(JetValueArgumentList argumentList2) {
        PsiElement argumentListParent = argumentList2.getParent();
        return argumentListParent instanceof JetCallElement ? PsiUtilPackage.getCallNameExpression((JetCallElement)argumentListParent) : null;
    }

    private static JetValueArgumentList findCallAndUpdateContext(UpdateParameterInfoContext context2) {
        PsiElement parent;
        PsiFile file = context2.getFile();
        PsiElement element = file.findElementAt(context2.getOffset());
        if (element == null) {
            return null;
        }
        for (parent = element.getParent(); parent != null && !(parent instanceof JetValueArgumentList); parent = parent.getParent()) {
            element = element.getParent();
        }
        if (parent == null) {
            return null;
        }
        JetValueArgumentList argumentList2 = (JetValueArgumentList)parent;
        if (element instanceof JetValueArgument) {
            JetValueArgument arg = (JetValueArgument)element;
            int i = argumentList2.getArguments().indexOf(arg);
            context2.setCurrentParameter(i);
            context2.setHighlightedParameter((Object)arg);
        }
        return argumentList2;
    }
}

