/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.project.TargetPlatform;
import org.jetbrains.kotlin.psi.JetFile;

public class TargetPlatformDetector {
    public static final TargetPlatformDetector INSTANCE = new TargetPlatformDetector();
    private static final Logger LOG = Logger.getInstance(TargetPlatformDetector.class);

    private TargetPlatformDetector() {
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            TargetPlatform targetPlatform = TargetPlatformDetector.getDefaultPlatform();
            if (targetPlatform == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
            }
            return targetPlatform;
        }
        Module moduleForFile = ProjectFileIndex.SERVICE.getInstance((Project)file.getProject()).getModuleForFile(virtualFile);
        if (moduleForFile == null) {
            TargetPlatform targetPlatform = TargetPlatformDetector.getDefaultPlatform();
            if (targetPlatform == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
            }
            return targetPlatform;
        }
        TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform(moduleForFile);
        if (targetPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
        }
        return targetPlatform;
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
        }
        if (ProjectStructureUtil.isJsKotlinModule(module)) {
            TargetPlatform targetPlatform = TargetPlatform.JS;
            if (targetPlatform == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
            }
            return targetPlatform;
        }
        TargetPlatform targetPlatform = TargetPlatform.JVM;
        if (targetPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
        }
        return targetPlatform;
    }

    @NotNull
    public static TargetPlatform getDefaultPlatform() {
        LOG.info("Using default platform");
        TargetPlatform targetPlatform = TargetPlatform.JVM;
        if (targetPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getDefaultPlatform"));
        }
        return targetPlatform;
    }
}

