/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetHintAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererBuilder;
import org.jetbrains.kotlin.renderer.NameShortness;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.VisibilityUtil;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class ChangeMemberFunctionSignatureFix
extends JetHintAction<JetNamedFunction> {
    private static final DescriptorRenderer SIGNATURE_RENDERER = new DescriptorRendererBuilder().setTypeNormalizer(IdeDescriptorRenderers.APPROXIMATE_FLEXIBLE_TYPES).setWithDefinedIn(false).setModifiers(new DescriptorRenderer.Modifier[0]).setNameShortness(NameShortness.SHORT).setUnitReturnType(false).build();
    private final List<FunctionDescriptor> possibleSignatures;
    private static final ParameterChooser MATCH_NAMES = new ParameterChooser(){

        @Override
        @Nullable
        public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor parameter, @NotNull ValueParameterDescriptor superParameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$3", "choose"));
            }
            if (superParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superParameter", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$3", "choose"));
            }
            return parameter.getName().equals(superParameter.getName()) ? superParameter : null;
        }
    };
    private static final ParameterChooser MATCH_TYPES = new ParameterChooser(){

        @Override
        @Nullable
        public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor parameter, @NotNull ValueParameterDescriptor superParameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$4", "choose"));
            }
            if (superParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superParameter", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$4", "choose"));
            }
            if (JetTypeChecker.DEFAULT.equalTypes(parameter.getType(), superParameter.getType())) {
                return superParameter.copy(parameter.getContainingDeclaration(), parameter.getName());
            }
            return null;
        }
    };

    public ChangeMemberFunctionSignatureFix(@NotNull JetNamedFunction element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "<init>"));
        }
        super(element);
        this.possibleSignatures = ChangeMemberFunctionSignatureFix.computePossibleSignatures(element);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && !this.possibleSignatures.isEmpty();
    }

    @NotNull
    public String getText() {
        if (this.possibleSignatures.size() == 1) {
            String string = JetBundle.message("change.function.signature.action.single", SIGNATURE_RENDERER.render(this.possibleSignatures.get(0)));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "getText"));
            }
            return string;
        }
        String string = JetBundle.message("change.function.signature.action.multiple", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.function.signature.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void invoke(final @NotNull Project project, final Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "invoke"));
        }
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                new MyAction(project, editor, (JetNamedFunction)ChangeMemberFunctionSignatureFix.this.element, ChangeMemberFunctionSignatureFix.this.possibleSignatures).execute();
            }
        });
    }

    @NotNull
    private static List<FunctionDescriptor> computePossibleSignatures(@NotNull JetNamedFunction functionElement) {
        if (functionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionElement", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "computePossibleSignatures"));
        }
        if (functionElement.getValueParameterList() == null) {
            List<FunctionDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "computePossibleSignatures"));
            }
            return list;
        }
        BindingContext context2 = ResolvePackage.analyzeFully(functionElement);
        FunctionDescriptor functionDescriptor = context2.get(BindingContext.FUNCTION, functionElement);
        if (functionDescriptor == null) {
            ArrayList arrayList = Lists.newArrayList();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "computePossibleSignatures"));
            }
            return arrayList;
        }
        List<FunctionDescriptor> superFunctions = ChangeMemberFunctionSignatureFix.getPossibleSuperFunctionsDescriptors(functionDescriptor);
        final HashMap possibleSignatures = Maps.newHashMap();
        for (FunctionDescriptor superFunction : superFunctions) {
            if (!superFunction.getKind().isReal()) continue;
            FunctionDescriptor signature = ChangeMemberFunctionSignatureFix.changeSignatureToMatch(functionDescriptor, superFunction);
            possibleSignatures.put(SIGNATURE_RENDERER.render(signature), signature);
        }
        ArrayList keys = new ArrayList(possibleSignatures.keySet());
        Collections.sort(keys);
        ArrayList<FunctionDescriptor> arrayList = new ArrayList<FunctionDescriptor>(Collections2.transform(keys, (Function)new Function<String, FunctionDescriptor>(){

            public FunctionDescriptor apply(String key) {
                return (FunctionDescriptor)possibleSignatures.get(key);
            }
        }));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "computePossibleSignatures"));
        }
        return arrayList;
    }

    private static FunctionDescriptor changeSignatureToMatch(FunctionDescriptor function2, FunctionDescriptor superFunction) {
        List<ValueParameterDescriptor> superParameters = superFunction.getValueParameters();
        List<ValueParameterDescriptor> parameters2 = function2.getValueParameters();
        ArrayList newParameters = Lists.newArrayList(superParameters);
        BitSet matched = new BitSet(superParameters.size());
        BitSet used = new BitSet(superParameters.size());
        ChangeMemberFunctionSignatureFix.matchParameters(MATCH_NAMES, superParameters, parameters2, newParameters, matched, used);
        ChangeMemberFunctionSignatureFix.matchParameters(MATCH_TYPES, superParameters, parameters2, newParameters, matched, used);
        FunctionDescriptor newFunction = FunctionDescriptorUtil.replaceFunctionParameters(superFunction.copy(function2.getContainingDeclaration(), Modality.OPEN, ChangeMemberFunctionSignatureFix.getVisibility(function2, superFunction), CallableMemberDescriptor.Kind.DELEGATION, true), newParameters);
        newFunction.addOverriddenDescriptor(superFunction);
        return newFunction;
    }

    private static Visibility getVisibility(FunctionDescriptor function2, FunctionDescriptor superFunction) {
        ArrayDeque descriptors = Queues.newArrayDeque(Arrays.asList(superFunction, function2));
        return VisibilityUtil.findMemberWithMaxVisibility(descriptors).getVisibility();
    }

    private static void matchParameters(@NotNull ParameterChooser parameterChooser, @NotNull List<ValueParameterDescriptor> superParameters, @NotNull List<ValueParameterDescriptor> parameters2, @NotNull List<ValueParameterDescriptor> newParameters, @NotNull BitSet matched, @NotNull BitSet used) {
        if (parameterChooser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterChooser", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "matchParameters"));
        }
        if (superParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superParameters", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "matchParameters"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "matchParameters"));
        }
        if (newParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParameters", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "matchParameters"));
        }
        if (matched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matched", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "matchParameters"));
        }
        if (used == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "used", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "matchParameters"));
        }
        block0: for (ValueParameterDescriptor superParameter : superParameters) {
            if (matched.get(superParameter.getIndex())) continue;
            for (ValueParameterDescriptor parameter : parameters2) {
                ValueParameterDescriptor choice = parameterChooser.choose(parameter, superParameter);
                if (used.get(parameter.getIndex()) || choice == null) continue;
                used.set(parameter.getIndex(), true);
                matched.set(superParameter.getIndex(), true);
                newParameters.set(superParameter.getIndex(), choice);
                continue block0;
            }
        }
    }

    @NotNull
    private static List<FunctionDescriptor> getPossibleSuperFunctionsDescriptors(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "getPossibleSuperFunctionsDescriptors"));
        }
        DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
        ArrayList superFunctions = Lists.newArrayList();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            ArrayList arrayList = superFunctions;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "getPossibleSuperFunctionsDescriptors"));
            }
            return arrayList;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
        Name name2 = functionDescriptor.getName();
        for (JetType type2 : TypeUtils.getAllSupertypes(classDescriptor.getDefaultType())) {
            JetScope scope2 = type2.getMemberScope();
            for (FunctionDescriptor function2 : scope2.getFunctions(name2)) {
                if (!function2.getKind().isReal() || !function2.getModality().isOverridable()) continue;
                superFunctions.add(function2);
            }
        }
        ArrayList arrayList = superFunctions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "getPossibleSuperFunctionsDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactory() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(Diagnostic diagnostic) {
                JetNamedFunction function2 = QuickFixUtil.getParentElementOfType(diagnostic, JetNamedFunction.class);
                return function2 == null ? null : new ChangeMemberFunctionSignatureFix(function2);
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "createFactory"));
        }
        return jetSingleIntentionActionFactory;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix", "showHint"));
        }
        if (this.possibleSignatures.isEmpty()) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        return !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true);
    }

    private static class MyAction {
        private final Project project;
        private final Editor editor;
        private final JetNamedFunction function;
        private final List<FunctionDescriptor> signatures;

        public MyAction(@NotNull Project project, @NotNull Editor editor, @NotNull JetNamedFunction function2, @NotNull List<FunctionDescriptor> signatures) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction", "<init>"));
            }
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction", "<init>"));
            }
            if (signatures == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatures", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction", "<init>"));
            }
            this.project = project;
            this.editor = editor;
            this.function = function2;
            this.signatures = signatures;
        }

        public boolean execute() {
            PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
            if (!this.function.isValid() || this.signatures.isEmpty()) {
                return false;
            }
            if (this.signatures.size() == 1 || !this.editor.getComponent().isShowing()) {
                this.changeSignature(this.signatures.get(0));
            } else {
                this.chooseSignatureAndChange();
            }
            return true;
        }

        private BaseListPopupStep getSignaturePopup() {
            return new BaseListPopupStep<FunctionDescriptor>(JetBundle.message("change.function.signature.chooser.title", new Object[0]), this.signatures){

                public boolean isAutoSelectionEnabled() {
                    return false;
                }

                public PopupStep onChosen(FunctionDescriptor selectedValue, boolean finalChoice) {
                    if (finalChoice) {
                        MyAction.this.changeSignature(selectedValue);
                    }
                    return FINAL_CHOICE;
                }

                public Icon getIconFor(FunctionDescriptor aValue) {
                    return PlatformIcons.FUNCTION_ICON;
                }

                @NotNull
                public String getTextFor(FunctionDescriptor aValue) {
                    String string = SIGNATURE_RENDERER.render(aValue);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction$1", "getTextFor"));
                    }
                    return string;
                }
            };
        }

        private void changeSignature(FunctionDescriptor patternDescriptor) {
            final String signatureString = IdeDescriptorRenderers.SOURCE_CODE.render(patternDescriptor);
            PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
            final JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(this.project);
            CommandProcessor.getInstance().executeCommand(this.project, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            JetNamedFunction patternFunction = psiFactory.createFunction(signatureString);
                            JetTypeReference newTypeRef = MyAction.this.function.setTypeReference(patternFunction.getTypeReference());
                            if (newTypeRef != null) {
                                ShortenReferences.DEFAULT.process(newTypeRef);
                            }
                            JetParameterList newParameterList = (JetParameterList)MyAction.this.function.getValueParameterList().replace((PsiElement)patternFunction.getValueParameterList());
                            ShortenReferences.DEFAULT.process(newParameterList);
                        }
                    });
                }
            }, JetBundle.message("change.function.signature.action", new Object[0]), null);
        }

        private void chooseSignatureAndChange() {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)this.getSignaturePopup()).showInBestPositionFor(this.editor);
        }
    }

    private static interface ParameterChooser {
        @Nullable
        public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor var1, @NotNull ValueParameterDescriptor var2);
    }
}

