/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.PsiPackage;

public class ChangeToFunctionInvocationFix
extends JetIntentionAction<JetExpression> {
    public ChangeToFunctionInvocationFix(@NotNull JetExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeToFunctionInvocationFix", "<init>"));
        }
        super(element);
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("change.to.function.invocation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeToFunctionInvocationFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.to.function.invocation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeToFunctionInvocationFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeToFunctionInvocationFix", "invoke"));
        }
        JetExpression reference = (JetExpression)((JetExpression)this.element).copy();
        ((JetExpression)this.element).replace((PsiElement)PsiPackage.JetPsiFactory((PsiElement)file).createExpression(reference.getText() + "()"));
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetExpression> createAction(Diagnostic diagnostic) {
                if (diagnostic.getPsiElement() instanceof JetExpression) {
                    return new ChangeToFunctionInvocationFix((JetExpression)diagnostic.getPsiElement());
                }
                return null;
            }
        };
    }
}

