/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;

public class RemoveRightPartOfBinaryExpressionFix<T extends JetExpression>
extends JetIntentionAction<T>
implements CleanupFix {
    private final String message;

    public RemoveRightPartOfBinaryExpressionFix(@NotNull T element, String message) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemoveRightPartOfBinaryExpressionFix", "<init>"));
        }
        super(element);
        this.message = message;
    }

    public String getText() {
        return this.message;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("remove.right.part.of.binary.expression", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveRightPartOfBinaryExpressionFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemoveRightPartOfBinaryExpressionFix", "invoke"));
        }
        this.invoke();
    }

    @NotNull
    public JetExpression invoke() throws IncorrectOperationException {
        PsiElement parent;
        JetExpression newExpression2 = null;
        if (this.element instanceof JetBinaryExpression) {
            newExpression2 = (JetExpression)((JetExpression)this.element).replace((PsiElement)((JetBinaryExpression)((JetExpression)this.element).copy()).getLeft());
        } else if (this.element instanceof JetBinaryExpressionWithTypeRHS) {
            newExpression2 = (JetExpression)((JetExpression)this.element).replace((PsiElement)((JetBinaryExpressionWithTypeRHS)((JetExpression)this.element).copy()).getLeft());
        }
        PsiElement psiElement = parent = newExpression2 != null ? newExpression2.getParent() : null;
        if (parent instanceof JetParenthesizedExpression && JetPsiUtil.areParenthesesUseless((JetParenthesizedExpression)parent)) {
            newExpression2 = (JetExpression)parent.replace((PsiElement)newExpression2);
        }
        JetExpression jetExpression = newExpression2;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveRightPartOfBinaryExpressionFix", "invoke"));
        }
        return jetExpression;
    }

    public static JetSingleIntentionActionFactory createRemoveTypeFromBinaryExpressionFactory(final String message) {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetBinaryExpressionWithTypeRHS> createAction(Diagnostic diagnostic) {
                JetBinaryExpressionWithTypeRHS expression2 = QuickFixUtil.getParentElementOfType(diagnostic, JetBinaryExpressionWithTypeRHS.class);
                if (expression2 == null) {
                    return null;
                }
                return new RemoveRightPartOfBinaryExpressionFix<JetBinaryExpressionWithTypeRHS>(expression2, message);
            }
        };
    }

    public static JetSingleIntentionActionFactory createRemoveElvisOperatorFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetBinaryExpression> createAction(Diagnostic diagnostic) {
                JetBinaryExpression expression2 = QuickFixUtil.getParentElementOfType(diagnostic, JetBinaryExpression.class);
                if (expression2 == null) {
                    return null;
                }
                return new RemoveRightPartOfBinaryExpressionFix<JetBinaryExpression>(expression2, JetBundle.message("remove.elvis.operator", new Object[0]));
            }
        };
    }

    @Override
    @Nullable
    public PsiElement elementToBeInvalidated() {
        return null;
    }
}

