/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.refactoring.JetNameValidator;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.JetScopeUtils;

public class JetNameValidatorImpl
extends JetNameValidator {
    private final PsiElement myContainer;
    private final PsiElement myAnchor;
    private final Target myTarget;

    public JetNameValidatorImpl(PsiElement container2, PsiElement anchor2, Target target) {
        this.myContainer = container2;
        this.myAnchor = anchor2;
        this.myTarget = target;
    }

    @Override
    protected boolean validateInner(String name2) {
        PsiElement sibling;
        HashSet<JetScope> visitedScopes = new HashSet<JetScope>();
        if (this.myAnchor != null) {
            sibling = this.myAnchor;
        } else {
            if (this.myContainer instanceof JetExpression) {
                return this.checkElement(name2, this.myContainer, visitedScopes);
            }
            sibling = this.myContainer.getFirstChild();
        }
        while (sibling != null) {
            if (!this.checkElement(name2, sibling, visitedScopes)) {
                return false;
            }
            sibling = sibling.getNextSibling();
        }
        return true;
    }

    private boolean checkElement(String name2, PsiElement sibling, final Set<JetScope> visitedScopes) {
        if (!(sibling instanceof JetElement)) {
            return true;
        }
        final BindingContext context2 = ResolvePackage.analyze((JetElement)sibling, BodyResolveMode.FULL);
        final Name identifier = Name.identifier(name2);
        final Ref result2 = new Ref((Object)true);
        JetVisitorVoid visitor2 = new JetVisitorVoid(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/JetNameValidatorImpl$1", "visitElement"));
                }
                if (((Boolean)result2.get()).booleanValue()) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            @Override
            public void visitExpression(@NotNull JetExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/JetNameValidatorImpl$1", "visitExpression"));
                }
                JetScope resolutionScope = JetScopeUtils.getResolutionScope((PsiElement)expression2, context2);
                if (resolutionScope != null) {
                    boolean noConflict;
                    if (!visitedScopes.add(resolutionScope)) {
                        return;
                    }
                    if (JetNameValidatorImpl.this.myTarget == Target.PROPERTIES) {
                        noConflict = resolutionScope.getProperties(identifier).isEmpty() && resolutionScope.getLocalVariable(identifier) == null;
                    } else {
                        boolean bl = noConflict = resolutionScope.getFunctions(identifier).isEmpty() && resolutionScope.getClassifier(identifier) == null;
                    }
                    if (!noConflict) {
                        result2.set((Object)false);
                        return;
                    }
                }
                super.visitExpression(expression2);
            }
        };
        sibling.accept((PsiElementVisitor)visitor2);
        return (Boolean)result2.get();
    }

    public static enum Target {
        FUNCTIONS_AND_CLASSES,
        PROPERTIES;

    }
}

