/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetCallableParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureProcessor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetFunctionParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetPrimaryConstructorParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetSecondaryConstructorParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetValVar;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionCodeFragment;
import org.jetbrains.kotlin.psi.JetTypeCodeFragment;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.types.JetType;

public class JetChangeSignatureDialog
extends ChangeSignatureDialogBase<JetParameterInfo, PsiElement, Visibility, JetMethodDescriptor, ParameterTableModelItemBase<JetParameterInfo>, JetCallableParameterTableModel> {
    private final String commandName;

    public JetChangeSignatureDialog(Project project, @NotNull JetMethodDescriptor methodDescriptor, PsiElement context2, String commandName) {
        if (methodDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "<init>"));
        }
        super(project, (MethodDescriptor)methodDescriptor, false, context2);
        this.commandName = commandName;
    }

    protected LanguageFileType getFileType() {
        return JetFileType.INSTANCE;
    }

    protected JetCallableParameterTableModel createParametersInfoModel(JetMethodDescriptor descriptor2) {
        return JetChangeSignatureDialog.createParametersInfoModel(descriptor2, this.myDefaultValueContext);
    }

    @NotNull
    private static JetCallableParameterTableModel createParametersInfoModel(JetMethodDescriptor descriptor2, PsiElement defaultValueContext) {
        switch (descriptor2.getKind()) {
            case FUNCTION: {
                JetFunctionParameterTableModel jetFunctionParameterTableModel = new JetFunctionParameterTableModel(descriptor2, defaultValueContext);
                if (jetFunctionParameterTableModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createParametersInfoModel"));
                }
                return jetFunctionParameterTableModel;
            }
            case PRIMARY_CONSTRUCTOR: {
                JetPrimaryConstructorParameterTableModel jetPrimaryConstructorParameterTableModel = new JetPrimaryConstructorParameterTableModel(descriptor2, defaultValueContext);
                if (jetPrimaryConstructorParameterTableModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createParametersInfoModel"));
                }
                return jetPrimaryConstructorParameterTableModel;
            }
            case SECONDARY_CONSTRUCTOR: {
                JetSecondaryConstructorParameterTableModel jetSecondaryConstructorParameterTableModel = new JetSecondaryConstructorParameterTableModel(descriptor2, defaultValueContext);
                if (jetSecondaryConstructorParameterTableModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createParametersInfoModel"));
                }
                return jetSecondaryConstructorParameterTableModel;
            }
        }
        throw new AssertionError((Object)("Invalid kind: " + (Object)((Object)descriptor2.getKind())));
    }

    protected PsiCodeFragment createReturnTypeCodeFragment() {
        return JetChangeSignatureDialog.createReturnTypeCodeFragment(this.myProject, (JetMethodDescriptor)this.myMethod);
    }

    @NotNull
    private static PsiCodeFragment createReturnTypeCodeFragment(@NotNull Project project, @NotNull JetMethodDescriptor method) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createReturnTypeCodeFragment"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createReturnTypeCodeFragment"));
        }
        JetTypeCodeFragment jetTypeCodeFragment = PsiPackage.JetPsiFactory(project).createTypeCodeFragment(ChangeSignaturePackage.renderOriginalReturnType(method), method.getBaseDeclaration());
        if (jetTypeCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createReturnTypeCodeFragment"));
        }
        return jetTypeCodeFragment;
    }

    @Nullable
    public JetType getReturnType() {
        return JetChangeSignatureDialog.getType((JetTypeCodeFragment)this.myReturnTypeCodeFragment);
    }

    private static JetType getType(JetTypeCodeFragment typeCodeFragment) {
        return typeCodeFragment != null ? typeCodeFragment.getType() : null;
    }

    protected JComponent getRowPresentation(ParameterTableModelItemBase<JetParameterInfo> item, boolean selected, boolean focused) {
        JPanel panel = new JPanel(new BorderLayout());
        String valOrVar = "";
        if (((JetMethodDescriptor)this.myMethod).getKind() == JetMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR) {
            switch (((JetParameterInfo)item.parameter).getValOrVar()) {
                case None: {
                    valOrVar = "    ";
                    break;
                }
                case Val: {
                    valOrVar = "val ";
                    break;
                }
                case Var: {
                    valOrVar = "var ";
                }
            }
        }
        String parameterName = this.getPresentationName(item);
        String typeText = item.typeCodeFragment.getText();
        String defaultValue = item.defaultValueCodeFragment.getText();
        String separator = StringUtil.repeatSymbol((char)' ', (int)(this.getParamNamesMaxLength() - parameterName.length() + 1));
        String text = valOrVar + parameterName + ":" + separator + typeText;
        if (StringUtil.isNotEmpty((String)defaultValue)) {
            text = text + " // default value = " + defaultValue;
        }
        EditorTextField field = new EditorTextField(" " + text, this.getProject(), (FileType)this.getFileType()){

            protected boolean shouldHaveBorder() {
                return false;
            }
        };
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        font = new Font(font.getFontName(), font.getStyle(), 12);
        field.setFont(font);
        if (selected && focused) {
            panel.setBackground(UIUtil.getTableSelectionBackground());
            field.setAsRendererWithSelection(UIUtil.getTableSelectionBackground(), UIUtil.getTableSelectionForeground());
        } else {
            panel.setBackground(UIUtil.getTableBackground());
            if (selected && !focused) {
                panel.setBorder((Border)new DottedBorder(UIUtil.getTableForeground()));
            }
        }
        panel.add((Component)field, "West");
        return panel;
    }

    private String getPresentationName(ParameterTableModelItemBase<JetParameterInfo> item) {
        JetParameterInfo parameter = (JetParameterInfo)item.parameter;
        if (parameter == null) {
            return null;
        }
        if (parameter == ((JetCallableParameterTableModel)this.myParametersTableModel).getReceiver()) {
            return "<receiver>";
        }
        return parameter.getName();
    }

    private int getColumnTextMaxLength(Function<ParameterTableModelItemBase<JetParameterInfo>, String> nameFunction) {
        int len = 0;
        for (ParameterTableModelItemBase item : ((JetCallableParameterTableModel)this.myParametersTableModel).getItems()) {
            String text = (String)nameFunction.fun((Object)item);
            len = Math.max(len, text == null ? 0 : text.length());
        }
        return len;
    }

    private int getParamNamesMaxLength() {
        return this.getColumnTextMaxLength(new Function<ParameterTableModelItemBase<JetParameterInfo>, String>(){

            public String fun(ParameterTableModelItemBase<JetParameterInfo> item) {
                return JetChangeSignatureDialog.this.getPresentationName((ParameterTableModelItemBase<JetParameterInfo>)item);
            }
        });
    }

    private int getTypesMaxLength() {
        return this.getColumnTextMaxLength(new Function<ParameterTableModelItemBase<JetParameterInfo>, String>(){

            public String fun(ParameterTableModelItemBase<JetParameterInfo> item) {
                return item.typeCodeFragment == null ? null : item.typeCodeFragment.getText();
            }
        });
    }

    private int getDefaultValuesMaxLength() {
        return this.getColumnTextMaxLength(new Function<ParameterTableModelItemBase<JetParameterInfo>, String>(){

            public String fun(ParameterTableModelItemBase<JetParameterInfo> item) {
                return item.defaultValueCodeFragment == null ? null : item.defaultValueCodeFragment.getText();
            }
        });
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    protected boolean isEmptyRow(ParameterTableModelItemBase<JetParameterInfo> row) {
        if (!StringUtil.isEmpty((String)((JetParameterInfo)row.parameter).getName())) {
            return false;
        }
        return StringUtil.isEmpty((String)((JetParameterInfo)row.parameter).getTypeText());
    }

    @Nullable
    protected CallerChooserBase<PsiElement> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<PsiElement>> callback) {
        throw new UnsupportedOperationException();
    }

    protected JBTableRowEditor getTableEditor(final JTable t, final ParameterTableModelItemBase<JetParameterInfo> item) {
        return new JBTableRowEditor(){
            private final List<JComponent> components = new ArrayList<JComponent>();
            private final EditorTextField nameEditor;
            {
                this.nameEditor = new EditorTextField(((JetParameterInfo)item.parameter).getName(), JetChangeSignatureDialog.this.getProject(), (FileType)JetChangeSignatureDialog.this.getFileType());
            }

            private void updateNameEditor() {
                this.nameEditor.setEnabled(item.parameter != ((JetCallableParameterTableModel)JetChangeSignatureDialog.this.myParametersTableModel).getReceiver());
            }

            private boolean isDefaultColumnEnabled() {
                return ((JetParameterInfo)item.parameter).getIsNewParameter() && item.parameter != ((JetMethodDescriptor)JetChangeSignatureDialog.this.myMethod).getReceiver();
            }

            public void prepareEditor(JTable table, final int row) {
                this.setLayout(new BoxLayout((Container)((Object)this), 0));
                int column = 0;
                for (ColumnInfo columnInfo : ((JetCallableParameterTableModel)JetChangeSignatureDialog.this.myParametersTableModel).getColumnInfos()) {
                    Object component;
                    Document document;
                    JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                    EditorTextField editor = null;
                    final int columnFinal = column;
                    if (JetCallableParameterTableModel.isTypeColumn(columnInfo)) {
                        document = PsiDocumentManager.getInstance((Project)JetChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.typeCodeFragment);
                        component = editor = new EditorTextField(document, JetChangeSignatureDialog.this.getProject(), (FileType)JetChangeSignatureDialog.this.getFileType());
                    } else if (JetCallableParameterTableModel.isNameColumn(columnInfo)) {
                        component = editor = this.nameEditor;
                        this.updateNameEditor();
                    } else if (JetCallableParameterTableModel.isDefaultValueColumn(columnInfo) && this.isDefaultColumnEnabled()) {
                        document = PsiDocumentManager.getInstance((Project)JetChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.defaultValueCodeFragment);
                        component = editor = new EditorTextField(document, JetChangeSignatureDialog.this.getProject(), (FileType)JetChangeSignatureDialog.this.getFileType());
                    } else if (JetPrimaryConstructorParameterTableModel.isValVarColumn(columnInfo)) {
                        JComboBox<JetValVar> comboBox = new JComboBox<JetValVar>(JetValVar.values());
                        comboBox.setSelectedItem((Object)((JetParameterInfo)item.parameter).getValOrVar());
                        comboBox.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(@NotNull ItemEvent e) {
                                if (e == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog$5$1", "itemStateChanged"));
                                }
                                ((JetCallableParameterTableModel)JetChangeSignatureDialog.this.myParametersTableModel).setValueAtWithoutUpdate(e.getItem(), row, columnFinal);
                                JetChangeSignatureDialog.this.updateSignature();
                            }
                        });
                        component = comboBox;
                    } else {
                        if (!JetFunctionParameterTableModel.isReceiverColumn(columnInfo)) continue;
                        JCheckBox checkBox = new JCheckBox();
                        checkBox.setSelected(((JetCallableParameterTableModel)JetChangeSignatureDialog.this.myParametersTableModel).getReceiver() == item.parameter);
                        checkBox.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(@NotNull ItemEvent e) {
                                if (e == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog$5$2", "itemStateChanged"));
                                }
                                ((JetFunctionParameterTableModel)JetChangeSignatureDialog.this.myParametersTableModel).setReceiver(e.getStateChange() == 1 ? (JetParameterInfo)item.parameter : null);
                                JetChangeSignatureDialog.this.updateSignature();
                                this.updateNameEditor();
                            }
                        });
                        component = checkBox;
                    }
                    JBLabel label = new JBLabel(columnInfo.getName(), UIUtil.ComponentStyle.SMALL);
                    panel.add((Component)label);
                    if (editor != null) {
                        editor.addDocumentListener((DocumentListener)new DocumentAdapter(){

                            public void documentChanged(DocumentEvent e) {
                                this.fireDocumentChanged(e, columnFinal);
                            }
                        });
                        editor.setPreferredWidth(t.getWidth() / ((JetCallableParameterTableModel)JetChangeSignatureDialog.this.myParametersTableModel).getColumnCount());
                    }
                    this.components.add((JComponent)component);
                    panel.add((Component)component);
                    this.add(panel);
                    IJSwingUtilities.adjustComponentsOnMac((JLabel)label, (JComponent)component);
                    ++column;
                }
            }

            public JBTableRow getValue() {
                return new JBTableRow(){

                    public Object getValueAt(int column) {
                        ColumnInfo columnInfo = ((JetCallableParameterTableModel)JetChangeSignatureDialog.this.myParametersTableModel).getColumnInfos()[column];
                        if (JetPrimaryConstructorParameterTableModel.isValVarColumn(columnInfo)) {
                            return ((JComboBox)components.get(column)).getSelectedItem();
                        }
                        if (JetCallableParameterTableModel.isTypeColumn(columnInfo)) {
                            return item.typeCodeFragment;
                        }
                        if (JetCallableParameterTableModel.isNameColumn(columnInfo)) {
                            return ((EditorTextField)components.get(column)).getText();
                        }
                        if (JetCallableParameterTableModel.isDefaultValueColumn(columnInfo)) {
                            return item.defaultValueCodeFragment;
                        }
                        return null;
                    }
                };
            }

            private int getColumnWidth(int letters) {
                Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
                font = new Font(font.getFontName(), font.getStyle(), 12);
                return letters * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W");
            }

            private int getEditorIndex(int x) {
                int i;
                int[] nArray;
                if (this.isDefaultColumnEnabled()) {
                    int[] nArray2 = new int[4];
                    nArray2[0] = 4;
                    nArray2[1] = JetChangeSignatureDialog.this.getParamNamesMaxLength();
                    nArray2[2] = JetChangeSignatureDialog.this.getTypesMaxLength();
                    nArray = nArray2;
                    nArray2[3] = JetChangeSignatureDialog.this.getDefaultValuesMaxLength();
                } else {
                    int[] nArray3 = new int[3];
                    nArray3[0] = 4;
                    nArray3[1] = JetChangeSignatureDialog.this.getParamNamesMaxLength();
                    nArray = nArray3;
                    nArray3[2] = JetChangeSignatureDialog.this.getTypesMaxLength();
                }
                int[] columnLetters = nArray;
                int columnIndex = 0;
                int n = i = ((JetMethodDescriptor)JetChangeSignatureDialog.this.myMethod).getKind() == JetMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR ? 0 : 1;
                while (i < columnLetters.length) {
                    int width = this.getColumnWidth(columnLetters[i]);
                    if (x <= width) {
                        return columnIndex;
                    }
                    ++columnIndex;
                    x -= width;
                    ++i;
                }
                return columnIndex - 1;
            }

            public JComponent getPreferredFocusedComponent() {
                MouseEvent me = this.getMouseEvent();
                int index2 = me != null ? this.getEditorIndex((int)me.getPoint().getX()) : (((JetMethodDescriptor)JetChangeSignatureDialog.this.myMethod).getKind() == JetMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR ? 1 : 0);
                JComponent component = this.components.get(index2);
                return component instanceof EditorTextField ? ((EditorTextField)component).getFocusTarget() : component;
            }

            public JComponent[] getFocusableComponents() {
                JComponent[] focusable = new JComponent[this.components.size()];
                for (int i = 0; i < this.components.size(); ++i) {
                    focusable[i] = this.components.get(i);
                    if (!(focusable[i] instanceof EditorTextField)) continue;
                    focusable[i] = ((EditorTextField)focusable[i]).getFocusTarget();
                }
                return focusable;
            }
        };
    }

    protected String calculateSignature() {
        JetChangeInfo changeInfo = JetChangeSignatureDialog.evaluateChangeInfo((JetCallableParameterTableModel)this.myParametersTableModel, this.myReturnTypeCodeFragment, this.getMethodDescriptor(), (Visibility)this.getVisibility(), this.getMethodName(), this.myDefaultValueContext);
        return changeInfo.getNewSignature(this.getMethodDescriptor().getOriginalPrimaryFunction());
    }

    protected VisibilityPanelBase<Visibility> createVisibilityControl() {
        return new ComboBoxVisibilityPanel((Object[])new Visibility[]{Visibilities.INTERNAL, Visibilities.PRIVATE, Visibilities.PROTECTED, Visibilities.PUBLIC});
    }

    protected void updateSignatureAlarmFired() {
        super.updateSignatureAlarmFired();
        this.validateButtons();
    }

    @Nullable
    protected String validateAndCommitData() {
        return null;
    }

    protected void canRun() throws ConfigurationException {
        if (this.myNamePanel.isVisible() && ((JetMethodDescriptor)this.myMethod).canChangeName() && !JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(this.getMethodName())) {
            throw new ConfigurationException(JetRefactoringBundle.message("function.name.is.invalid", new Object[0]));
        }
        if (((JetMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && this.getReturnType() == null) {
            throw new ConfigurationException(JetRefactoringBundle.message("return.type.is.invalid", new Object[0]));
        }
        List parameterInfos = ((JetCallableParameterTableModel)this.myParametersTableModel).getItems();
        for (ParameterTableModelItemBase item : parameterInfos) {
            String parameterName = ((JetParameterInfo)item.parameter).getName();
            if (item.parameter != ((JetCallableParameterTableModel)this.myParametersTableModel).getReceiver() && !JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(parameterName)) {
                throw new ConfigurationException(JetRefactoringBundle.message("parameter.name.is.invalid", parameterName));
            }
            if (JetChangeSignatureDialog.getType((JetTypeCodeFragment)item.typeCodeFragment) != null) continue;
            throw new ConfigurationException(JetRefactoringBundle.message("parameter.type.is.invalid", item.typeCodeFragment.getText()));
        }
    }

    @NotNull
    protected BaseRefactoringProcessor createRefactoringProcessor() {
        JetChangeInfo changeInfo = JetChangeSignatureDialog.evaluateChangeInfo((JetCallableParameterTableModel)this.myParametersTableModel, this.myReturnTypeCodeFragment, this.getMethodDescriptor(), (Visibility)this.getVisibility(), this.getMethodName(), this.myDefaultValueContext);
        JetChangeSignatureProcessor jetChangeSignatureProcessor = new JetChangeSignatureProcessor(this.myProject, changeInfo, this.commandName != null ? this.commandName : this.getTitle());
        if (jetChangeSignatureProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createRefactoringProcessor"));
        }
        return jetChangeSignatureProcessor;
    }

    @NotNull
    public static BaseRefactoringProcessor createRefactoringProcessorForSilentChangeSignature(@NotNull Project project, @NotNull String commandName, @NotNull JetMethodDescriptor method, @NotNull PsiElement defaultValueContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createRefactoringProcessorForSilentChangeSignature"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createRefactoringProcessorForSilentChangeSignature"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createRefactoringProcessorForSilentChangeSignature"));
        }
        if (defaultValueContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValueContext", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createRefactoringProcessorForSilentChangeSignature"));
        }
        JetCallableParameterTableModel parameterTableModel = JetChangeSignatureDialog.createParametersInfoModel(method, defaultValueContext);
        parameterTableModel.setParameterInfos(method.getParameters());
        JetChangeInfo changeInfo = JetChangeSignatureDialog.evaluateChangeInfo(parameterTableModel, JetChangeSignatureDialog.createReturnTypeCodeFragment(project, method), method, (Visibility)method.getVisibility(), method.getName(), defaultValueContext);
        JetChangeSignatureProcessor jetChangeSignatureProcessor = new JetChangeSignatureProcessor(project, changeInfo, commandName);
        if (jetChangeSignatureProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "createRefactoringProcessorForSilentChangeSignature"));
        }
        return jetChangeSignatureProcessor;
    }

    @NotNull
    public JetMethodDescriptor getMethodDescriptor() {
        JetMethodDescriptor jetMethodDescriptor = (JetMethodDescriptor)this.myMethod;
        if (jetMethodDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "getMethodDescriptor"));
        }
        return jetMethodDescriptor;
    }

    private static JetChangeInfo evaluateChangeInfo(@NotNull JetCallableParameterTableModel parametersModel, @Nullable PsiCodeFragment returnTypeCodeFragment, @NotNull JetMethodDescriptor methodDescriptor, @Nullable Visibility visibility, @NotNull String methodName, @NotNull PsiElement defaultValueContext) {
        if (parametersModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersModel", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "evaluateChangeInfo"));
        }
        if (methodDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "evaluateChangeInfo"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "evaluateChangeInfo"));
        }
        if (defaultValueContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValueContext", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureDialog", "evaluateChangeInfo"));
        }
        ArrayList<Object> parameters2 = new ArrayList<Object>(parametersModel.getRowCount());
        for (ParameterTableModelItemBase parameter : parametersModel.getItems()) {
            ((JetParameterInfo)parameter.parameter).setCurrentTypeText(parameter.typeCodeFragment.getText().trim());
            parameters2.add(parameter.parameter);
            JetExpressionCodeFragment codeFragment = (JetExpressionCodeFragment)parameter.defaultValueCodeFragment;
            JetExpression oldDefaultValue = ((JetParameterInfo)parameter.parameter).getDefaultValueForCall();
            if (codeFragment.getText().equals(oldDefaultValue != null ? oldDefaultValue.getText() : "")) continue;
            ((JetParameterInfo)parameter.parameter).setDefaultValueForCall(codeFragment.getContentElement());
        }
        String returnTypeText = returnTypeCodeFragment != null ? returnTypeCodeFragment.getText().trim() : "";
        JetMethodDescriptor descriptor2 = methodDescriptor instanceof JetMutableMethodDescriptor ? ((JetMutableMethodDescriptor)methodDescriptor).getOriginal() : methodDescriptor;
        JetType returnType2 = JetChangeSignatureDialog.getType((JetTypeCodeFragment)returnTypeCodeFragment);
        return new JetChangeInfo(descriptor2, methodName, returnType2, returnTypeText, visibility, parameters2, parametersModel.getReceiver(), defaultValueContext);
    }

    protected int getSelectedIdx() {
        List parameters2 = ((JetMethodDescriptor)this.myMethod).getParameters();
        for (int i = 0; i < parameters2.size(); ++i) {
            JetParameterInfo info = (JetParameterInfo)parameters2.get(i);
            if (!info.getIsNewParameter()) continue;
            return i;
        }
        return super.getSelectedIdx();
    }
}

