/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightClassForPackage;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.run.JetRunConfigurationEditor;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class JetRunConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule>
implements CommonJavaRunConfigurationParameters {
    public String MAIN_CLASS_NAME;
    public String VM_PARAMETERS;
    public String PROGRAM_PARAMETERS;
    public String WORKING_DIRECTORY;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    private Map<String, String> myEnvs = new LinkedHashMap<String, String>();
    public boolean PASS_PARENT_ENVS = true;

    public JetRunConfiguration(String name2, RunConfigurationModule runConfigurationModule, ConfigurationFactory factory2) {
        super(name2, runConfigurationModule, factory2);
        runConfigurationModule.init();
    }

    public Collection<Module> getValidModules() {
        return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
    }

    protected ModuleBasedConfiguration createInstance() {
        return new JetRunConfiguration(this.getName(), this.getConfigurationModule(), this.getFactory());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JetRunConfigurationEditor(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        this.readModule(element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getEnvs());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        this.writeModule(element);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getEnvs());
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    public void setVMParameters(String value2) {
        this.VM_PARAMETERS = value2;
    }

    public String getVMParameters() {
        return this.VM_PARAMETERS;
    }

    public void setProgramParameters(String value2) {
        this.PROGRAM_PARAMETERS = value2;
    }

    public String getProgramParameters() {
        return this.PROGRAM_PARAMETERS;
    }

    public void setWorkingDirectory(String value2) {
        this.WORKING_DIRECTORY = ExternalizablePath.urlValue((String)value2);
    }

    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue((String)this.WORKING_DIRECTORY);
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.PASS_PARENT_ENVS = passParentEnvs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.myEnvs;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getEnvs"));
        }
        return map2;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "setEnvs"));
        }
        this.myEnvs = envs;
    }

    public boolean isPassParentEnvs() {
        return this.PASS_PARENT_ENVS;
    }

    public String getRunClass() {
        return this.MAIN_CLASS_NAME;
    }

    public void setRunClass(String value2) {
        this.MAIN_CLASS_NAME = value2;
    }

    public String getPackage() {
        return null;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String path) {
        this.ALTERNATIVE_JRE_PATH = path;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getState"));
        }
        if (executionEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionEnvironment", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getState"));
        }
        MyJavaCommandLineState state = new MyJavaCommandLineState(this, executionEnvironment);
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject()));
        return state;
    }

    private static class MyJavaCommandLineState
    extends JavaCommandLineState {
        private final JetRunConfiguration myConfiguration;

        public MyJavaCommandLineState(@NotNull JetRunConfiguration configuration, ExecutionEnvironment environment) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "<init>"));
            }
            super(environment);
            this.myConfiguration = configuration;
        }

        protected JavaParameters createJavaParameters() throws ExecutionException {
            JavaParameters params2 = new JavaParameters();
            RunConfigurationModule module = this.myConfiguration.getConfigurationModule();
            int classPathType = this.getClasspathType(module);
            String jreHome = this.myConfiguration.ALTERNATIVE_JRE_PATH_ENABLED ? this.myConfiguration.ALTERNATIVE_JRE_PATH : null;
            JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)params2, (int)classPathType, (String)jreHome);
            JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params2, (CommonJavaRunConfigurationParameters)this.myConfiguration);
            params2.setMainClass(this.myConfiguration.getRunClass());
            return params2;
        }

        private int getClasspathType(RunConfigurationModule configurationModule) throws CantRunException {
            VirtualFile virtualFileForMainFun;
            Module module = configurationModule.getModule();
            if (module == null) {
                throw CantRunException.noModuleConfigured((String)configurationModule.getModuleName());
            }
            String runClass = this.myConfiguration.getRunClass();
            if (runClass == null) {
                throw new CantRunException(String.format("Run class should be defined for configuration '%s'", this.myConfiguration.getName()));
            }
            PsiClass psiClass = JavaExecutionUtil.findMainClass((Module)module, (String)runClass);
            if (psiClass == null) {
                throw CantRunException.classNotFound((String)runClass, (Module)module);
            }
            JetNamedFunction mainFun = this.findMainFun(module, psiClass);
            if (mainFun == null) {
                throw new CantRunException(this.noFunctionFoundMessage(psiClass));
            }
            Module classModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)mainFun);
            if (classModule == null) {
                classModule = module;
            }
            if ((virtualFileForMainFun = mainFun.getContainingFile().getVirtualFile()) == null) {
                throw new CantRunException(this.noFunctionFoundMessage(psiClass));
            }
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)classModule).getFileIndex();
            if (fileIndex.isInSourceContent(virtualFileForMainFun)) {
                if (fileIndex.isInTestSourceContent(virtualFileForMainFun)) {
                    return 7;
                }
                return 3;
            }
            List entriesForFile = fileIndex.getOrderEntriesForFile(virtualFileForMainFun);
            for (OrderEntry entry : entriesForFile) {
                if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.TEST) continue;
                return 7;
            }
            return 3;
        }

        @NotNull
        private String noFunctionFoundMessage(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "noFunctionFoundMessage"));
            }
            FqName classFqName = new FqName(psiClass.getQualifiedName());
            if (psiClass instanceof KotlinLightClassForExplicitDeclaration) {
                String string = String.format("Function 'main' not found in class '%s'", classFqName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "noFunctionFoundMessage"));
                }
                return string;
            }
            String string = String.format("Top-level function 'main' not found in package '%s'", classFqName.parent());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "noFunctionFoundMessage"));
            }
            return string;
        }

        @NotNull
        private Collection<JetNamedFunction> getMainFunCandidates(@NotNull Module module, @NotNull PsiClass psiClass) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "getMainFunCandidates"));
            }
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "getMainFunCandidates"));
            }
            if (psiClass instanceof KotlinLightClassForPackage) {
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null) {
                    List<JetNamedFunction> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "getMainFunCandidates"));
                    }
                    return list;
                }
                FqName mainFunFqName = new FqName(qualifiedName).parent().child(Name.identifier("main"));
                Collection<JetNamedFunction> collection = JetTopLevelFunctionFqnNameIndex.getInstance().get(mainFunFqName.asString(), module.getProject(), module.getModuleRuntimeScope(true));
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "getMainFunCandidates"));
                }
                return collection;
            }
            List list = KotlinPackage.filterNotNull((Iterable)KotlinPackage.map((Object[])psiClass.findMethodsByName("main", false), (Function1)new Function1<PsiMethod, JetNamedFunction>(){

                public JetNamedFunction invoke(PsiMethod method) {
                    if (!(method instanceof KotlinLightMethod)) {
                        return null;
                    }
                    JetDeclaration declaration = ((KotlinLightMethod)method).getOrigin();
                    return declaration instanceof JetNamedFunction ? (JetNamedFunction)declaration : null;
                }
            }));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "getMainFunCandidates"));
            }
            return list;
        }

        @Nullable
        private JetNamedFunction findMainFun(@NotNull Module module, @NotNull PsiClass psiClass) throws CantRunException {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "findMainFun"));
            }
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "findMainFun"));
            }
            for (JetNamedFunction function2 : this.getMainFunCandidates(module, psiClass)) {
                BindingContext bindingContext2 = ResolvePackage.analyze(function2, BodyResolveMode.FULL);
                MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(bindingContext2);
                if (!mainFunctionDetector.isMain(function2)) continue;
                return function2;
            }
            return null;
        }
    }
}

