/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.AsJavaPackage;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.search.usagesSearch.KotlinPsiSearchHelper;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchLocation;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchPackage;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchRequestItem;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchTarget;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;

public class KotlinReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public static void processJetClassOrObject(final @NotNull JetClassOrObject element, @NotNull ReferencesSearch.SearchParameters queryParameters) {
        PsiClass lightClass;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearcher", "processJetClassOrObject"));
        }
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearcher", "processJetClassOrObject"));
        }
        String className = element.getName();
        if (className != null && (lightClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return LightClassUtil.getPsiClass(element);
            }
        })) != null) {
            PsiField fieldForCompanionObject;
            KotlinReferencesSearcher.searchNamedElement(queryParameters, (PsiNamedElement)lightClass, className);
            if (element instanceof JetObjectDeclaration && ((JetObjectDeclaration)element).isCompanion() && (fieldForCompanionObject = (PsiField)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiField>(){

                public PsiField compute() {
                    return LightClassUtil.getLightFieldForCompanionObject(element);
                }
            })) != null) {
                KotlinReferencesSearcher.searchNamedElement(queryParameters, (PsiNamedElement)fieldForCompanionObject);
            }
        }
    }

    public void processQuery(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer2) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearcher", "processQuery"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearcher", "processQuery"));
        }
        PsiElement element = queryParameters.getElementToSearch();
        final PsiNamedElement unwrappedElement = AsJavaPackage.getNamedUnwrappedElement(element);
        if (unwrappedElement == null || !ProjectRootsUtil.isInProjectOrLibSource((PsiElement)unwrappedElement)) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                KotlinPsiSearchHelper searchHelper = new KotlinPsiSearchHelper(queryParameters.getElementToSearch().getProject());
                UsagesSearchTarget<PsiNamedElement> searchTarget = new UsagesSearchTarget<PsiNamedElement>(unwrappedElement, queryParameters.getEffectiveSearchScope(), UsagesSearchLocation.EVERYWHERE, false);
                UsagesSearchRequestItem requestItem = new UsagesSearchRequestItem(searchTarget, UsagesSearchPackage.getSpecialNamesToSearch(unwrappedElement), UsagesSearchPackage.getIsTargetUsage(), null);
                searchHelper.processFilesWithText(requestItem, (Processor<PsiReference>)consumer2);
            }
        });
        KotlinReferencesSearcher.searchLightElements(queryParameters, element);
    }

    private static void searchLightElements(ReferencesSearch.SearchParameters queryParameters, PsiElement element) {
        if (element instanceof JetClassOrObject) {
            KotlinReferencesSearcher.processJetClassOrObject((JetClassOrObject)element, queryParameters);
        } else if (element instanceof JetNamedFunction || element instanceof JetSecondaryConstructor) {
            final JetFunction function2 = (JetFunction)element;
            String name2 = function2.getName();
            if (name2 != null) {
                PsiMethod method = (PsiMethod)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod>(){

                    public PsiMethod compute() {
                        return LightClassUtil.getLightClassMethod(function2);
                    }
                });
                KotlinReferencesSearcher.searchNamedElement(queryParameters, (PsiNamedElement)method);
            }
        } else if (element instanceof JetProperty) {
            final JetProperty property = (JetProperty)element;
            LightClassUtil.PropertyAccessorsPsiMethods propertyMethods2 = (LightClassUtil.PropertyAccessorsPsiMethods)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LightClassUtil.PropertyAccessorsPsiMethods>(){

                public LightClassUtil.PropertyAccessorsPsiMethods compute() {
                    return LightClassUtil.getLightClassPropertyMethods(property);
                }
            });
            KotlinReferencesSearcher.searchNamedElement(queryParameters, (PsiNamedElement)propertyMethods2.getGetter());
            KotlinReferencesSearcher.searchNamedElement(queryParameters, (PsiNamedElement)propertyMethods2.getSetter());
        } else if (element instanceof KotlinLightMethod) {
            JetDeclaration declaration = ((KotlinLightMethod)element).getOrigin();
            if (declaration instanceof JetProperty || declaration instanceof JetParameter && ((JetParameter)declaration).hasValOrVarNode()) {
                KotlinReferencesSearcher.searchNamedElement(queryParameters, (PsiNamedElement)declaration);
            } else if (declaration instanceof JetPropertyAccessor) {
                KotlinReferencesSearcher.searchNamedElement(queryParameters, (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)declaration, JetProperty.class));
            }
        }
    }

    private static void searchNamedElement(ReferencesSearch.SearchParameters queryParameters, PsiNamedElement element) {
        KotlinReferencesSearcher.searchNamedElement(queryParameters, element, element != null ? element.getName() : null);
    }

    private static void searchNamedElement(ReferencesSearch.SearchParameters queryParameters, PsiNamedElement element, @Nullable String name2) {
        if (name2 != null) {
            queryParameters.getOptimizer().searchWord(name2, queryParameters.getEffectiveSearchScope(), true, (PsiElement)element);
        }
    }
}

