/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.structureView.KotlinStructureElementPresentation;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetParameter;

public class JetStructureViewElement
implements StructureViewTreeElement,
Queryable {
    private final NavigatablePsiElement element;
    private final boolean isInherited;
    private KotlinStructureElementPresentation presentation;

    public JetStructureViewElement(@NotNull NavigatablePsiElement element, @NotNull DeclarationDescriptor descriptor2, boolean isInherited) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "<init>"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "<init>"));
        }
        this.element = element;
        this.isInherited = isInherited;
        if (!(element instanceof JetElement)) {
            this.presentation = new KotlinStructureElementPresentation(this.isInherited(), element, descriptor2);
        }
    }

    public JetStructureViewElement(@NotNull NavigatablePsiElement element, boolean isInherited) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "<init>"));
        }
        this.element = element;
        this.isInherited = isInherited;
    }

    public JetStructureViewElement(@NotNull JetFile fileElement) {
        if (fileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileElement", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "<init>"));
        }
        this.element = fileElement;
        this.isInherited = false;
    }

    @NotNull
    public NavigatablePsiElement getElement() {
        NavigatablePsiElement navigatablePsiElement = this.element;
        if (navigatablePsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "getElement"));
        }
        return navigatablePsiElement;
    }

    public Object getValue() {
        return this.element;
    }

    public void navigate(boolean requestFocus) {
        this.element.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.element.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.element.canNavigateToSource();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        if (this.presentation == null) {
            this.presentation = new KotlinStructureElementPresentation(this.isInherited(), this.element, this.getDescriptor());
        }
        KotlinStructureElementPresentation kotlinStructureElementPresentation = this.presentation;
        if (kotlinStructureElementPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "getPresentation"));
        }
        return kotlinStructureElementPresentation;
    }

    @NotNull
    public TreeElement[] getChildren() {
        List<JetDeclaration> childrenDeclarations = this.getChildrenDeclarations();
        TreeElement[] treeElementArray = (TreeElement[])ArrayUtil.toObjectArray((Collection)ContainerUtil.map(childrenDeclarations, (Function)new Function<JetDeclaration, TreeElement>(){

            public TreeElement fun(JetDeclaration declaration) {
                return new JetStructureViewElement(declaration, false);
            }
        }), TreeElement.class);
        if (treeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "getChildren"));
        }
        return treeElementArray;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "putInfo"));
        }
        info.put("text", this.getPresentation().getPresentableText());
        info.put("location", this.getPresentation().getLocationString());
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    @Nullable
    private DeclarationDescriptor getDescriptor() {
        if (!this.element.isValid() || !(this.element instanceof JetDeclaration)) {
            return null;
        }
        final JetDeclaration declaration = (JetDeclaration)this.element;
        if (declaration instanceof JetClassInitializer) {
            return null;
        }
        return (DeclarationDescriptor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DeclarationDescriptor>(){

            public DeclarationDescriptor compute() {
                if (!DumbService.isDumb((Project)JetStructureViewElement.this.element.getProject())) {
                    return ResolvePackage.resolveToDescriptor(declaration);
                }
                return null;
            }
        });
    }

    @NotNull
    private List<JetDeclaration> getChildrenDeclarations() {
        if (this.element instanceof JetFile) {
            JetFile jetFile = (JetFile)this.element;
            List<JetDeclaration> list = jetFile.getDeclarations();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "getChildrenDeclarations"));
            }
            return list;
        }
        if (this.element instanceof JetClass) {
            JetClass jetClass = (JetClass)this.element;
            ArrayList<JetDeclaration> declarations2 = new ArrayList<JetDeclaration>();
            for (JetParameter parameter : jetClass.getPrimaryConstructorParameters()) {
                if (!parameter.hasValOrVarNode()) continue;
                declarations2.add(parameter);
            }
            declarations2.addAll(jetClass.getDeclarations());
            ArrayList<JetDeclaration> arrayList = declarations2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "getChildrenDeclarations"));
            }
            return arrayList;
        }
        if (this.element instanceof JetClassOrObject) {
            List<JetDeclaration> list = ((JetClassOrObject)this.element).getDeclarations();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "getChildrenDeclarations"));
            }
            return list;
        }
        List<JetDeclaration> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/JetStructureViewElement", "getChildrenDeclarations"));
        }
        return list;
    }
}

