/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.idea.stubindex.JetAnnotationsIndex;
import org.jetbrains.kotlin.idea.stubindex.JetClassShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetExactPackagesIndex;
import org.jetbrains.kotlin.idea.stubindex.JetFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetProbablyNothingFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetProbablyNothingPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetSuperClassIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelFunctionByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelPropertyByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.StubindexPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.util.UtilPackage;

public class StubIndexServiceImpl
implements StubIndexService {
    @Override
    public void indexFile(KotlinFileStub stub, IndexSink sink) {
        FqName packageFqName = stub.getPackageFqName();
        sink.occurrence(JetExactPackagesIndex.getInstance().getKey(), (Object)packageFqName.asString());
    }

    @Override
    public void indexClass(KotlinClassStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(JetClassShortNameIndex.getInstance().getKey(), (Object)name2);
        }
        if ((fqName2 = stub.getFqName()) != null) {
            sink.occurrence(JetFullClassNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            if (stub.isTopLevel()) {
                sink.occurrence(JetTopLevelClassByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            }
        }
        StubIndexServiceImpl.indexSuperNames(stub, sink);
    }

    @Override
    public void indexObject(KotlinObjectStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(JetClassShortNameIndex.getInstance().getKey(), (Object)name2);
        }
        if ((fqName2 = stub.getFqName()) != null) {
            sink.occurrence(JetFullClassNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            if (stub.isTopLevel()) {
                sink.occurrence(JetTopLevelClassByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            }
        }
        StubIndexServiceImpl.indexSuperNames(stub, sink);
    }

    private static void indexSuperNames(KotlinClassOrObjectStub<? extends JetClassOrObject> stub, IndexSink sink) {
        for (String superName : stub.getSuperNames()) {
            sink.occurrence(JetSuperClassIndex.getInstance().getKey(), (Object)superName);
        }
    }

    @Override
    public void indexFunction(KotlinFunctionStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(JetFunctionShortNameIndex.getInstance().getKey(), (Object)name2);
            if (UtilPackage.isProbablyNothing(((JetNamedFunction)stub.getPsi()).getTypeReference())) {
                sink.occurrence(JetProbablyNothingFunctionShortNameIndex.getInstance().getKey(), (Object)name2);
            }
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(JetTopLevelFunctionFqnNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(JetTopLevelFunctionByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            StubindexPackage.indexTopLevelExtension(stub, sink);
        }
    }

    @Override
    public void indexProperty(KotlinPropertyStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(JetPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
            if (UtilPackage.isProbablyNothing(((JetProperty)stub.getPsi()).getTypeReference())) {
                sink.occurrence(JetProbablyNothingPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
            }
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(JetTopLevelPropertyFqnNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(JetTopLevelPropertyByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            StubindexPackage.indexTopLevelExtension(stub, sink);
        }
    }

    @Override
    public void indexAnnotation(KotlinAnnotationEntryStub stub, IndexSink sink) {
        sink.occurrence(JetAnnotationsIndex.getInstance().getKey(), (Object)stub.getShortName());
    }
}

