/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.ExternalIntegerKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class KotlinAbiVersionIndex
extends ScalarIndexExtension<Integer> {
    private static final Logger LOG = Logger.getInstance(KotlinAbiVersionIndex.class);
    public static final KotlinAbiVersionIndex INSTANCE = new KotlinAbiVersionIndex();
    private static final int VERSION = 1;
    private static final ID<Integer, Void> NAME = ID.create((String)KotlinAbiVersionIndex.class.getCanonicalName());
    private static final ExternalIntegerKeyDescriptor KEY_DESCRIPTOR = new ExternalIntegerKeyDescriptor();
    private static final FileBasedIndex.InputFilter INPUT_FILTER = new FileBasedIndex.InputFilter(){

        public boolean acceptInput(VirtualFile file) {
            return file.getFileType() == StdFileTypes.CLASS;
        }
    };
    private static final DataIndexer<Integer, Void, FileContent> INDEXER = new DataIndexer<Integer, Void, FileContent>(){
        private final Set<String> kotlinAnnotationsDesc = new ImmutableSet.Builder().add((Object)AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_CLASS_ANNOTATION)).add((Object)AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_PACKAGE_CLASS_ANNOTATION)).add((Object)AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_CLASS)).add((Object)AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_PACKAGE)).add((Object)AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_CLASS)).add((Object)AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE)).build();

        @NotNull
        public Map<Integer, Void> map(FileContent inputData) {
            final HashMap result2 = Maps.newHashMap();
            final Ref annotationPresent = new Ref((Object)false);
            try {
                ClassReader classReader = new ClassReader(inputData.getContent());
                classReader.accept(new ClassVisitor(327680){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (!kotlinAnnotationsDesc.contains(desc)) {
                            return null;
                        }
                        annotationPresent.set((Object)true);
                        return new AnnotationVisitor(327680){

                            public void visit(String name2, Object value2) {
                                if ("abiVersion".equals(name2)) {
                                    if (value2 instanceof Integer) {
                                        Integer abiVersion = (Integer)value2;
                                        result2.put(abiVersion, null);
                                    } else {
                                        result2.put(-1, null);
                                    }
                                }
                            }
                        };
                    }
                }, 7);
            }
            catch (Throwable e) {
                LOG.warn("Could not index ABI version for file " + inputData.getFile() + ": " + e.getMessage());
            }
            if (((Boolean)annotationPresent.get()).booleanValue() && result2.isEmpty()) {
                result2.put(-1, null);
            }
            HashMap hashMap = result2;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinAbiVersionIndex$2", "map"));
            }
            return hashMap;
        }
    };

    private KotlinAbiVersionIndex() {
    }

    @NotNull
    public ID<Integer, Void> getName() {
        ID<Integer, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinAbiVersionIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        DataIndexer<Integer, Void, FileContent> dataIndexer = INDEXER;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinAbiVersionIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    public KeyDescriptor<Integer> getKeyDescriptor() {
        return KEY_DESCRIPTOR;
    }

    public FileBasedIndex.InputFilter getInputFilter() {
        return INPUT_FILTER;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }
}

