/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinImportDirectiveStubImpl;

public class JetImportDirectiveElementType
extends JetStubElementType<KotlinImportDirectiveStub, JetImportDirective> {
    public JetImportDirectiveElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/psi/stubs/elements/JetImportDirectiveElementType", "<init>"));
        }
        super(debugName, JetImportDirective.class, KotlinImportDirectiveStub.class);
    }

    public KotlinImportDirectiveStub createStub(@NotNull JetImportDirective psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/psi/stubs/elements/JetImportDirectiveElementType", "createStub"));
        }
        StringRef aliasName = StringRef.fromString((String)psi.getAliasName());
        return new KotlinImportDirectiveStubImpl(parentStub, psi.isAbsoluteInRootPackage(), psi.isAllUnder(), aliasName, psi.isValidImport());
    }

    public void serialize(@NotNull KotlinImportDirectiveStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/JetImportDirectiveElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/JetImportDirectiveElementType", "serialize"));
        }
        dataStream.writeBoolean(stub.isAbsoluteInRootPackage());
        dataStream.writeBoolean(stub.isAllUnder());
        dataStream.writeName(stub.getAliasName());
        dataStream.writeBoolean(stub.isValid());
    }

    @NotNull
    public KotlinImportDirectiveStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/JetImportDirectiveElementType", "deserialize"));
        }
        boolean isAbsoluteInRootPackage = dataStream.readBoolean();
        boolean isAllUnder = dataStream.readBoolean();
        StringRef aliasName = dataStream.readName();
        boolean isValid2 = dataStream.readBoolean();
        KotlinImportDirectiveStubImpl kotlinImportDirectiveStubImpl = new KotlinImportDirectiveStubImpl(parentStub, isAbsoluteInRootPackage, isAllUnder, aliasName, isValid2);
        if (kotlinImportDirectiveStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/JetImportDirectiveElementType", "deserialize"));
        }
        return kotlinImportDirectiveStubImpl;
    }
}

