/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.psi.debugText.DebugTextPackage;
import org.jetbrains.kotlin.resolve.BindingContext;

public class AnalyzingUtils {
    public static void checkForSyntacticErrors(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/resolve/AnalyzingUtils", "checkForSyntacticErrors"));
        }
        root.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(PsiErrorElement element) {
                throw new IllegalArgumentException(element.getErrorDescription() + "; looking at " + element.getNode().getElementType() + " '" + element.getText() + DiagnosticUtils.atLocation((PsiElement)element));
            }
        });
    }

    public static List<PsiErrorElement> getSyntaxErrorRanges(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/resolve/AnalyzingUtils", "getSyntaxErrorRanges"));
        }
        final ArrayList<PsiErrorElement> r = new ArrayList<PsiErrorElement>();
        root.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(PsiErrorElement element) {
                r.add(element);
            }
        });
        return r;
    }

    public static void throwExceptionOnErrors(BindingContext bindingContext2) {
        for (Diagnostic diagnostic : bindingContext2.getDiagnostics()) {
            DiagnosticSink.THROW_EXCEPTION.report(diagnostic);
        }
    }

    public static String formDebugNameForBindingTrace(@NotNull String debugName, @Nullable Object resolutionSubjectForMessage) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/resolve/AnalyzingUtils", "formDebugNameForBindingTrace"));
        }
        StringBuilder debugInfo = new StringBuilder(debugName);
        if (resolutionSubjectForMessage instanceof JetElement) {
            JetElement element = (JetElement)resolutionSubjectForMessage;
            debugInfo.append(" ").append(DebugTextPackage.getDebugText(element));
            debugInfo.append(" in ").append(element.getContainingFile().getName());
        } else if (resolutionSubjectForMessage != null) {
            debugInfo.append(" ").append(resolutionSubjectForMessage);
        }
        return debugInfo.toString();
    }

    public static abstract class PsiErrorElementVisitor
    extends JetTreeVisitorVoid {
        public abstract void visitErrorElement(PsiErrorElement var1);
    }
}

