/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapImpl;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class DelegatingBindingTrace
implements BindingTrace {
    private final MutableSlicedMap map = SlicedMapImpl.create();
    private final BindingContext parentContext;
    private final String name;
    private final MutableDiagnosticsWithSuppression mutableDiagnostics;
    private final BindingContext bindingContext = new BindingContext(){

        @Override
        @NotNull
        public Diagnostics getDiagnostics() {
            MutableDiagnosticsWithSuppression mutableDiagnosticsWithSuppression = DelegatingBindingTrace.this.mutableDiagnostics;
            if (mutableDiagnosticsWithSuppression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace$1", "getDiagnostics"));
            }
            return mutableDiagnosticsWithSuppression;
        }

        @Override
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            return DelegatingBindingTrace.this.get(slice, key);
        }

        @Override
        @Nullable
        public JetType getType(@NotNull JetExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace$1", "getType"));
            }
            return DelegatingBindingTrace.this.getType(expression2);
        }

        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            Collection<K> collection = DelegatingBindingTrace.this.getKeys(slice);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace$1", "getKeys"));
            }
            return collection;
        }

        @Override
        @NotNull
        public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
            if (slice == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace$1", "getSliceContents"));
            }
            HashMap result2 = Maps.newHashMap();
            result2.putAll(DelegatingBindingTrace.this.parentContext.getSliceContents(slice));
            result2.putAll(DelegatingBindingTrace.this.map.getSliceContents(slice));
            ImmutableMap immutableMap = ImmutableMap.copyOf((Map)result2);
            if (immutableMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace$1", "getSliceContents"));
            }
            return immutableMap;
        }
    };

    public DelegatingBindingTrace(BindingContext parentContext, String debugName) {
        this.parentContext = parentContext;
        this.name = debugName;
        this.mutableDiagnostics = new MutableDiagnosticsWithSuppression(this.bindingContext, parentContext.getDiagnostics());
    }

    public DelegatingBindingTrace(BindingContext parentContext, String debugName, @Nullable Object resolutionSubjectForMessage) {
        this(parentContext, AnalyzingUtils.formDebugNameForBindingTrace(debugName, resolutionSubjectForMessage));
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.bindingContext;
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "getBindingContext"));
        }
        return bindingContext2;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value2) {
        this.map.put(slice, key, value2);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        V value2 = this.map.get(slice, key);
        if (slice instanceof Slices.SetSlice) {
            assert (value2 != null);
            if (value2.equals(true)) {
                return value2;
            }
        } else if (value2 != null) {
            return value2;
        }
        return this.parentContext.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> keys = this.map.getKeys(slice);
        Collection<K> fromParent = this.parentContext.getKeys(slice);
        if (keys.isEmpty()) {
            Collection<K> collection = fromParent;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "getKeys"));
            }
            return collection;
        }
        if (fromParent.isEmpty()) {
            Collection<K> collection = keys;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "getKeys"));
            }
            return collection;
        }
        ArrayList result2 = Lists.newArrayList(keys);
        result2.addAll(fromParent);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "getKeys"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public JetType getType(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "getType"));
        }
        JetTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        return typeInfo != null ? typeInfo.getType() : null;
    }

    @Override
    public void recordType(@NotNull JetExpression expression2, @Nullable JetType type2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "recordType"));
        }
        JetTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        typeInfo = typeInfo == null ? TypeInfoFactoryPackage.createTypeInfo(type2) : typeInfo.replaceType(type2);
        this.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo);
    }

    public void addAllMyDataTo(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "addAllMyDataTo"));
        }
        this.addAllMyDataTo(trace, null, true);
    }

    public void moveAllMyDataTo(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "moveAllMyDataTo"));
        }
        this.addAllMyDataTo(trace, null, true);
        this.clear();
    }

    public void addAllMyDataTo(final @NotNull BindingTrace trace, final @Nullable TraceEntryFilter filter2, boolean commitDiagnostics) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "addAllMyDataTo"));
        }
        this.map.forEach(new Function3<WritableSlice, Object, Object, Void>(){

            public Void invoke(WritableSlice slice, Object key, Object value2) {
                if (filter2 == null || filter2.accept(slice, key)) {
                    trace.record(slice, key, value2);
                }
                return null;
            }
        });
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : this.mutableDiagnostics.getOwnDiagnostics()) {
            if (filter2 != null && !filter2.accept(null, diagnostic.getPsiElement())) continue;
            trace.report(diagnostic);
        }
    }

    public void clear() {
        this.map.clear();
        this.mutableDiagnostics.clear();
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/DelegatingBindingTrace", "report"));
        }
        this.mutableDiagnostics.report(diagnostic);
    }

    public String toString() {
        return this.name;
    }
}

