/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.types.JetType;

public class ArrayValue
extends CompileTimeConstant<List<CompileTimeConstant<?>>> {
    private final JetType type;

    public ArrayValue(@NotNull List<CompileTimeConstant<?>> value2, @NotNull JetType type2, boolean canBeUsedInAnnotations, boolean usesVariableAsConstant) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/constants/ArrayValue", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/constants/ArrayValue", "<init>"));
        }
        super(value2, canBeUsedInAnnotations, false, usesVariableAsConstant);
        assert (KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2)) : "Type should be an array, but was " + type2 + ": " + value2;
        this.type = type2;
    }

    @Override
    @NotNull
    public List<CompileTimeConstant<?>> getValue() {
        List value2 = (List)super.getValue();
        assert (value2 != null) : "Guaranteed by constructor";
        List list = value2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/ArrayValue", "getValue"));
        }
        return list;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/kotlin/resolve/constants/ArrayValue", "getType"));
        }
        JetType jetType = this.type;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/ArrayValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        return visitor2.visitArrayValue(this, data2);
    }

    public String toString() {
        return ((List)this.value).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayValue that = (ArrayValue)o;
        if (this.value == null) {
            return that.value == null;
        }
        int i = 0;
        for (CompileTimeConstant thisObject : (List)this.value) {
            if (!thisObject.equals(((List)that.value).get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.value == null) {
            return hashCode;
        }
        for (CompileTimeConstant o : (List)this.value) {
            hashCode += o.hashCode();
        }
        return hashCode;
    }
}

