/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public class JetScopeSelectorUtil {
    public static final ScopeByNameSelector<ClassifierDescriptor> CLASSIFIER_DESCRIPTOR_SCOPE_SELECTOR = new ScopeByNameSelector<ClassifierDescriptor>(){

        @Override
        @Nullable
        public ClassifierDescriptor get(@NotNull JetScope scope2, @NotNull Name name2) {
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$1", "get"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$1", "get"));
            }
            return scope2.getClassifier(name2);
        }
    };
    public static final ScopeByNameSelector<PackageViewDescriptor> PACKAGE_SCOPE_SELECTOR = new ScopeByNameSelector<PackageViewDescriptor>(){

        @Override
        @Nullable
        public PackageViewDescriptor get(@NotNull JetScope scope2, @NotNull Name name2) {
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$2", "get"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$2", "get"));
            }
            return scope2.getPackage(name2);
        }
    };
    public static final ScopeByNameSelector<VariableDescriptor> VARIABLE_DESCRIPTOR_SCOPE_SELECTOR = new ScopeByNameSelector<VariableDescriptor>(){

        @Override
        @Nullable
        public VariableDescriptor get(@NotNull JetScope scope2, @NotNull Name name2) {
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$3", "get"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$3", "get"));
            }
            return scope2.getLocalVariable(name2);
        }
    };
    public static final ScopeByNameMultiSelector<FunctionDescriptor> NAMED_FUNCTION_SCOPE_SELECTOR = new ScopeByNameMultiSelector<FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<FunctionDescriptor> get(@NotNull JetScope scope2, @NotNull Name name2) {
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$4", "get"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$4", "get"));
            }
            Collection<FunctionDescriptor> collection = scope2.getFunctions(name2);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$4", "get"));
            }
            return collection;
        }
    };
    public static final ScopeByNameMultiSelector<VariableDescriptor> NAMED_PROPERTIES_SCOPE_SELECTOR = new ScopeByNameMultiSelector<VariableDescriptor>(){

        @Override
        @NotNull
        public Collection<VariableDescriptor> get(@NotNull JetScope scope2, @NotNull Name name2) {
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$5", "get"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$5", "get"));
            }
            Collection<VariableDescriptor> collection = scope2.getProperties(name2);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil$5", "get"));
            }
            return collection;
        }
    };

    private JetScopeSelectorUtil() {
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Collection<D> collect(Collection<JetScope> scopes, ScopeByNameMultiSelector<D> selector, Name name2) {
        HashSet<D> descriptors = new HashSet<D>();
        for (JetScope scope2 : scopes) {
            descriptors.addAll(selector.get(scope2, name2));
        }
        HashSet<D> hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil", "collect"));
        }
        return hashSet;
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getFirstMatch(@NotNull JetScope[] scopes, @NotNull Name name2, @NotNull ScopeByNameSelector<D> descriptorSelector) {
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil", "getFirstMatch"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil", "getFirstMatch"));
        }
        if (descriptorSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorSelector", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil", "getFirstMatch"));
        }
        for (JetScope scope2 : scopes) {
            D descriptor2 = descriptorSelector.get(scope2, name2);
            if (descriptor2 == null) continue;
            return descriptor2;
        }
        return null;
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Set<D> getFromAllScopes(@NotNull JetScope[] scopes, @NotNull Name name2, @NotNull ScopeByNameMultiSelector<D> descriptorsSelector) {
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
        }
        if (descriptorsSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorsSelector", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
        }
        if (scopes.length == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
            }
            return set;
        }
        LinkedHashSet<D> descriptors = new LinkedHashSet<D>();
        for (JetScope jetScope : scopes) {
            descriptors.addAll(descriptorsSelector.get(jetScope, name2));
        }
        LinkedHashSet<D> linkedHashSet = descriptors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
        }
        return linkedHashSet;
    }

    public static interface ScopeByNameMultiSelector<D extends DeclarationDescriptor> {
        @NotNull
        public Collection<D> get(JetScope var1, Name var2);
    }

    public static interface ScopeByNameSelector<D extends DeclarationDescriptor> {
        @Nullable
        public D get(@NotNull JetScope var1, @NotNull Name var2);
    }
}

