/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.userDataHolder;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.userDataHolder.keyFMap.KeyFMap;

public class UserDataHolderBase
implements UserDataHolderEx,
Cloneable {
    public static final Key<KeyFMap> COPYABLE_USER_MAP_KEY = Key.create((String)"COPYABLE_USER_MAP_KEY");
    @NotNull
    private volatile KeyFMap myUserMap = KeyFMap.EMPTY_MAP;
    private static final AtomicFieldUpdater<UserDataHolderBase, KeyFMap> updater = AtomicFieldUpdater.forFieldOfType(UserDataHolderBase.class, KeyFMap.class);

    protected Object clone() {
        try {
            UserDataHolderBase clone = (UserDataHolderBase)super.clone();
            clone.setUserMap(KeyFMap.EMPTY_MAP);
            this.copyCopyableDataTo(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUserDataString() {
        KeyFMap userMap = this.getUserMap();
        KeyFMap copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        return ((Object)userMap).toString() + (copyableMap == null ? "" : ((Object)copyableMap).toString());
    }

    public void copyUserDataTo(UserDataHolderBase other) {
        other.setUserMap(this.getUserMap());
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "getUserData"));
        }
        return this.getUserMap().get(key);
    }

    @NotNull
    protected KeyFMap getUserMap() {
        KeyFMap keyFMap = this.myUserMap;
        if (keyFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "getUserMap"));
        }
        return keyFMap;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        KeyFMap map2;
        KeyFMap newMap;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "putUserData"));
        }
        do {
            map2 = this.getUserMap();
            KeyFMap keyFMap = newMap = value2 == null ? map2.minus(key) : map2.plus(key, value2);
        } while (newMap != map2 && !this.changeUserMap(map2, newMap));
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        return updater.compareAndSet((Object)this, (Object)oldMap, (Object)newMap);
    }

    public <T> T getCopyableUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "getCopyableUserData"));
        }
        KeyFMap map2 = this.getUserData(COPYABLE_USER_MAP_KEY);
        return map2 == null ? null : (T)map2.get(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value2) {
        KeyFMap map2;
        KeyFMap newMap;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "putCopyableUserData"));
        }
        do {
            KeyFMap copyableMap;
            if ((copyableMap = (map2 = this.getUserMap()).get(COPYABLE_USER_MAP_KEY)) == null) {
                copyableMap = KeyFMap.EMPTY_MAP;
            }
            KeyFMap newCopyableMap = value2 == null ? copyableMap.minus(key) : copyableMap.plus(key, value2);
            KeyFMap keyFMap = newMap = newCopyableMap.isEmpty() ? map2.minus(COPYABLE_USER_MAP_KEY) : map2.plus(COPYABLE_USER_MAP_KEY, newCopyableMap);
        } while (newMap != map2 && !this.changeUserMap(map2, newMap));
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        KeyFMap map2;
        KeyFMap newMap;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "replace"));
        }
        do {
            if ((map2 = this.getUserMap()).get(key) != oldValue) {
                return false;
            }
            KeyFMap keyFMap = newMap = newValue == null ? map2.minus(key) : map2.plus(key, newValue);
        } while (newMap != map2 && !this.changeUserMap(map2, newMap));
        return true;
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value2) {
        KeyFMap map2;
        KeyFMap newMap;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "putUserDataIfAbsent"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "putUserDataIfAbsent"));
        }
        do {
            T oldValue;
            if ((oldValue = (map2 = this.getUserMap()).get(key)) == null) continue;
            T t = oldValue;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "putUserDataIfAbsent"));
            }
            return t;
        } while ((newMap = map2.plus(key, value2)) != map2 && !this.changeUserMap(map2, newMap));
        T t = value2;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "putUserDataIfAbsent"));
        }
        return t;
    }

    public void copyCopyableDataTo(@NotNull UserDataHolderBase clone) {
        if (clone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clone", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "copyCopyableDataTo"));
        }
        clone.putUserData(COPYABLE_USER_MAP_KEY, this.getUserData(COPYABLE_USER_MAP_KEY));
    }

    protected void clearUserData() {
        this.setUserMap(KeyFMap.EMPTY_MAP);
    }

    protected void setUserMap(@NotNull KeyFMap map2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/util/userDataHolder/UserDataHolderBase", "setUserMap"));
        }
        this.myUserMap = map2;
    }

    public boolean isUserDataEmpty() {
        return this.getUserMap().isEmpty();
    }
}

