/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JUnitConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements CommonJavaRunConfigurationParameters,
RefactoringListenerProvider,
SMRunnerConsolePropertiesProvider {
    public static final String DEFAULT_PACKAGE_NAME = ExecutionBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]);
    @NonNls
    public static final String TEST_CLASS = "class";
    @NonNls
    public static final String TEST_PACKAGE = "package";
    @NonNls
    public static final String TEST_DIRECTORY = "directory";
    @NonNls
    public static final String TEST_CATEGORY = "category";
    @NonNls
    public static final String TEST_METHOD = "method";
    @NonNls
    public static final String FORK_NONE = "none";
    @NonNls
    public static final String FORK_METHOD = "method";
    @NonNls
    public static final String FORK_KLASS = "class";
    @NonNls
    public static final String JUNIT_START_CLASS = "com.intellij.rt.execution.junit.JUnitStarter";
    @NonNls
    private static final String PATTERN_EL_NAME = "pattern";
    @NonNls
    public static final String TEST_PATTERN = "pattern";
    @NonNls
    private static final String TEST_CLASS_ATT_NAME = "testClass";
    @NonNls
    private static final String PATTERNS_EL_NAME = "patterns";
    private final Data myData;
    final RefactoringListeners.Accessor<PsiPackage> myPackage = new RefactoringListeners.Accessor<PsiPackage>(){

        public void setName(String qualifiedName) {
            boolean generatedName = JUnitConfiguration.this.isGeneratedName();
            ((JUnitConfiguration)JUnitConfiguration.this).myData.PACKAGE_NAME = qualifiedName;
            if (generatedName) {
                JUnitConfiguration.this.setGeneratedName();
            }
        }

        public PsiPackage getPsiElement() {
            String qualifiedName = JUnitConfiguration.this.myData.getPackageName();
            return qualifiedName != null ? JavaPsiFacade.getInstance((Project)JUnitConfiguration.this.getProject()).findPackage(qualifiedName) : null;
        }

        public void setPsiElement(PsiPackage psiPackage) {
            this.setName(psiPackage.getQualifiedName());
        }
    };
    final RefactoringListeners.Accessor<PsiClass> myClass = new RefactoringListeners.Accessor<PsiClass>(){

        public void setName(@NotNull String qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/execution/junit/JUnitConfiguration$2", "setName"));
            }
            boolean generatedName = JUnitConfiguration.this.isGeneratedName();
            ((JUnitConfiguration)JUnitConfiguration.this).myData.MAIN_CLASS_NAME = qualifiedName;
            if (generatedName) {
                JUnitConfiguration.this.setGeneratedName();
            }
        }

        public PsiClass getPsiElement() {
            return ((JavaRunConfigurationModule)JUnitConfiguration.this.getConfigurationModule()).findClass(JUnitConfiguration.this.myData.getMainClassName());
        }

        public void setPsiElement(PsiClass psiClass) {
            Module originalModule = ((JavaRunConfigurationModule)JUnitConfiguration.this.getConfigurationModule()).getModule();
            JUnitConfiguration.this.setMainClass(psiClass);
            JUnitConfiguration.this.restoreOriginalModule(originalModule);
        }
    };
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;

    public JUnitConfiguration(String name, Project project, ConfigurationFactory configurationFactory) {
        this(name, project, new Data(), configurationFactory);
    }

    protected JUnitConfiguration(String name, Project project, Data data, ConfigurationFactory configurationFactory) {
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, false), configurationFactory);
        this.myData = data;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/junit/JUnitConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/junit/JUnitConfiguration", "getState"));
        }
        return TestObject.fromString(this.myData.TEST_OBJECT, this, env);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), new JUnitConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public Data getPersistentData() {
        return this.myData;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        RefactoringElementListener listener = this.myData.getTestObject(this).getListener(element, this);
        return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.myData.getTestObject(this).checkConfiguration();
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    public Collection<Module> getValidModules() {
        if (TEST_PACKAGE.equals(this.myData.TEST_OBJECT) || "pattern".equals(this.myData.TEST_OBJECT)) {
            return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
        }
        try {
            this.myData.getTestObject(this).checkConfiguration();
        }
        catch (RuntimeConfigurationError e) {
            return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            // empty catch block
        }
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.myData.getMainClassName());
    }

    protected ModuleBasedConfiguration createInstance() {
        return new JUnitConfiguration(this.getName(), this.getProject(), this.myData.clone(), JUnitConfigurationType.getInstance().getConfigurationFactories()[0]);
    }

    public String suggestedName() {
        return this.myData.getGeneratedName((JavaRunConfigurationModule)this.getConfigurationModule());
    }

    public String getActionName() {
        return this.getTestObject().suggestActionName();
    }

    public String getVMParameters() {
        return this.myData.getVMParameters();
    }

    public void setVMParameters(String value) {
        this.myData.setVMParameters(value);
    }

    public String getProgramParameters() {
        return this.myData.getProgramParameters();
    }

    public void setProgramParameters(String value) {
        this.myData.setProgramParameters(value);
    }

    public String getWorkingDirectory() {
        return this.myData.getWorkingDirectory();
    }

    public void setWorkingDirectory(String value) {
        this.myData.setWorkingDirectory(value);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myData.getEnvs();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfiguration", "getEnvs"));
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/execution/junit/JUnitConfiguration", "setEnvs"));
        }
        this.myData.setEnvs(envs);
    }

    public boolean isPassParentEnvs() {
        return this.myData.PASS_PARENT_ENVS;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myData.PASS_PARENT_ENVS = passParentEnvs;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String path) {
        this.ALTERNATIVE_JRE_PATH = path;
    }

    public String getRunClass() {
        Data data = this.getPersistentData();
        return data.TEST_OBJECT != "class" && data.TEST_OBJECT != "method" ? null : data.getMainClassName();
    }

    public String getPackage() {
        Data data = this.getPersistentData();
        return !Comparing.strEqual((String)data.TEST_OBJECT, (String)TEST_PACKAGE) ? null : data.getPackageName();
    }

    public void beClassConfiguration(PsiClass testClass) {
        this.setMainClass(testClass);
        this.myData.TEST_OBJECT = "class";
        this.setGeneratedName();
    }

    public void setMainClass(PsiClass testClass) {
        boolean shouldUpdateName = this.isGeneratedName();
        this.setModule(this.myData.setMainClass(testClass));
        if (shouldUpdateName) {
            this.setGeneratedName();
        }
    }

    public void beMethodConfiguration(Location<PsiMethod> methodLocation) {
        this.setModule(this.myData.setTestMethod(methodLocation));
        this.setGeneratedName();
    }

    @NotNull
    public Module[] getModules() {
        if (TEST_PACKAGE.equals(this.myData.TEST_OBJECT) && this.getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            if (Module.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfiguration", "getModules"));
            }
            return Module.EMPTY_ARRAY;
        }
        Module[] moduleArray = super.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfiguration", "getModules"));
        }
        return moduleArray;
    }

    public TestObject getTestObject() {
        return this.myData.getTestObject(this);
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element categoryNameElement;
        Element dirNameElement;
        String repeatMode;
        String count;
        String mode;
        Element forkModeElement;
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.readExternal((Object)this.getPersistentData(), (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getPersistentData().getEnvs());
        Element patternsElement = element.getChild(PATTERNS_EL_NAME);
        if (patternsElement != null) {
            LinkedHashSet<String> tests = new LinkedHashSet<String>();
            for (Object o : patternsElement.getChildren("pattern")) {
                Element patternElement = (Element)o;
                tests.add(patternElement.getAttributeValue(TEST_CLASS_ATT_NAME));
            }
            this.myData.setPatterns(tests);
        }
        if ((forkModeElement = element.getChild("fork_mode")) != null && (mode = forkModeElement.getAttributeValue("value")) != null) {
            this.setForkMode(mode);
        }
        if ((count = element.getAttributeValue("repeat_count")) != null) {
            try {
                this.setRepeatCount(Integer.parseInt(count));
            }
            catch (NumberFormatException e) {
                this.setRepeatCount(1);
            }
        }
        if ((repeatMode = element.getAttributeValue("repeat_mode")) != null) {
            this.setRepeatMode(repeatMode);
        }
        if ((dirNameElement = element.getChild("dir")) != null) {
            String dirName = dirNameElement.getAttributeValue("value");
            this.getPersistentData().setDirName(FileUtil.toSystemDependentName((String)dirName));
        }
        if ((categoryNameElement = element.getChild(TEST_CATEGORY)) != null) {
            String categoryName = categoryNameElement.getAttributeValue("value");
            this.getPersistentData().setCategoryName(categoryName);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String repeatMode;
        String categoryName;
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        this.writeModule(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        Data persistentData = this.getPersistentData();
        DefaultJDOMExternalizer.writeExternal((Object)persistentData, (Element)element);
        EnvironmentVariablesComponent.writeExternal((Element)element, persistentData.getEnvs());
        String dirName = persistentData.getDirName();
        if (!dirName.isEmpty()) {
            Element dirNameElement = new Element("dir");
            dirNameElement.setAttribute("value", FileUtil.toSystemIndependentName((String)dirName));
            element.addContent(dirNameElement);
        }
        if (!(categoryName = persistentData.getCategory()).isEmpty()) {
            Element categoryNameElement = new Element(TEST_CATEGORY);
            categoryNameElement.setAttribute("value", categoryName);
            element.addContent(categoryNameElement);
        }
        Element patternsElement = new Element(PATTERNS_EL_NAME);
        for (String o : persistentData.getPatterns()) {
            Element patternElement = new Element("pattern");
            patternElement.setAttribute(TEST_CLASS_ATT_NAME, o);
            patternsElement.addContent(patternElement);
        }
        String forkMode = this.getForkMode();
        if (!forkMode.equals(FORK_NONE)) {
            Element forkModeElement = new Element("fork_mode");
            forkModeElement.setAttribute("value", forkMode);
            element.addContent(forkModeElement);
        }
        if (this.getRepeatCount() != 1) {
            element.setAttribute("repeat_count", String.valueOf(this.getRepeatCount()));
        }
        if (!"Once".equals(repeatMode = this.getRepeatMode())) {
            element.setAttribute("repeat_mode", repeatMode);
        }
        element.addContent(patternsElement);
    }

    public String getForkMode() {
        return this.myData.FORK_MODE;
    }

    public void setForkMode(@NotNull String forkMode) {
        if (forkMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forkMode", "com/intellij/execution/junit/JUnitConfiguration", "setForkMode"));
        }
        this.myData.FORK_MODE = forkMode;
    }

    public boolean collectOutputFromProcessHandler() {
        return false;
    }

    public void bePatternConfiguration(List<PsiClass> classes, PsiMethod method) {
        String methodSufiix;
        this.myData.TEST_OBJECT = "pattern";
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        if (method != null) {
            this.myData.METHOD_NAME = method.getName();
            methodSufiix = "," + this.myData.METHOD_NAME;
        } else {
            methodSufiix = "";
        }
        for (PsiClass pattern : classes) {
            patterns.add(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)pattern) + methodSufiix);
        }
        this.myData.setPatterns(patterns);
        Module module = ((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).findModule(this, ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule(), patterns);
        if (module == null) {
            this.myData.setScope(TestSearchScope.WHOLE_PROJECT);
            this.setModule(null);
        } else {
            this.setModule(module);
        }
        this.setGeneratedName();
    }

    public int getRepeatCount() {
        return this.myData.REPEAT_COUNT;
    }

    public void setRepeatCount(int repeatCount) {
        this.myData.REPEAT_COUNT = repeatCount;
    }

    public String getRepeatMode() {
        return this.myData.REPEAT_MODE;
    }

    public void setRepeatMode(String repeatMode) {
        this.myData.REPEAT_MODE = repeatMode;
    }

    public SMTRunnerConsoleProperties createTestConsoleProperties(Executor executor) {
        return new JUnitConsoleProperties(this, executor);
    }

    public static class Data
    implements Cloneable {
        public String PACKAGE_NAME;
        public String MAIN_CLASS_NAME;
        public String METHOD_NAME;
        public String TEST_OBJECT = "class";
        public String VM_PARAMETERS;
        public String PARAMETERS;
        public String WORKING_DIRECTORY;
        public String ENV_VARIABLES;
        public boolean PASS_PARENT_ENVS = true;
        public TestSearchScope.Wrapper TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
        private String DIR_NAME;
        private String CATEGORY_NAME;
        private String FORK_MODE = "none";
        private int REPEAT_COUNT = 1;
        private String REPEAT_MODE = "Once";
        private LinkedHashSet<String> myPattern = new LinkedHashSet();
        private Map<String, String> myEnvs = new LinkedHashMap<String, String>();

        public boolean equals(Object object) {
            if (!(object instanceof Data)) {
                return false;
            }
            Data second = (Data)object;
            return Comparing.equal((String)this.TEST_OBJECT, (String)second.TEST_OBJECT) && Comparing.equal((String)this.getMainClassName(), (String)second.getMainClassName()) && Comparing.equal((String)this.getPackageName(), (String)second.getPackageName()) && Comparing.equal((String)this.getMethodName(), (String)second.getMethodName()) && Comparing.equal((String)this.getWorkingDirectory(), (String)second.getWorkingDirectory()) && Comparing.equal((String)this.VM_PARAMETERS, (String)second.VM_PARAMETERS) && Comparing.equal((String)this.PARAMETERS, (String)second.PARAMETERS) && Comparing.equal(this.myPattern, second.myPattern) && Comparing.equal((String)this.FORK_MODE, (String)second.FORK_MODE) && Comparing.equal((String)this.DIR_NAME, (String)second.DIR_NAME) && Comparing.equal((String)this.CATEGORY_NAME, (String)second.CATEGORY_NAME) && Comparing.equal((String)this.REPEAT_MODE, (String)second.REPEAT_MODE) && this.REPEAT_COUNT == second.REPEAT_COUNT;
        }

        public int hashCode() {
            return Comparing.hashcode((Object)this.TEST_OBJECT) ^ Comparing.hashcode((Object)this.getMainClassName()) ^ Comparing.hashcode((Object)this.getPackageName()) ^ Comparing.hashcode((Object)this.getMethodName()) ^ Comparing.hashcode((Object)this.getWorkingDirectory()) ^ Comparing.hashcode((Object)this.VM_PARAMETERS) ^ Comparing.hashcode((Object)this.PARAMETERS) ^ Comparing.hashcode(this.myPattern) ^ Comparing.hashcode((Object)this.FORK_MODE) ^ Comparing.hashcode((Object)this.DIR_NAME) ^ Comparing.hashcode((Object)this.CATEGORY_NAME) ^ Comparing.hashcode((Object)this.REPEAT_MODE) ^ Comparing.hashcode((Object)this.REPEAT_COUNT);
        }

        public TestSearchScope getScope() {
            return this.TEST_SEARCH_SCOPE.getScope();
        }

        public void setScope(TestSearchScope scope) {
            this.TEST_SEARCH_SCOPE.setScope(scope);
        }

        public Data clone() {
            try {
                Data data = (Data)super.clone();
                data.TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
                data.setScope(this.getScope());
                data.myEnvs = new LinkedHashMap<String, String>(this.myEnvs);
                return data;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public String getVMParameters() {
            return this.VM_PARAMETERS;
        }

        public void setVMParameters(String value) {
            this.VM_PARAMETERS = value;
        }

        public String getProgramParameters() {
            return this.PARAMETERS;
        }

        public void setProgramParameters(String value) {
            this.PARAMETERS = value;
        }

        public String getWorkingDirectory() {
            return ExternalizablePath.localPathValue((String)this.WORKING_DIRECTORY);
        }

        public void setWorkingDirectory(String value) {
            this.WORKING_DIRECTORY = ExternalizablePath.urlValue((String)value);
        }

        public Module setTestMethod(Location<PsiMethod> methodLocation) {
            PsiMethod method = (PsiMethod)methodLocation.getPsiElement();
            this.METHOD_NAME = method.getName();
            this.TEST_OBJECT = "method";
            return this.setMainClass(methodLocation instanceof MethodLocation ? ((MethodLocation)methodLocation).getContainingClass() : method.getContainingClass());
        }

        public String getGeneratedName(JavaRunConfigurationModule configurationModule) {
            if (JUnitConfiguration.TEST_PACKAGE.equals(this.TEST_OBJECT) || JUnitConfiguration.TEST_DIRECTORY.equals(this.TEST_OBJECT)) {
                String packageName;
                String moduleName = this.TEST_SEARCH_SCOPE.getScope() == TestSearchScope.WHOLE_PROJECT ? "" : configurationModule.getModuleName();
                String string = packageName = JUnitConfiguration.TEST_PACKAGE.equals(this.TEST_OBJECT) ? this.getPackageName() : StringUtil.getShortName((String)this.getDirName(), (char)'/');
                if (packageName.length() == 0) {
                    if (moduleName.length() > 0) {
                        return ExecutionBundle.message((String)"default.junit.config.name.all.in.module", (Object[])new Object[]{moduleName});
                    }
                    return DEFAULT_PACKAGE_NAME;
                }
                if (moduleName.length() > 0) {
                    return ExecutionBundle.message((String)"default.junit.config.name.all.in.package.in.module", (Object[])new Object[]{packageName, moduleName});
                }
                return packageName;
            }
            if ("pattern".equals(this.TEST_OBJECT)) {
                int size = this.myPattern.size();
                if (size == 0) {
                    return "Temp suite";
                }
                String fqName = (String)this.myPattern.iterator().next();
                return (fqName.contains("*") ? fqName : StringUtil.getShortName((String)fqName)) + (size > 1 ? " and " + (size - 1) + " more" : "");
            }
            String className = JavaExecutionUtil.getPresentableClassName((String)this.getMainClassName());
            if ("method".equals(this.TEST_OBJECT)) {
                return className + '.' + this.getMethodName();
            }
            return className;
        }

        public String getMainClassName() {
            return this.MAIN_CLASS_NAME != null ? this.MAIN_CLASS_NAME : "";
        }

        public String getPackageName() {
            return this.PACKAGE_NAME != null ? this.PACKAGE_NAME : "";
        }

        public String getMethodName() {
            return this.METHOD_NAME != null ? this.METHOD_NAME : "";
        }

        public String getDirName() {
            return this.DIR_NAME != null ? this.DIR_NAME : "";
        }

        public void setDirName(String dirName) {
            this.DIR_NAME = dirName;
        }

        public Set<String> getPatterns() {
            return this.myPattern;
        }

        public void setPatterns(LinkedHashSet<String> pattern) {
            this.myPattern = pattern;
        }

        public String getPatternPresentation() {
            ArrayList<String> enabledTests = new ArrayList<String>();
            for (String pattern : this.myPattern) {
                enabledTests.add(pattern);
            }
            return StringUtil.join(enabledTests, (String)"||");
        }

        public TestObject getTestObject(@NotNull JUnitConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/junit/JUnitConfiguration$Data", "getTestObject"));
            }
            return TestObject.fromString(this.TEST_OBJECT, configuration, ExecutionEnvironmentBuilder.create((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunConfiguration)configuration).build());
        }

        public Module setMainClass(PsiClass testClass) {
            this.MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)testClass);
            PsiPackage containingPackage = JUnitUtil.getContainingPackage((PsiClass)testClass);
            this.PACKAGE_NAME = containingPackage != null ? containingPackage.getQualifiedName() : "";
            return JavaExecutionUtil.findModule((PsiClass)testClass);
        }

        public Map<String, String> getEnvs() {
            return this.myEnvs;
        }

        public void setEnvs(Map<String, String> envs) {
            this.myEnvs = envs;
        }

        public String getCategory() {
            return this.CATEGORY_NAME != null ? this.CATEGORY_NAME : "";
        }

        public void setCategoryName(String categoryName) {
            this.CATEGORY_NAME = categoryName;
        }
    }
}

