/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewAdapter;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class SelectExternalSystemNodeDialog
extends DialogWrapper {
    private final SimpleTree myTree;
    private final NodeSelector mySelector;

    public SelectExternalSystemNodeDialog(Project project, String title, final Class<? extends ExternalSystemNode> nodeClass, NodeSelector selector) {
        super(project, false);
        this.mySelector = selector;
        this.setTitle(title);
        this.myTree = new SimpleTree();
        this.myTree.getSelectionModel().setSelectionMode(1);
        ExternalProjectsView projectsView = ExternalProjectsManager.getInstance((Project)project).getExternalProjectsView(GradleConstants.SYSTEM_ID);
        if (projectsView != null) {
            final ExternalProjectsStructure treeStructure = new ExternalProjectsStructure(project, this.myTree){

                protected Class<? extends ExternalSystemNode>[] getVisibleNodesClasses() {
                    return new Class[]{nodeClass};
                }
            };
            treeStructure.init((ExternalProjectsView)new ExternalProjectsViewAdapter(projectsView){

                @Nullable
                public ExternalProjectsStructure getStructure() {
                    return treeStructure;
                }

                public void updateUpTo(ExternalSystemNode node) {
                    treeStructure.updateUpTo((SimpleNode)node);
                }

                public void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/gradle/service/project/wizard/SelectExternalSystemNodeDialog$2", "handleDoubleClickOrEnter"));
                    }
                    SelectExternalSystemNodeDialog.this.handleDoubleClickOrEnter(node, actionId, inputEvent);
                }
            });
            Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project, GradleConstants.SYSTEM_ID);
            List dataNodes = ContainerUtil.mapNotNull((Collection)projectsData, (Function)new Function<ExternalProjectInfo, DataNode<ProjectData>>(){

                public DataNode<ProjectData> fun(ExternalProjectInfo info) {
                    return info.getExternalProjectStructure();
                }
            });
            treeStructure.updateProjects((Collection)dataNodes);
            final SimpleNode[] selection = new SimpleNode[]{null};
            treeStructure.accept(new SimpleNodeVisitor(){

                public boolean accept(SimpleNode each) {
                    if (!SelectExternalSystemNodeDialog.this.mySelector.shouldSelect(each)) {
                        return false;
                    }
                    selection[0] = each;
                    return true;
                }
            });
            if (selection[0] != null) {
                treeStructure.select(selection[0]);
            }
        }
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/gradle/service/project/wizard/SelectExternalSystemNodeDialog", "handleDoubleClickOrEnter"));
        }
    }

    protected SimpleNode getSelectedNode() {
        return this.myTree.getNodeFor(this.myTree.getSelectionPath());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        pane.setPreferredSize((Dimension)JBUI.size((int)320, (int)400));
        return pane;
    }

    protected static interface NodeSelector {
        public boolean shouldSelect(SimpleNode var1);
    }
}

