/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.RootType;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.ThreadObj;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.io.HprofBuffer;
import com.google.common.primitives.UnsignedBytes;
import com.google.common.primitives.UnsignedInts;
import gnu.trove.TLongObjectHashMap;
import java.io.EOFException;
import java.io.IOException;

public class HprofParser {
    private static final int STRING_IN_UTF8 = 1;
    private static final int LOAD_CLASS = 2;
    private static final int UNLOAD_CLASS = 3;
    private static final int STACK_FRAME = 4;
    private static final int STACK_TRACE = 5;
    private static final int ALLOC_SITES = 6;
    private static final int HEAP_SUMMARY = 7;
    private static final int START_THREAD = 10;
    private static final int END_THREAD = 11;
    private static final int HEAP_DUMP = 12;
    private static final int HEAP_DUMP_SEGMENT = 28;
    private static final int HEAP_DUMP_END = 44;
    private static final int CPU_SAMPLES = 13;
    private static final int CONTROL_SETTINGS = 14;
    private static final int ROOT_UNKNOWN = 255;
    private static final int ROOT_JNI_GLOBAL = 1;
    private static final int ROOT_JNI_LOCAL = 2;
    private static final int ROOT_JAVA_FRAME = 3;
    private static final int ROOT_NATIVE_STACK = 4;
    private static final int ROOT_STICKY_CLASS = 5;
    private static final int ROOT_THREAD_BLOCK = 6;
    private static final int ROOT_MONITOR_USED = 7;
    private static final int ROOT_THREAD_OBJECT = 8;
    private static final int ROOT_CLASS_DUMP = 32;
    private static final int ROOT_INSTANCE_DUMP = 33;
    private static final int ROOT_OBJECT_ARRAY_DUMP = 34;
    private static final int ROOT_PRIMITIVE_ARRAY_DUMP = 35;
    private static final int ROOT_HEAP_DUMP_INFO = 254;
    private static final int ROOT_INTERNED_STRING = 137;
    private static final int ROOT_FINALIZING = 138;
    private static final int ROOT_DEBUGGER = 139;
    private static final int ROOT_REFERENCE_CLEANUP = 140;
    private static final int ROOT_VM_INTERNAL = 141;
    private static final int ROOT_JNI_MONITOR = 142;
    private static final int ROOT_UNREACHABLE = 144;
    private static final int ROOT_PRIMITIVE_ARRAY_NODATA = 195;
    @NonNull
    private final HprofBuffer mInput;
    int mIdSize;
    Snapshot mSnapshot;
    @NonNull
    TLongObjectHashMap<String> mStrings = new TLongObjectHashMap();
    @NonNull
    TLongObjectHashMap<String> mClassNames = new TLongObjectHashMap();

    public HprofParser(@NonNull HprofBuffer buffer) {
        this.mInput = buffer;
    }

    @NonNull
    public final Snapshot parse() {
        Snapshot snapshot;
        this.mSnapshot = snapshot = new Snapshot(this.mInput);
        try {
            try {
                this.readNullTerminatedString();
                this.mIdSize = this.mInput.readInt();
                Type.setIdSize(this.mIdSize);
                this.mInput.readLong();
                block12: while (this.mInput.hasRemaining()) {
                    int tag = this.readUnsignedByte();
                    this.mInput.readInt();
                    long length = this.readUnsignedInt();
                    switch (tag) {
                        case 1: {
                            this.loadString((int)length - this.mIdSize);
                            continue block12;
                        }
                        case 2: {
                            this.loadClass();
                            continue block12;
                        }
                        case 4: {
                            this.loadStackFrame();
                            continue block12;
                        }
                        case 5: {
                            this.loadStackTrace();
                            continue block12;
                        }
                        case 12: {
                            this.loadHeapDump(length);
                            this.mSnapshot.setToDefaultHeap();
                            continue block12;
                        }
                        case 28: {
                            this.loadHeapDump(length);
                            this.mSnapshot.setToDefaultHeap();
                            continue block12;
                        }
                    }
                    this.skipFully(length);
                }
            }
            catch (EOFException tag) {
                // empty catch block
            }
            this.mSnapshot.resolveClasses();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mClassNames.clear();
        this.mStrings.clear();
        return snapshot;
    }

    @NonNull
    private String readNullTerminatedString() throws IOException {
        StringBuilder s = new StringBuilder();
        byte c = this.mInput.readByte();
        while (c != 0) {
            s.append((char)c);
            c = this.mInput.readByte();
        }
        return s.toString();
    }

    private long readId() throws IOException {
        switch (this.mIdSize) {
            case 1: {
                return this.mInput.readByte();
            }
            case 2: {
                return this.mInput.readShort();
            }
            case 4: {
                return this.mInput.readInt();
            }
            case 8: {
                return this.mInput.readLong();
            }
        }
        throw new IllegalArgumentException("ID Length must be 1, 2, 4, or 8");
    }

    @NonNull
    private String readUTF8(int length) throws IOException {
        byte[] b = new byte[length];
        this.mInput.read(b);
        return new String(b, "utf-8");
    }

    private int readUnsignedByte() throws IOException {
        return UnsignedBytes.toInt((byte)this.mInput.readByte());
    }

    private int readUnsignedShort() throws IOException {
        return this.mInput.readShort() & 0xFFFF;
    }

    private long readUnsignedInt() throws IOException {
        return UnsignedInts.toLong((int)this.mInput.readInt());
    }

    private void loadString(int length) throws IOException {
        long id = this.readId();
        String string = this.readUTF8(length);
        this.mStrings.put(id, (Object)string);
    }

    private void loadClass() throws IOException {
        this.mInput.readInt();
        long id = this.readId();
        this.mInput.readInt();
        String name = (String)this.mStrings.get(this.readId());
        this.mClassNames.put(id, (Object)name);
    }

    private void loadStackFrame() throws IOException {
        long id = this.readId();
        String methodName = (String)this.mStrings.get(this.readId());
        String methodSignature = (String)this.mStrings.get(this.readId());
        String sourceFile = (String)this.mStrings.get(this.readId());
        int serial = this.mInput.readInt();
        int lineNumber = this.mInput.readInt();
        StackFrame frame = new StackFrame(id, methodName, methodSignature, sourceFile, serial, lineNumber);
        this.mSnapshot.addStackFrame(frame);
    }

    private void loadStackTrace() throws IOException {
        int serialNumber = this.mInput.readInt();
        int threadSerialNumber = this.mInput.readInt();
        int numFrames = this.mInput.readInt();
        StackFrame[] frames = new StackFrame[numFrames];
        for (int i = 0; i < numFrames; ++i) {
            frames[i] = this.mSnapshot.getStackFrame(this.readId());
        }
        StackTrace trace = new StackTrace(serialNumber, threadSerialNumber, frames);
        this.mSnapshot.addStackTrace(trace);
    }

    private void loadHeapDump(long length) throws IOException {
        block24: while (length > 0L) {
            int tag = this.readUnsignedByte();
            --length;
            switch (tag) {
                case 255: {
                    length -= (long)this.loadBasicObj(RootType.UNKNOWN);
                    continue block24;
                }
                case 1: {
                    length -= (long)this.loadBasicObj(RootType.NATIVE_STATIC);
                    this.readId();
                    length -= (long)this.mIdSize;
                    continue block24;
                }
                case 2: {
                    length -= (long)this.loadJniLocal();
                    continue block24;
                }
                case 3: {
                    length -= (long)this.loadJavaFrame();
                    continue block24;
                }
                case 4: {
                    length -= (long)this.loadNativeStack();
                    continue block24;
                }
                case 5: {
                    length -= (long)this.loadBasicObj(RootType.SYSTEM_CLASS);
                    continue block24;
                }
                case 6: {
                    length -= (long)this.loadThreadBlock();
                    continue block24;
                }
                case 7: {
                    length -= (long)this.loadBasicObj(RootType.BUSY_MONITOR);
                    continue block24;
                }
                case 8: {
                    length -= (long)this.loadThreadObject();
                    continue block24;
                }
                case 32: {
                    length -= (long)this.loadClassDump();
                    continue block24;
                }
                case 33: {
                    length -= (long)this.loadInstanceDump();
                    continue block24;
                }
                case 34: {
                    length -= (long)this.loadObjectArrayDump();
                    continue block24;
                }
                case 35: {
                    length -= (long)this.loadPrimitiveArrayDump();
                    continue block24;
                }
                case 195: {
                    System.err.println("+--- PRIMITIVE ARRAY NODATA DUMP");
                    length -= (long)this.loadPrimitiveArrayDump();
                    throw new IllegalArgumentException("Don't know how to load a nodata array");
                }
                case 254: {
                    int heapId = this.mInput.readInt();
                    long heapNameId = this.readId();
                    String heapName = (String)this.mStrings.get(heapNameId);
                    this.mSnapshot.setHeapTo(heapId, heapName);
                    length -= (long)(4 + this.mIdSize);
                    continue block24;
                }
                case 137: {
                    length -= (long)this.loadBasicObj(RootType.INTERNED_STRING);
                    continue block24;
                }
                case 138: {
                    length -= (long)this.loadBasicObj(RootType.FINALIZING);
                    continue block24;
                }
                case 139: {
                    length -= (long)this.loadBasicObj(RootType.DEBUGGER);
                    continue block24;
                }
                case 140: {
                    length -= (long)this.loadBasicObj(RootType.REFERENCE_CLEANUP);
                    continue block24;
                }
                case 141: {
                    length -= (long)this.loadBasicObj(RootType.VM_INTERNAL);
                    continue block24;
                }
                case 142: {
                    length -= (long)this.loadJniMonitor();
                    continue block24;
                }
                case 144: {
                    length -= (long)this.loadBasicObj(RootType.UNREACHABLE);
                    continue block24;
                }
            }
            throw new IllegalArgumentException("loadHeapDump loop with unknown tag " + tag + " with " + this.mInput.remaining() + " bytes possibly remaining");
        }
    }

    private int loadJniLocal() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        int stackFrameNumber = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace trace = this.mSnapshot.getStackTraceAtDepth(thread.mStackTrace, stackFrameNumber);
        RootObj root = new RootObj(RootType.NATIVE_LOCAL, id, threadSerialNumber, trace);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4 + 4;
    }

    private int loadJavaFrame() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        int stackFrameNumber = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace trace = this.mSnapshot.getStackTraceAtDepth(thread.mStackTrace, stackFrameNumber);
        RootObj root = new RootObj(RootType.JAVA_LOCAL, id, threadSerialNumber, trace);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4 + 4;
    }

    private int loadNativeStack() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace trace = this.mSnapshot.getStackTrace(thread.mStackTrace);
        RootObj root = new RootObj(RootType.NATIVE_STACK, id, threadSerialNumber, trace);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4;
    }

    private int loadBasicObj(RootType type) throws IOException {
        long id = this.readId();
        RootObj root = new RootObj(type, id);
        this.mSnapshot.addRoot(root);
        return this.mIdSize;
    }

    private int loadThreadBlock() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace stack = this.mSnapshot.getStackTrace(thread.mStackTrace);
        RootObj root = new RootObj(RootType.THREAD_BLOCK, id, threadSerialNumber, stack);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4;
    }

    private int loadThreadObject() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        int stackSerialNumber = this.mInput.readInt();
        ThreadObj thread = new ThreadObj(id, stackSerialNumber);
        this.mSnapshot.addThread(thread, threadSerialNumber);
        return this.mIdSize + 4 + 4;
    }

    private int loadClassDump() throws IOException {
        long id = this.readId();
        int stackSerialNumber = this.mInput.readInt();
        StackTrace stack = this.mSnapshot.getStackTrace(stackSerialNumber);
        long superClassId = this.readId();
        long classLoaderId = this.readId();
        this.readId();
        this.readId();
        this.readId();
        this.readId();
        int instanceSize = this.mInput.readInt();
        int bytesRead = 7 * this.mIdSize + 4 + 4;
        int numEntries = this.readUnsignedShort();
        bytesRead += 2;
        for (int i = 0; i < numEntries; ++i) {
            this.readUnsignedShort();
            bytesRead += 2 + this.skipValue();
        }
        ClassObj theClass = new ClassObj(id, stack, (String)this.mClassNames.get(id), this.mInput.position());
        theClass.setSuperClassId(superClassId);
        theClass.setClassLoaderId(classLoaderId);
        numEntries = this.readUnsignedShort();
        bytesRead += 2;
        Field[] staticFields = new Field[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            String name = (String)this.mStrings.get(this.readId());
            Type type = Type.getType(this.mInput.readByte());
            staticFields[i] = new Field(type, name);
            this.skipFully(type.getSize());
            bytesRead += this.mIdSize + 1 + type.getSize();
        }
        theClass.setStaticFields(staticFields);
        numEntries = this.readUnsignedShort();
        bytesRead += 2;
        Field[] fields = new Field[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            String name = (String)this.mStrings.get(this.readId());
            Type type = Type.getType(this.readUnsignedByte());
            fields[i] = new Field(type, name);
            bytesRead += this.mIdSize + 1;
        }
        theClass.setFields(fields);
        theClass.setInstanceSize(instanceSize);
        this.mSnapshot.addClass(id, theClass);
        return bytesRead;
    }

    private int loadInstanceDump() throws IOException {
        long id = this.readId();
        int stackId = this.mInput.readInt();
        StackTrace stack = this.mSnapshot.getStackTrace(stackId);
        long classId = this.readId();
        int remaining = this.mInput.readInt();
        long position = this.mInput.position();
        ClassInstance instance = new ClassInstance(id, stack, position);
        instance.setClassId(classId);
        this.mSnapshot.addInstance(id, instance);
        this.skipFully(remaining);
        return this.mIdSize + 4 + this.mIdSize + 4 + remaining;
    }

    private int loadObjectArrayDump() throws IOException {
        long id = this.readId();
        int stackId = this.mInput.readInt();
        StackTrace stack = this.mSnapshot.getStackTrace(stackId);
        int numElements = this.mInput.readInt();
        long classId = this.readId();
        ArrayInstance array = new ArrayInstance(id, stack, Type.OBJECT, numElements, this.mInput.position());
        array.setClassId(classId);
        this.mSnapshot.addInstance(id, array);
        int remaining = numElements * this.mIdSize;
        this.skipFully(remaining);
        return this.mIdSize + 4 + 4 + this.mIdSize + remaining;
    }

    private int loadPrimitiveArrayDump() throws IOException {
        long id = this.readId();
        int stackId = this.mInput.readInt();
        StackTrace stack = this.mSnapshot.getStackTrace(stackId);
        int numElements = this.mInput.readInt();
        Type type = Type.getType(this.readUnsignedByte());
        int size = type.getSize();
        ArrayInstance array = new ArrayInstance(id, stack, type, numElements, this.mInput.position());
        this.mSnapshot.addInstance(id, array);
        int remaining = numElements * size;
        this.skipFully(remaining);
        return this.mIdSize + 4 + 4 + 1 + remaining;
    }

    private int loadJniMonitor() throws IOException {
        long id = this.readId();
        int threadSerialNumber = this.mInput.readInt();
        int stackDepth = this.mInput.readInt();
        ThreadObj thread = this.mSnapshot.getThread(threadSerialNumber);
        StackTrace trace = this.mSnapshot.getStackTraceAtDepth(thread.mStackTrace, stackDepth);
        RootObj root = new RootObj(RootType.NATIVE_MONITOR, id, threadSerialNumber, trace);
        this.mSnapshot.addRoot(root);
        return this.mIdSize + 4 + 4;
    }

    private int skipValue() throws IOException {
        Type type = Type.getType(this.readUnsignedByte());
        int size = type.getSize();
        this.skipFully(size);
        return size + 1;
    }

    private void skipFully(long numBytes) throws IOException {
        this.mInput.setPosition(this.mInput.position() + numBytes);
    }
}

