/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorStacked;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicatorStacked {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myFinished;
    private volatile boolean myIndeterminate;
    private volatile int myNonCancelableCount;
    protected ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private static final Set<Class> ourReportedReuseExceptions = ContainerUtil.newConcurrentSet();

    @Override
    public synchronized void start() {
        LOG.assertTrue(!this.isRunning(), "Attempt to start ProgressIndicator which is already running");
        if (this.myFinished) {
            if (this.myCanceled && !this.isReuseable() && ourReportedReuseExceptions.add(this.getClass())) {
                LOG.error("Attempt to start ProgressIndicator which is cancelled and already stopped:" + this + "," + this.getClass());
            }
            this.myCanceled = false;
            this.myFinished = false;
        }
        this.myText = "";
        this.myFraction = 0.0;
        this.myText2 = "";
        this.myRunning = true;
    }

    protected boolean isReuseable() {
        return false;
    }

    @Override
    public synchronized void stop() {
        LOG.assertTrue(this.myRunning, "stop() should be called only if start() called before");
        this.myRunning = false;
        this.myFinished = true;
    }

    @Override
    public boolean isRunning() {
        return this.myRunning;
    }

    @Override
    public void cancel() {
        this.myCanceled = true;
        ProgressManager.canceled(this);
    }

    @Override
    public boolean isCanceled() {
        return this.myCanceled;
    }

    @Override
    public void checkCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            throw new ProcessCanceledException();
        }
    }

    protected boolean isCancelable() {
        return this.myNonCancelableCount == 0;
    }

    @Override
    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    @Override
    @NotNull
    public final ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase", "getModalityState"));
        }
        return modalityState;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.myIndeterminate = indeterminate;
    }

    @NonNls
    public String toString() {
        return "ProgressIndicator " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }
}

