/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentSoftValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    @Override
    protected ConcurrentRefValueHashMap.ValueReference<K, V> createValueReference(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentSoftValueHashMap", "createValueReference"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentSoftValueHashMap", "createValueReference"));
        }
        return new MySoftReference(key, value, this.myQueue);
    }

    private static class MySoftReference<K, T>
    extends SoftReference<T>
    implements ConcurrentRefValueHashMap.ValueReference<K, T> {
        private final K key;

        private MySoftReference(@NotNull K key, @NotNull T referent, @NotNull ReferenceQueue<T> q) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            if (referent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            K k = this.key;
            if (k == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "getKey"));
            }
            return k;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.ValueReference that = (ConcurrentRefValueHashMap.ValueReference)o;
            return this.key.equals(that.getKey()) && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.key.hashCode();
        }
    }
}

