/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.AccessorBindingWrapper;
import com.intellij.util.xmlb.AttributeBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.FieldAccessor;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.OptionTagBinding;
import com.intellij.util.xmlb.PropertyAccessor;
import com.intellij.util.xmlb.TagBinding;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.CollectionBean;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Rectangle;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanBinding
extends Binding {
    private static final Map<Class, List<MutableAccessor>> ourAccessorCache = ContainerUtil.createConcurrentSoftValueMap();
    private final String myTagName;
    private Binding[] myBindings;
    final Class<?> myBeanClass;
    ThreeState hasEqualMethod;

    public BeanBinding(@NotNull Class<?> beanClass, @Nullable MutableAccessor accessor) {
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/util/xmlb/BeanBinding", "<init>"));
        }
        super(accessor);
        this.hasEqualMethod = ThreeState.UNSURE;
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public synchronized void init(@NotNull Type originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/BeanBinding", "init"));
        }
        assert (this.myBindings == null);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.myBindings = new Binding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            this.myBindings[i] = BeanBinding.createBinding(accessors.get(i));
        }
    }

    @Override
    public Object deserialize(Object context2, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/BeanBinding", "deserialize"));
        }
        Object instance = ReflectionUtil.newInstance(this.myBeanClass, new Class[0]);
        this.deserializeInto(instance, element, null);
        return instance;
    }

    public void deserializeInto(@NotNull Object result2, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/xmlb/BeanBinding", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/BeanBinding", "deserializeInto"));
        }
        block0: for (org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtil.isEmpty(attribute.getNamespaceURI())) continue;
            for (Binding binding : this.myBindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).myName.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result2, attribute.getValue());
                continue block0;
            }
        }
        MultiMap<Binding, Element> data2 = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (Binding binding : this.myBindings) {
                if (content instanceof org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result2, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data2 == null) {
                        data2 = MultiMap.createLinked();
                    }
                    data2.putValue(binding, child);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserialize(result2, child);
                continue block2;
            }
        }
        if (data2 != null) {
            for (Binding binding : data2.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result2, (List)data2.get(binding));
            }
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/BeanBinding", "isBoundTo"));
        }
        return element.getName().equals(this.myTagName);
    }

    private static String getTagName(Class<?> aClass) {
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            return name;
        }
        String name = aClass.getSimpleName();
        return name.isEmpty() ? aClass.getSuperclass().getSimpleName() : name;
    }

    private static String getTagNameFromAnnotation(Class<?> aClass) {
        Tag tag = aClass.getAnnotation(Tag.class);
        return tag != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/BeanBinding", "getAccessors"));
        }
        List<MutableAccessor> accessors = ourAccessorCache.get(aClass);
        if (accessors != null) {
            List<MutableAccessor> list = accessors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "getAccessors"));
            }
            return list;
        }
        accessors = ContainerUtil.newArrayList();
        if (aClass != Rectangle.class) {
            BeanBinding.collectPropertyAccessors(aClass, accessors);
        }
        BeanBinding.collectFieldAccessors(aClass, accessors);
        ourAccessorCache.put(aClass, accessors);
        List<MutableAccessor> list = accessors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "getAccessors"));
        }
        return list;
    }

    private static void collectPropertyAccessors(@NotNull Class<?> aClass, @NotNull List<MutableAccessor> accessors) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/BeanBinding", "collectPropertyAccessors"));
        }
        if (accessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessors", "com/intellij/util/xmlb/BeanBinding", "collectPropertyAccessors"));
        }
        TreeMap candidates = ContainerUtilRt.newTreeMap();
        for (Method method : aClass.getMethods()) {
            Pair<String, Boolean> propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = BeanBinding.getPropertyData(method.getName())) == null || ((String)propertyData.first).equals("class") || method.getParameterTypes().length != ((Boolean)propertyData.second != false ? 1 : 0)) continue;
            Couple<Object> candidate = (Couple)candidates.get(propertyData.first);
            if (candidate == null) {
                candidate = Couple.getEmpty();
            }
            if (((Boolean)propertyData.second != false ? (Method)candidate.second : (Method)candidate.first) != null) continue;
            candidate = Couple.of((Boolean)propertyData.second != false ? (Method)candidate.first : method, (Boolean)propertyData.second != false ? method : (Method)candidate.second);
            candidates.put(propertyData.first, candidate);
        }
        for (Map.Entry candidate : candidates.entrySet()) {
            Couple methods = (Couple)candidate.getValue();
            if (methods.first == null || methods.second == null || !((Method)methods.first).getReturnType().equals(((Method)methods.second).getParameterTypes()[0]) || ((Method)methods.first).getAnnotation(Transient.class) != null || ((Method)methods.second).getAnnotation(Transient.class) != null) continue;
            accessors.add(new PropertyAccessor((String)candidate.getKey(), ((Method)methods.first).getReturnType(), (Method)methods.first, (Method)methods.second));
        }
    }

    private static void collectFieldAccessors(@NotNull Class<?> aClass, @NotNull List<MutableAccessor> accessors) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/BeanBinding", "collectFieldAccessors"));
        }
        if (accessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessors", "com/intellij/util/xmlb/BeanBinding", "collectFieldAccessors"));
        }
        Class<?> currentClass = aClass;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || field.getAnnotation(OptionTag.class) == null && field.getAnnotation(Tag.class) == null && field.getAnnotation(Attribute.class) == null && field.getAnnotation(Property.class) == null && field.getAnnotation(Text.class) == null && field.getAnnotation(CollectionBean.class) == null && (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) && !Collection.class.isAssignableFrom(field.getType()) || Modifier.isTransient(modifiers) || field.getAnnotation(Transient.class) != null)) continue;
                accessors.add(new FieldAccessor(field));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass.getAnnotation(Transient.class) == null);
    }

    @Nullable
    private static Pair<String, Boolean> getPropertyData(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/util/xmlb/BeanBinding", "getPropertyData"));
        }
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3, methodName.length());
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2, methodName.length());
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3, methodName.length());
            isSetter = true;
        }
        return part.isEmpty() ? null : Pair.create(Introspector.decapitalize(part), isSetter);
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static Binding createBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
        }
        Binding binding = XmlSerializerImpl.getBinding(accessor);
        if (binding instanceof JDOMElementBinding) {
            Binding binding2 = binding;
            if (binding2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return binding2;
        }
        Attribute attribute = accessor.getAnnotation(Attribute.class);
        if (attribute != null) {
            AttributeBinding attributeBinding = new AttributeBinding(accessor, attribute);
            if (attributeBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return attributeBinding;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            TagBinding tagBinding = new TagBinding(accessor, tag);
            if (tagBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return tagBinding;
        }
        Text text = accessor.getAnnotation(Text.class);
        if (text != null) {
            TextBinding textBinding = new TextBinding(accessor);
            if (textBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return textBinding;
        }
        if (binding instanceof CompactCollectionBinding) {
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding);
            if (accessorBindingWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return accessorBindingWrapper;
        }
        boolean surroundWithTag = true;
        Property property = accessor.getAnnotation(Property.class);
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
        }
        if (!surroundWithTag) {
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding);
            if (accessorBindingWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return accessorBindingWrapper;
        }
        OptionTagBinding optionTagBinding = new OptionTagBinding(accessor, accessor.getAnnotation(OptionTag.class));
        if (optionTagBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
        }
        return optionTagBinding;
    }
}

