/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.DelegatingJsFunctionScopeWithTemporaryParent;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsRootScope;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.parser.ParserPackage;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallChecker;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsPackage;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.JetType;

public final class CallExpressionTranslator
extends AbstractCallExpressionTranslator {
    @NotNull
    public static JsNode translate(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        ResolvedCall<? extends FunctionDescriptor> resolvedCall = CallUtilPackage.getFunctionResolvedCallWithAssert(expression, context2.bindingContext());
        if (JsCallChecker.isJsCall(resolvedCall)) {
            JsNode jsNode = new CallExpressionTranslator(expression, receiver, context2).translateJsCode();
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
            }
            return jsNode;
        }
        JsExpression callExpression = new CallExpressionTranslator(expression, receiver, context2).translate();
        if (!resolvedCall.isSafeCall() && CallExpressionTranslator.shouldBeInlined(expression, context2)) {
            UtilsPackage.setInlineCallMetadata(callExpression, expression, resolvedCall, context2);
        }
        JsExpression jsExpression = callExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    public static boolean shouldBeInlined(@NotNull JetCallExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (!context2.getConfig().isInlineEnabled()) {
            return false;
        }
        CallableDescriptor descriptor = PsiUtils.getFunctionDescriptor(expression, context2);
        return CallExpressionTranslator.shouldBeInlined(descriptor);
    }

    public static boolean shouldBeInlined(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (descriptor instanceof SimpleFunctionDescriptor) {
            return InlineUtil.isInline(descriptor);
        }
        if (descriptor instanceof ValueParameterDescriptor) {
            return InlineUtil.isInline(descriptor.getContainingDeclaration()) && InlineUtil.isInlineLambdaParameter((ParameterDescriptor)descriptor);
        }
        return false;
    }

    private CallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        super(expression, receiver, context2);
    }

    @NotNull
    private JsExpression translate() {
        JsExpression jsExpression = CallTranslator.translate(this.context(), this.resolvedCall, this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    private JsNode translateJsCode() {
        List<JetValueArgument> arguments2 = this.expression.getValueArguments();
        JetExpression argumentExpression = ((ValueArgument)arguments2.get(0)).getArgumentExpression();
        assert (argumentExpression instanceof JetStringTemplateExpression);
        List<JsStatement> statements = this.parseJsCode((JetStringTemplateExpression)argumentExpression);
        int size = statements.size();
        if (size == 0) {
            JsExpression jsExpression = this.program().getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsExpression;
        }
        if (size > 1) {
            JsBlock jsBlock = new JsBlock(statements);
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsBlock;
        }
        JsStatement resultStatement = statements.get(0);
        if (resultStatement instanceof JsExpressionStatement) {
            JsExpression jsExpression = ((JsExpressionStatement)resultStatement).getExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsExpression;
        }
        JsStatement jsStatement = resultStatement;
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
        }
        return jsStatement;
    }

    @NotNull
    private List<JsStatement> parseJsCode(@NotNull JetStringTemplateExpression jsCodeExpression) {
        if (jsCodeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeExpression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "parseJsCode"));
        }
        TemporaryBindingTrace bindingTrace = TemporaryBindingTrace.create(this.context().bindingTrace(), "parseJsCode");
        JetType stringType = KotlinBuiltIns.getInstance().getStringType();
        CompileTimeConstant<?> constant = ConstantExpressionEvaluator.evaluate(jsCodeExpression, bindingTrace, stringType);
        assert (constant != null) : "jsCode must be compile time string " + jsCodeExpression;
        String jsCode = (String)constant.getValue();
        assert (jsCode != null) : jsCodeExpression.toString();
        JsScope currentScope = this.context().scope();
        assert (currentScope instanceof JsFunctionScope) : "Usage of js outside of function is unexpected";
        JsRootScope temporaryRootScope = new JsRootScope(new JsProgram("<js code>"));
        DelegatingJsFunctionScopeWithTemporaryParent scope2 = new DelegatingJsFunctionScopeWithTemporaryParent((JsFunctionScope)currentScope, temporaryRootScope);
        List<JsStatement> list = ParserPackage.parse(jsCode, ThrowExceptionOnErrorReporter.INSTANCE$, scope2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "parseJsCode"));
        }
        return list;
    }
}

