/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.intrinsic.objects.ObjectIntrinsic;
import org.jetbrains.kotlin.js.translate.reference.CachedAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public class CompanionObjectAccessTranslator
extends AbstractTranslator
implements CachedAccessTranslator {
    @NotNull
    private final JsExpression referenceToCompanionObject;

    @NotNull
    static CompanionObjectAccessTranslator newInstance(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "newInstance"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "newInstance"));
        }
        DeclarationDescriptor referenceDescriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression);
        assert (referenceDescriptor != null) : "JetSimpleName expression must reference a descriptor " + expression.getText();
        CompanionObjectAccessTranslator companionObjectAccessTranslator = new CompanionObjectAccessTranslator(referenceDescriptor, context2);
        if (companionObjectAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "newInstance"));
        }
        return companionObjectAccessTranslator;
    }

    static boolean isCompanionObjectReference(@NotNull JetReferenceExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "isCompanionObjectReference"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "isCompanionObjectReference"));
        }
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression);
        return descriptor instanceof ClassDescriptor && !AnnotationsUtils.isNativeObject(descriptor);
    }

    private CompanionObjectAccessTranslator(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "<init>"));
        }
        super(context2);
        this.referenceToCompanionObject = CompanionObjectAccessTranslator.generateReferenceToCompanionObject(descriptor, context2);
    }

    @NotNull
    private static JsExpression generateReferenceToCompanionObject(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context2) {
        ObjectIntrinsic objectIntrinsic;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "generateReferenceToCompanionObject"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "generateReferenceToCompanionObject"));
        }
        if (descriptor instanceof ClassDescriptor && (objectIntrinsic = context2.intrinsics().getObjectIntrinsic((ClassDescriptor)descriptor)).exists()) {
            JsExpression jsExpression = objectIntrinsic.apply(context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "generateReferenceToCompanionObject"));
            }
            return jsExpression;
        }
        JsExpression fqReference = ReferenceTranslator.translateAsFQReference(descriptor, context2);
        if (DescriptorUtils.isNonCompanionObject(descriptor) || DescriptorUtils.isEnumEntry(descriptor)) {
            JsExpression jsExpression = fqReference;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "generateReferenceToCompanionObject"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = Namer.getCompanionObjectAccessor(fqReference);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "generateReferenceToCompanionObject"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.referenceToCompanionObject;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSetTo", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "translateAsSet"));
        }
        throw new IllegalStateException("companion object can't be set");
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        CompanionObjectAccessTranslator companionObjectAccessTranslator = this;
        if (companionObjectAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "getCached"));
        }
        return companionObjectAccessTranslator;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        List<TemporaryVariable> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectAccessTranslator", "declaredTemporaries"));
        }
        return list;
    }
}

