/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocElementImpl;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"2\u0006)91\nR8d)\u0006<'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t-$wn\u0019\u0006\u0004aNL'\u0002B5na2Tqb\u0013#pG\u0016cW-\\3oi&k\u0007\u000f\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\t9|G-\u001a\u0006\b\u0003N#fj\u001c3f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*!A.\u00198h\u0015!Ygn\\<o)\u0006<'\u0002D&E_\u000e\\en\\<o)\u0006<'B\u00029beN,'OC\u0006hKR\\en\\<o)\u0006<'\u0002F2iS2$'/\u001a8BMR,'\u000fV1h\u001d\u0006lWM\u0003\u0003MSN$(\u0002\u00026bm\u0006TA!\u001e;jY*Qq-\u001a;D_:$XM\u001c;\u000b\rM#(/\u001b8h\u0015\u001d9W\r\u001e(b[\u0016TabZ3u'V\u0014'.Z2u\u0019&t7N\u0003\u0005L\t>\u001cG*\u001b8l\u001599W\r^*vE*,7\r\u001e(b[\u0016T!\u0002[1t'V\u0014'.Z2u\u0015=\u0019wN\u001c;f]R\u001c\u0005.\u001b7ee\u0016t'b\u0002\"p_2,\u0017M\u001cV\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0019AQ\u0001E\u0004\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011!\u0001BB\u0003\u0003\t\u0013Ai!B\u0002\u0005\u000b!)A\u0002A\u0003\u0003\t\u0015AQ!\u0002\u0002\u0005\u0004!AQa\u0001C\u0007\u0011\u001fa\u0001!\u0002\u0002\u0005\u000e!=Q!\u0001E\u0002\u000b\r!\u0001\u0002c\u0005\r\u0001\u0015\t\u0001BC\u0003\u0003\t%A)\"\u0002\u0002\u0005\u0014!MQa\u0001\u0003\t\u0011/a\u0001!\u0002\u0002\u0005\u0013!5QA\u0001\u0003\f\u0011/)1\u0001\"\u0002\t\u001b1\u0001QA\u0001C\u0003\u00115)1\u0001\u0002\u0005\t\u001f1\u0001Aa\u0003\u0007\u00043\t)\u0011\u0001c\u0002.\u001b\u0011\u0019G\u0001G\u0004\"\u0007\u0015\t\u0001b\u0002G\u0001I\r*6\u0001B\u0007\u0004\t#I\u0011\u0001c\u0004.\u001c\u0011\t\u0001$C\u0011\u0007\u000b\u0005A\t\"C\u0002\n\u0005\u0015\t\u00012B)\u0004\u0007\u0011I\u0011\"\u0001\u0005\u000b['!1\u0002G\u0006\"\u0005\u0015\t\u0001RC)\u0004\u0007\u0011Y\u0011\"\u0001E\f[+!1\u0002\u0007\u0007\"\u0007\u0015\t\u0001R\u0003G\u0001#\u000e\u0019A\u0001D\u0005\u0002\u0011/i+\u0002B\u0002\u0019\u001a\u0005\u001aQ!\u0001\u0005\r\u0019\u0003\t6a\u0001C\r\u0013\u0005AI\",\u0006\u0005\u0017am\u0011eA\u0003\u0002\u0011+a\t!U\u0002\u0004\t7I\u0011\u0001c\u0006./\u0011\t\u0001DDO\u000b\t\u0001Ai\"\u0004\u0004\u0006\u0003!E\u0011bA\u0005\u0003\u000b\u0005AY\u0001U\u0002\u0001C\t)\u0011\u0001C\u0007R\u0007\u0015!a\"C\u0001\u0005\u00025\t\u0001BC[\u0015\u000bO!1\u001d\u0001\r\u0005;\u001b!\u0001\u0001#\u0003\u000e\u0005\u0015\t\u00012\u0002)\u0004\u0001\u0005\u0012Q!\u0001\u0005\u0004#\u000e)A\u0001B\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0004"})
public class KDocTag
extends KDocElementImpl {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KDocTag.class);
    }

    @Override
    @Nullable
    public String getName() {
        Object tagName = this.findChildByType(KDocTokens.TAG_NAME);
        if (tagName != null) {
            return KotlinPackage.substring(tagName.getText(), 1);
        }
        return null;
    }

    @Nullable
    public String getSubjectName() {
        KDocLink kDocLink = this.getSubjectLink();
        return kDocLink != null ? kDocLink.getLinkText() : null;
    }

    @Nullable
    public final KDocLink getSubjectLink() {
        List<ASTNode> children = this.childrenAfterTagName();
        if (this.hasSubject(children)) {
            ASTNode aSTNode = KotlinPackage.firstOrNull(children);
            PsiElement psiElement = aSTNode != null ? aSTNode.getPsi() : null;
            if (!(psiElement instanceof KDocLink)) {
                psiElement = null;
            }
            return (KDocLink)psiElement;
        }
        return null;
    }

    @Nullable
    public final KDocKnownTag getKnownTag() {
        String name = this.getName();
        return name != null ? KDocKnownTag.findByTagName(name) : (KDocKnownTag)null;
    }

    private final boolean hasSubject(@JetValueParameter(name="contentChildren") List<? extends ASTNode> contentChildren) {
        KDocKnownTag kDocKnownTag = this.getKnownTag();
        if (kDocKnownTag != null ? kDocKnownTag.isReferenceRequired() : false) {
            ASTNode aSTNode = KotlinPackage.firstOrNull(contentChildren);
            return Intrinsics.areEqual(aSTNode != null ? aSTNode.getElementType() : null, KDocTokens.MARKDOWN_LINK);
        }
        return false;
    }

    private final List<ASTNode> childrenAfterTagName() {
        ASTNode it;
        Object item;
        Object $receiver = this.getNode().getChildren(null);
        boolean yielding = false;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < ((Object[])$receiver).length; ++i) {
            item = $receiver[i];
            if (yielding) {
                list.add(item);
                continue;
            }
            it = (ASTNode)item;
            if (Intrinsics.areEqual(it.getElementType(), KDocTokens.TAG_NAME)) continue;
            list.add(item);
            yielding = true;
        }
        $receiver = list;
        yielding = false;
        list = new ArrayList();
        Iterator iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            item = iterator2.next();
            if (yielding) {
                list.add(item);
                continue;
            }
            it = (ASTNode)item;
            if (Intrinsics.areEqual(it.getElementType(), TokenType.WHITE_SPACE)) continue;
            list.add(item);
            yielding = true;
        }
        return list;
    }

    @NotNull
    public String getContent() {
        StringBuilder builder = new StringBuilder();
        boolean contentStarted = false;
        boolean afterAsterisk = false;
        List<ASTNode> children = this.childrenAfterTagName();
        if (this.hasSubject(children)) {
            children = KotlinPackage.drop((Iterable)children, 1);
        }
        for (ASTNode node : children) {
            IElementType type2 = node.getElementType();
            if (KDocTokens.CONTENT_TOKENS.contains(type2)) {
                contentStarted = true;
                builder.append(afterAsterisk ? StringUtil.trimLeading(node.getText()) : node.getText());
                afterAsterisk = false;
            }
            if (Intrinsics.areEqual(type2, KDocTokens.LEADING_ASTERISK)) {
                afterAsterisk = true;
            }
            if (Intrinsics.areEqual(type2, TokenType.WHITE_SPACE) && contentStarted) {
                builder.append(StringUtil.repeat("\n", StringUtil.countNewLines(node.getText())));
            }
            if (!Intrinsics.areEqual(type2, KDocElementTypes.KDOC_TAG)) continue;
            break;
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "builder.toString()");
        return string;
    }

    public KDocTag(@JetValueParameter(name="node") @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }
}

