/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;

public class JetFileStubBuilder
extends DefaultStubBuilder {
    @Override
    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/psi/stubs/elements/JetFileStubBuilder", "createStubForFile"));
        }
        if (!(file instanceof JetFile)) {
            StubElement stubElement = super.createStubForFile(file);
            if (stubElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/JetFileStubBuilder", "createStubForFile"));
            }
            return stubElement;
        }
        JetFile jetFile = (JetFile)file;
        KotlinFileStubImpl kotlinFileStubImpl = new KotlinFileStubImpl(jetFile, jetFile.getPackageFqNameByTree().asString(), jetFile.isScriptByTree());
        if (kotlinFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/JetFileStubBuilder", "createStubForFile"));
        }
        return kotlinFileStubImpl;
    }
}

