/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;

public class TemporaryBindingTrace
extends DelegatingBindingTrace {
    protected final BindingTrace trace;

    @NotNull
    public static TemporaryBindingTrace create(@NotNull BindingTrace trace, String debugName) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/TemporaryBindingTrace", "create"));
        }
        TemporaryBindingTrace temporaryBindingTrace = new TemporaryBindingTrace(trace, debugName);
        if (temporaryBindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TemporaryBindingTrace", "create"));
        }
        return temporaryBindingTrace;
    }

    @NotNull
    public static TemporaryBindingTrace create(@NotNull BindingTrace trace, String debugName, @Nullable Object resolutionSubjectForMessage) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/TemporaryBindingTrace", "create"));
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, AnalyzingUtils.formDebugNameForBindingTrace(debugName, resolutionSubjectForMessage));
        if (temporaryBindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TemporaryBindingTrace", "create"));
        }
        return temporaryBindingTrace;
    }

    protected TemporaryBindingTrace(@NotNull BindingTrace trace, String debugName) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/TemporaryBindingTrace", "<init>"));
        }
        super(trace.getBindingContext(), debugName);
        this.trace = trace;
    }

    public void commit() {
        this.addAllMyDataTo(this.trace);
        this.clear();
    }

    public void commit(@NotNull TraceEntryFilter filter, boolean commitDiagnostics) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/resolve/TemporaryBindingTrace", "commit"));
        }
        this.addAllMyDataTo(this.trace, filter, commitDiagnostics);
        this.clear();
    }
}

