/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilPackage;

public class ReifiedTypeParameterSubstitutionChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context2) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "check"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "check"));
        }
        Map<TypeParameterDescriptor, JetType> typeArguments = resolvedCall.getTypeArguments();
        for (Map.Entry<TypeParameterDescriptor, JetType> entry : typeArguments.entrySet()) {
            TypeParameterDescriptor parameter = entry.getKey();
            JetType argument = entry.getValue();
            ClassifierDescriptor argumentDeclarationDescription = argument.getConstructor().getDeclarationDescriptor();
            if (!parameter.isReified()) continue;
            if (argumentDeclarationDescription instanceof TypeParameterDescriptor && !((TypeParameterDescriptor)argumentDeclarationDescription).isReified()) {
                context2.trace.report(Errors.TYPE_PARAMETER_AS_REIFIED.on(ReifiedTypeParameterSubstitutionChecker.getCallElement(context2), parameter));
                continue;
            }
            if (!TypeUtilPackage.cannotBeReified(argument)) continue;
            context2.trace.report(Errors.REIFIED_TYPE_FORBIDDEN_SUBSTITUTION.on(ReifiedTypeParameterSubstitutionChecker.getCallElement(context2), argument));
        }
    }

    @NotNull
    private static PsiElement getCallElement(@NotNull BasicCallResolutionContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "getCallElement"));
        }
        JetExpression callee = context2.call.getCalleeExpression();
        JetElement jetElement = callee != null ? callee : context2.call.getCallElement();
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "getCallElement"));
        }
        return jetElement;
    }
}

