/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.types.JetType;

public class ClassReceiver
implements ThisReceiver {
    private final ClassDescriptor classDescriptor;

    public ClassReceiver(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/scopes/receivers/ClassReceiver", "<init>"));
        }
        this.classDescriptor = classDescriptor;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    @NotNull
    public JetType getType() {
        JetType jetType = this.classDescriptor.getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/receivers/ClassReceiver", "getType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public ClassDescriptor getDeclarationDescriptor() {
        ClassDescriptor classDescriptor = this.classDescriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/receivers/ClassReceiver", "getDeclarationDescriptor"));
        }
        return classDescriptor;
    }

    public String toString() {
        return "Class{" + this.getType() + "}";
    }
}

