/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;
import org.jetbrains.plugins.groovy.dsl.DslActivationStatus;
import org.jetbrains.plugins.groovy.dsl.DslErrorReporter;
import org.jetbrains.plugins.groovy.dsl.GdslUtil;
import org.jetbrains.plugins.groovy.dsl.GroovyDslExecutor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslScript;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyDslFileIndex
extends ScalarIndexExtension<String> {
    private static final Key<Pair<GroovyDslExecutor, Long>> CACHED_EXECUTOR = Key.create((String)"CachedGdslExecutor");
    private static final Key<CachedValue<List<GroovyDslScript>>> SCRIPTS_CACHE = Key.create((String)"GdslScriptCache");
    private static final Logger LOG = Logger.getInstance(GroovyDslFileIndex.class);
    @NonNls
    private static final String OUR_KEY = "ourKey";
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"GroovyDslFileIndex");
    private static final MultiMap<String, LinkedBlockingQueue<Pair<VirtualFile, GroovyDslExecutor>>> filesInProcessing = new ConcurrentMultiMap();
    private static final ThreadPoolExecutor ourPool = new ThreadPoolExecutor(4, 4, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory((String)"Groovy DSL File Index Executor"));
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();

    public GroovyDslFileIndex() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$1", "contentsChanged"));
                }
                VirtualFile file = event.getFile();
                if (event.isFromRefresh() || !GdslUtil.GDSL_FILTER.value((Object)file) || GroovyDslFileIndex.getStatus(file) != DslActivationStatus.Status.ACTIVE) {
                    return;
                }
                GroovyDslFileIndex.disableFile(file, DslActivationStatus.Status.MODIFIED, null);
            }
        });
    }

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        MyDataIndexer myDataIndexer = this.myDataIndexer;
        if (myDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "getIndexer"));
        }
        return myDataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = this.myKeyDescriptor;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        MyInputFilter myInputFilter = new MyInputFilter();
        if (myInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "getInputFilter"));
        }
        return myInputFilter;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    public int getVersion() {
        return 0;
    }

    @Nullable
    public static String getError(VirtualFile file) {
        return DslActivationStatus.getInstance().getGdslFileInfo((VirtualFile)file).error;
    }

    public static boolean isActivated(VirtualFile file) {
        return DslActivationStatus.getInstance().getGdslFileInfo((VirtualFile)file).status == DslActivationStatus.Status.ACTIVE;
    }

    public static void activate(VirtualFile vfile) {
        GroovyDslFileIndex.setStatusAndError(vfile, DslActivationStatus.Status.ACTIVE, null);
        GroovyDslFileIndex.clearScriptCache();
    }

    public static DslActivationStatus.Status getStatus(VirtualFile file) {
        return DslActivationStatus.getInstance().getGdslFileInfo((VirtualFile)file).status;
    }

    private static void clearScriptCache() {
        Application app = ApplicationManager.getApplication();
        app.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    project.putUserData(SCRIPTS_CACHE, null);
                    ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
                }
            }
        }, app.getDisposed());
    }

    static void disableFile(@NotNull VirtualFile vfile, @NotNull DslActivationStatus.Status status, @Nullable String error) {
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "disableFile"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "disableFile"));
        }
        assert (status != DslActivationStatus.Status.ACTIVE);
        GroovyDslFileIndex.setStatusAndError(vfile, status, error);
        vfile.putUserData(CACHED_EXECUTOR, null);
        GroovyDslFileIndex.clearScriptCache();
    }

    private static void setStatusAndError(@NotNull VirtualFile vfile, @NotNull DslActivationStatus.Status status, @Nullable String error) {
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "setStatusAndError"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "setStatusAndError"));
        }
        DslActivationStatus.Entry entry = DslActivationStatus.getInstance().getGdslFileInfo(vfile);
        entry.status = status;
        entry.error = error;
    }

    @Nullable
    private static GroovyDslExecutor getCachedExecutor(@NotNull VirtualFile file, long stamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "getCachedExecutor"));
        }
        Pair pair = (Pair)file.getUserData(CACHED_EXECUTOR);
        if (pair == null || (Long)pair.second != stamp) {
            return null;
        }
        return (GroovyDslExecutor)pair.first;
    }

    @Nullable
    public static PsiClassType processScriptSuperClasses(@NotNull GroovyFile scriptFile) {
        if (scriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFile", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "processScriptSuperClasses"));
        }
        if (!scriptFile.isScript()) {
            return null;
        }
        VirtualFile virtualFile = scriptFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String filePath = virtualFile.getPath();
        ArrayList supers = ContainerUtil.newArrayList();
        Project project = scriptFile.getProject();
        for (GroovyDslScript script : GroovyDslFileIndex.getDslScripts(project)) {
            MultiMap staticInfo = script.getStaticInfo();
            List infos = staticInfo != null ? staticInfo.get((Object)"scriptSuperClass") : Collections.emptyList();
            for (Object info : infos) {
                if (!(info instanceof Map)) continue;
                Map map = (Map)info;
                Object _pattern = map.get("pattern");
                Object _superClass = map.get("superClass");
                if (!(_pattern instanceof String) || !(_superClass instanceof String)) continue;
                String pattern = (String)_pattern;
                String superClass = (String)_superClass;
                try {
                    if (!Pattern.matches(".*" + pattern, filePath)) continue;
                    supers.add(Trinity.create((Object)superClass, (Object)pattern, (Object)script));
                }
                catch (RuntimeException e) {
                    script.handleDslError(e);
                }
            }
        }
        if (!supers.isEmpty()) {
            GroovyDslScript script;
            String className = (String)((Trinity)supers.get((int)0)).first;
            script = (GroovyDslScript)((Trinity)supers.get((int)0)).third;
            try {
                return TypesUtil.createTypeByFQClassName(className, scriptFile);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                script.handleDslError(e);
                return null;
            }
        }
        return null;
    }

    public static boolean processExecutors(PsiType psiType, PsiElement place, final PsiScopeProcessor processor, ResolveState state) {
        if (GroovyDslFileIndex.insideAnnotation(place)) {
            return true;
        }
        String qname = psiType.getCanonicalText();
        PsiFile placeFile = place.getContainingFile().getOriginalFile();
        DelegatingScopeProcessor nameChecker = new DelegatingScopeProcessor(processor){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$3", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$3", "execute"));
                }
                if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                    return processor.execute(element, state);
                }
                if (element instanceof PsiNamedElement) {
                    return ResolveUtil.processElement(processor, (PsiNamedElement)element, state);
                }
                return processor.execute(element, state);
            }
        };
        for (GroovyDslScript script : GroovyDslFileIndex.getDslScripts(place.getProject())) {
            if (script.processExecutor((PsiScopeProcessor)nameChecker, psiType, place, placeFile, qname, state)) continue;
            return false;
        }
        return true;
    }

    private static boolean insideAnnotation(@Nullable PsiElement place) {
        while (place != null) {
            if (place instanceof PsiAnnotation) {
                return true;
            }
            if (place instanceof GrClosableBlock || place instanceof GrTypeDefinition || place instanceof PsiFile) {
                return false;
            }
            place = place.getParent();
        }
        return false;
    }

    private static List<VirtualFile> getGdslFiles(Project project) {
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(GroovyDslFileIndex.getBundledGdslFiles());
        result.addAll(GroovyDslFileIndex.getProjectGdslFiles(project));
        return result;
    }

    private static List<VirtualFile> getBundledGdslFiles() {
        ArrayList result = ContainerUtil.newArrayList();
        for (File file : GroovyDslFileIndex.getBundledScriptFolders()) {
            File[] children;
            if (!file.exists() || (children = file.listFiles()) == null) continue;
            for (File child : children) {
                String fileName = child.getName();
                if (!fileName.endsWith(".gdsl")) continue;
                String path = FileUtil.toSystemIndependentName((String)child.getPath());
                String url = VirtualFileManager.constructUrl((String)"file", (String)path);
                ContainerUtil.addIfNotNull((Collection)result, (Object)VirtualFileManager.getInstance().refreshAndFindFileByUrl(url));
            }
        }
        return result;
    }

    private static List<VirtualFile> getProjectGdslFiles(Project project) {
        ArrayList result = ContainerUtil.newArrayList();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        for (VirtualFile vfile : FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)OUR_KEY, scope)) {
            if (!vfile.isValid()) continue;
            if (!GdslUtil.GDSL_FILTER.value((Object)vfile)) {
                LOG.error("Index returned non-gdsl file: " + vfile);
                continue;
            }
            if (fileIndex.isInLibrarySource(vfile) || !fileIndex.isInLibraryClasses(vfile) && (!fileIndex.isInSourceContent(vfile) || !GroovyDslFileIndex.isActivated(vfile))) continue;
            result.add(vfile);
        }
        return result;
    }

    @NotNull
    private static Set<File> getBundledScriptFolders() {
        Object[] extensions = (GroovyFrameworkConfigNotification[])GroovyFrameworkConfigNotification.EP_NAME.getExtensions();
        HashSet<Class<GroovyFrameworkConfigNotification>> classes = new HashSet<Class<GroovyFrameworkConfigNotification>>(ContainerUtil.map2Set((Object[])extensions, (Function)new Function<GroovyFrameworkConfigNotification, Class>(){

            public Class fun(GroovyFrameworkConfigNotification notification) {
                return notification.getClass();
            }
        }));
        classes.add(GroovyFrameworkConfigNotification.class);
        LinkedHashSet<File> scriptFolders = new LinkedHashSet<File>();
        for (Class clazz : classes) {
            File jarPath = new File(PathUtil.getJarPathForClass((Class)clazz));
            if (jarPath.isFile()) {
                jarPath = jarPath.getParentFile();
            }
            scriptFolders.add(new File(jarPath, "standardDsls"));
        }
        LinkedHashSet<File> linkedHashSet = scriptFolders;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex", "getBundledScriptFolders"));
        }
        return linkedHashSet;
    }

    private static List<GroovyDslScript> getDslScripts(final Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, SCRIPTS_CACHE, (CachedValueProvider)new CachedValueProvider<List<GroovyDslScript>>(){

            public CachedValueProvider.Result<List<GroovyDslScript>> compute() {
                if (GdslUtil.ourGdslStopped) {
                    return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
                }
                GroovyDslExecutor.getIdeaVersion();
                DslActivationStatus.getInstance();
                int count = 0;
                ArrayList<GroovyDslScript> result = new ArrayList<GroovyDslScript>();
                LinkedBlockingQueue queue = new LinkedBlockingQueue();
                for (VirtualFile vfile : GroovyDslFileIndex.getGdslFiles(project)) {
                    long stamp;
                    GroovyDslExecutor cached = GroovyDslFileIndex.getCachedExecutor(vfile, stamp = vfile.getModificationStamp());
                    if (cached == null) {
                        GroovyDslFileIndex.scheduleParsing(queue, project, vfile, stamp, LoadTextUtil.loadText((VirtualFile)vfile).toString());
                        ++count;
                        continue;
                    }
                    result.add(new GroovyDslScript(project, vfile, cached, vfile.getPath()));
                }
                try {
                    while (count > 0 && !GdslUtil.ourGdslStopped) {
                        ProgressManager.checkCanceled();
                        Pair pair = (Pair)queue.poll(20L, TimeUnit.MILLISECONDS);
                        if (pair == null) continue;
                        --count;
                        if (pair.second == null) continue;
                        result.add(new GroovyDslScript(project, (VirtualFile)pair.first, (GroovyDslExecutor)pair.second, ((VirtualFile)pair.first).getPath()));
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
                return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleParsing(LinkedBlockingQueue<Pair<VirtualFile, GroovyDslExecutor>> queue, final Project project, final VirtualFile vfile, final long stamp, final String text) {
        final String fileUrl = vfile.getUrl();
        Runnable parseScript = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GroovyDslExecutor executor = GroovyDslFileIndex.getCachedExecutor(vfile, stamp);
                try {
                    if (executor == null && GroovyDslFileIndex.isActivated(vfile)) {
                        executor = GroovyDslFileIndex.createExecutor(text, vfile, project);
                        vfile.putUserData(CACHED_EXECUTOR, (Object)Pair.create((Object)executor, (Object)stamp));
                        if (executor != null) {
                            GroovyDslFileIndex.activate(vfile);
                        }
                    }
                }
                finally {
                    MultiMap multiMap = filesInProcessing;
                    synchronized (multiMap) {
                        for (LinkedBlockingQueue queue : filesInProcessing.remove((Object)fileUrl)) {
                            queue.offer(Pair.create((Object)vfile, (Object)executor));
                        }
                    }
                }
            }
        };
        MultiMap<String, LinkedBlockingQueue<Pair<VirtualFile, GroovyDslExecutor>>> multiMap = filesInProcessing;
        synchronized (multiMap) {
            boolean isNewRequest = !filesInProcessing.containsKey((Object)fileUrl);
            filesInProcessing.putValue((Object)fileUrl, queue);
            if (isNewRequest) {
                ourPool.execute(parseScript);
            }
        }
    }

    @Nullable
    private static GroovyDslExecutor createExecutor(String text, VirtualFile vfile, Project project) {
        if (GdslUtil.ourGdslStopped) {
            return null;
        }
        try {
            return new GroovyDslExecutor(text, vfile.getName());
        }
        catch (Throwable e) {
            if (project.isDisposed()) {
                LOG.error(e);
                return null;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(e);
                return null;
            }
            DslErrorReporter.getInstance().invokeDslErrorPopup(e, project, vfile);
            if (e instanceof OutOfMemoryError) {
                GdslUtil.stopGdsl();
                throw (Error)e;
            }
            if (e instanceof NoClassDefFoundError) {
                GdslUtil.stopGdsl();
                throw (NoClassDefFoundError)e;
            }
            return null;
        }
    }

    static {
        ourPool.allowCoreThreadTimeOut(true);
    }

    private static class MyInputFilter
    extends DefaultFileTypeSpecificInputFilter {
        MyInputFilter() {
            super(new FileType[]{GroovyFileType.GROOVY_FILE_TYPE});
        }

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$MyInputFilter", "acceptInput"));
            }
            return GdslUtil.GDSL_FILTER.value((Object)file);
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$MyDataIndexer", "map"));
            }
            Map<String, Object> map = Collections.singletonMap(GroovyDslFileIndex.OUR_KEY, null);
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$MyDataIndexer", "map"));
            }
            return map;
        }
    }
}

