/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderHelperLightPsiClass;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.GrBuilderStrategySupport;

public class DefaultBuilderStrategySupport
extends GrBuilderStrategySupport {
    public static final String DEFAULT_STRATEGY_FQN = "groovy.transform.builder.DefaultStrategy";

    @Override
    @NotNull
    public GrBuilderStrategySupport.Members process(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "process"));
        }
        GrBuilderStrategySupport.Members members = new DefaultBuilderStrategyHandler(typeDefinition).doProcess();
        if (members == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "process"));
        }
        return members;
    }

    private static class DefaultBuilderStrategyHandler {
        @NotNull
        private final GrTypeDefinition myContainingClass;
        @NotNull
        private final PsiElementFactory myElementFactory;
        private final GrBuilderStrategySupport.Members myMembers;

        private DefaultBuilderStrategyHandler(@NotNull GrTypeDefinition typeDefinition) {
            if (typeDefinition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "<init>"));
            }
            this.myContainingClass = typeDefinition;
            this.myElementFactory = PsiElementFactory.SERVICE.getInstance((Project)typeDefinition.getProject());
            this.myMembers = new GrBuilderStrategySupport.Members();
        }

        @NotNull
        private PsiManager getManager() {
            PsiManager psiManager = this.myContainingClass.getManager();
            if (psiManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getManager"));
            }
            return psiManager;
        }

        @NotNull
        public GrBuilderStrategySupport.Members doProcess() {
            this.processTypeDefinition();
            this.processMethods();
            GrBuilderStrategySupport.Members members = this.myMembers;
            if (members == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "doProcess"));
            }
            return members;
        }

        private void processTypeDefinition() {
            PsiAnnotation builderAnno = PsiImplUtil.getAnnotation((PsiModifierListOwner)this.myContainingClass, "groovy.transform.builder.Builder");
            if (builderAnno == null || !DefaultBuilderStrategySupport.DEFAULT_STRATEGY_FQN.equals(GrBuilderStrategySupport.getStrategy((PsiModifierListOwner)this.myContainingClass))) {
                return;
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(builderAnno, this.myContainingClass.getCodeFields());
            LightMethodBuilder builderMethod = this.createBuilderMethod((PsiClass)builderClass, builderAnno);
            this.myMembers.classes.add((PsiClass)builderClass);
            this.myMembers.methods.add((PsiMethod)builderMethod);
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull GrVariable[] setters) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            if (setters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setters", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            LightPsiClassBuilder lightPsiClassBuilder = this.createBuilderClass(annotation, setters, null);
            if (lightPsiClassBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            return lightPsiClassBuilder;
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull GrVariable[] setters, @Nullable PsiType builtType) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            if (setters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setters", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            BuilderHelperLightPsiClass builderClass = new BuilderHelperLightPsiClass(this.myContainingClass, DefaultBuilderStrategyHandler.getBuilderClassName(annotation, this.myContainingClass));
            for (GrVariable field : setters) {
                builderClass.addMethod((PsiMethod)this.createFieldSetter((PsiClass)builderClass, field, annotation));
            }
            LightMethodBuilder buildMethod = new LightMethodBuilder(this.getManager(), DefaultBuilderStrategyHandler.getBuildMethodName(annotation));
            buildMethod.setContainingClass((PsiClass)builderClass);
            buildMethod.setOriginInfo("by @Builder");
            buildMethod.setMethodReturnType((PsiType)(builtType == null ? this.myElementFactory.createType((PsiClass)this.myContainingClass) : builtType));
            LightPsiClassBuilder lightPsiClassBuilder = builderClass.addMethod((PsiMethod)buildMethod);
            if (lightPsiClassBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            return lightPsiClassBuilder;
        }

        @NotNull
        private LightMethodBuilder createBuilderMethod(@NotNull PsiClass builderClass, @NotNull PsiAnnotation annotation) {
            if (builderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderMethod"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderMethod"));
            }
            LightMethodBuilder builderMethod = new LightMethodBuilder(this.getManager(), DefaultBuilderStrategyHandler.getBuilderMethodName(annotation));
            builderMethod.addModifier("static");
            builderMethod.setContainingClass((PsiClass)this.myContainingClass);
            builderMethod.setOriginInfo("by @Builder");
            builderMethod.setNavigationElement((PsiElement)annotation);
            builderMethod.setMethodReturnType((PsiType)this.myElementFactory.createType(builderClass));
            LightMethodBuilder lightMethodBuilder = builderMethod;
            if (lightMethodBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderMethod"));
            }
            return lightMethodBuilder;
        }

        private void processMethods() {
            for (GrMethod method : this.myContainingClass.getCodeMethods()) {
                this.processMethod(method);
            }
        }

        private void processMethod(@NotNull GrMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "processMethod"));
            }
            PsiAnnotation annotation = PsiImplUtil.getAnnotation(method, "groovy.transform.builder.Builder");
            if (annotation == null || !DefaultBuilderStrategySupport.DEFAULT_STRATEGY_FQN.equals(GrBuilderStrategySupport.getStrategy(method))) {
                return;
            }
            if (method.isConstructor()) {
                this.processConstructor(method, annotation);
            } else if (method.hasModifierProperty("static")) {
                this.processFactoryMethod(method, annotation);
            }
        }

        private void processConstructor(@NotNull GrMethod method, PsiAnnotation annotation) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "processConstructor"));
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters());
            LightMethodBuilder builderMethod = this.createBuilderMethod((PsiClass)builderClass, annotation);
            this.myMembers.methods.add((PsiMethod)builderMethod);
            this.myMembers.classes.add((PsiClass)builderClass);
        }

        private void processFactoryMethod(@NotNull GrMethod method, PsiAnnotation annotation) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "processFactoryMethod"));
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters(), method.getReturnType());
            LightMethodBuilder builderMethod = this.createBuilderMethod((PsiClass)builderClass, annotation);
            this.myMembers.methods.add((PsiMethod)builderMethod);
            this.myMembers.classes.add((PsiClass)builderClass);
        }

        @NotNull
        private LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull GrVariable field, @NotNull PsiAnnotation annotation) {
            if (builderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createFieldSetter"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createFieldSetter"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createFieldSetter"));
            }
            String name = field.getName();
            LightMethodBuilder fieldSetter = new LightMethodBuilder(this.getManager(), DefaultBuilderStrategyHandler.getFieldMethodName(annotation, name));
            fieldSetter.addModifier("public");
            fieldSetter.addParameter(name, field.getType(), false);
            fieldSetter.setContainingClass(builderClass);
            fieldSetter.setMethodReturnType((PsiType)this.myElementFactory.createType(builderClass));
            fieldSetter.setNavigationElement((PsiElement)field);
            LightMethodBuilder lightMethodBuilder = fieldSetter;
            if (lightMethodBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createFieldSetter"));
            }
            return lightMethodBuilder;
        }

        @NotNull
        private static String getBuilderMethodName(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getBuilderMethodName"));
            }
            String builderMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderMethodName");
            String string = builderMethodName == null ? "builder" : builderMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getBuilderMethodName"));
            }
            return string;
        }

        @NotNull
        private static String getBuilderClassName(@NotNull PsiAnnotation annotation, @NotNull GrTypeDefinition clazz) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getBuilderClassName"));
            }
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getBuilderClassName"));
            }
            String builderClassName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderClassName");
            String string = builderClassName == null ? String.format("%s%s", clazz.getName(), "Builder") : builderClassName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getBuilderClassName"));
            }
            return string;
        }

        @NotNull
        private static String getFieldMethodName(@NotNull PsiAnnotation annotation, @NotNull String fieldName) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getFieldMethodName"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getFieldMethodName"));
            }
            String prefix = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"prefix");
            String string = prefix == null ? fieldName : String.format("%s%s", prefix, StringUtil.capitalize((String)fieldName));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getFieldMethodName"));
            }
            return string;
        }

        @NotNull
        private static String getBuildMethodName(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getBuildMethodName"));
            }
            String buildMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"buildMethodName");
            String string = buildMethodName == null ? "build" : buildMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getBuildMethodName"));
            }
            return string;
        }
    }
}

