/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.KeepingExpandedExpander;

public abstract class AbstractOpeningExpander
implements Expander {
    private final RepositoryBrowserComponent myBrowser;
    private final KeepingExpandedExpander myKeepingExpander;
    private final String mySelectionPath;

    protected AbstractOpeningExpander(RepositoryBrowserComponent browser, String selectionPath) {
        this.myBrowser = browser;
        this.myKeepingExpander = new KeepingExpandedExpander(browser);
        this.mySelectionPath = selectionPath;
    }

    @Override
    public void onBeforeRefresh(RepositoryTreeNode node) {
        this.myKeepingExpander.onBeforeRefresh(node);
    }

    protected abstract ExpandVariants expandNode(String var1);

    protected abstract boolean checkChild(String var1);

    @Override
    public void onAfterRefresh(RepositoryTreeNode node) {
        this.myKeepingExpander.onAfterRefresh(node);
        if (node.isLeaf()) {
            return;
        }
        String myUrl = node.getURL().toString();
        ExpandVariants expandVariant = this.expandNode(myUrl);
        if (ExpandVariants.DO_NOTHING.equals((Object)expandVariant)) {
            return;
        }
        this.myBrowser.expandNode(node);
        if (ExpandVariants.EXPAND_AND_EXIT.equals((Object)expandVariant)) {
            this.removeSelf();
        } else {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                RepositoryTreeNode repositoryTreeNode;
                String childUrl;
                TreeNode treeNode = (TreeNode)children.nextElement();
                if (!(treeNode instanceof RepositoryTreeNode) || !this.checkChild(childUrl = (repositoryTreeNode = (RepositoryTreeNode)treeNode).getURL().toString())) continue;
                if (this.mySelectionPath != null && this.mySelectionPath.equals(childUrl)) {
                    this.myBrowser.setSelectedNode(repositoryTreeNode);
                }
                repositoryTreeNode.reload(this, false);
                return;
            }
            this.removeSelf();
        }
    }

    private void removeSelf() {
        this.myBrowser.setLazyLoadingExpander(new KeepingExpandedExpander.Factory());
    }

    protected static enum ExpandVariants {
        DO_NOTHING,
        EXPAND_AND_EXIT,
        EXPAND_CONTINUE;

    }
}

