/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import org.gradle.api.Transformer;
import org.gradle.api.internal.AbstractClassGenerator;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.ConventionAwareHelper;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.ThreadGlobalInstantiator;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.util.CollectionUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmBackedClassGenerator
extends AbstractClassGenerator {
    private static final JavaMethod<ClassLoader, Class> DEFINE_CLASS_METHOD = JavaReflectionUtil.method(ClassLoader.class, Class.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});

    @Override
    protected <T> AbstractClassGenerator.ClassBuilder<T> start(Class<T> type, AbstractClassGenerator.ClassMetaData classMetaData) {
        return new ClassBuilderImpl(type, classMetaData);
    }

    public static class MixInExtensibleDynamicObject
    extends ExtensibleDynamicObject {
        public MixInExtensibleDynamicObject(Object delegateObject, DynamicObject dynamicObject) {
            super(delegateObject, MixInExtensibleDynamicObject.wrap(delegateObject, dynamicObject), ThreadGlobalInstantiator.getOrCreate());
        }

        private static AbstractDynamicObject wrap(Object delegateObject, DynamicObject dynamicObject) {
            if (dynamicObject != null) {
                return (AbstractDynamicObject)dynamicObject;
            }
            return new BeanDynamicObject(delegateObject);
        }
    }

    private static interface MethodCodeBody {
        public void add(MethodVisitor var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassBuilderImpl<T>
    implements AbstractClassGenerator.ClassBuilder<T> {
        private static final String DYNAMIC_OBJECT_HELPER_FIELD = "__dyn_obj__";
        private static final String MAPPING_FIELD = "__mapping__";
        private static final String META_CLASS_FIELD = "__meta_class__";
        private final ClassWriter visitor;
        private final Class<T> type;
        private final String typeName;
        private final org.objectweb.asm.Type generatedType;
        private final org.objectweb.asm.Type superclassType;
        private final org.objectweb.asm.Type conventionAwareType = org.objectweb.asm.Type.getType(IConventionAware.class);
        private final org.objectweb.asm.Type dynamicObjectAwareType = org.objectweb.asm.Type.getType(DynamicObjectAware.class);
        private final org.objectweb.asm.Type extensionAwareType = org.objectweb.asm.Type.getType(ExtensionAware.class);
        private final org.objectweb.asm.Type hasConventionType = org.objectweb.asm.Type.getType(HasConvention.class);
        private final org.objectweb.asm.Type dynamicObjectType = org.objectweb.asm.Type.getType(DynamicObject.class);
        private final org.objectweb.asm.Type conventionMappingType = org.objectweb.asm.Type.getType(ConventionMapping.class);
        private final org.objectweb.asm.Type groovyObjectType = org.objectweb.asm.Type.getType(GroovyObject.class);
        private final org.objectweb.asm.Type conventionType = org.objectweb.asm.Type.getType(Convention.class);
        private final org.objectweb.asm.Type extensibleDynamicObjectHelperType = org.objectweb.asm.Type.getType(MixInExtensibleDynamicObject.class);
        private final org.objectweb.asm.Type nonExtensibleDynamicObjectHelperType = org.objectweb.asm.Type.getType(BeanDynamicObject.class);
        private final boolean conventionAware;
        private final boolean extensible;
        private final boolean providesOwnDynamicObject;

        private ClassBuilderImpl(Class<T> type, AbstractClassGenerator.ClassMetaData classMetaData) {
            this.type = type;
            this.visitor = new ClassWriter(1);
            this.typeName = type.getName() + "_Decorated";
            this.generatedType = org.objectweb.asm.Type.getType((String)("L" + this.typeName.replaceAll("\\.", "/") + ";"));
            this.superclassType = org.objectweb.asm.Type.getType(type);
            this.extensible = classMetaData.isExtensible();
            this.conventionAware = classMetaData.isConventionAware();
            this.providesOwnDynamicObject = classMetaData.providesDynamicObjectImplementation();
        }

        @Override
        public void startClass() {
            ArrayList<String> interfaceTypes = new ArrayList<String>();
            if (this.conventionAware && this.extensible) {
                interfaceTypes.add(this.conventionAwareType.getInternalName());
            }
            if (this.extensible) {
                interfaceTypes.add(this.extensionAwareType.getInternalName());
                interfaceTypes.add(this.hasConventionType.getInternalName());
            }
            interfaceTypes.add(this.dynamicObjectAwareType.getInternalName());
            interfaceTypes.add(this.groovyObjectType.getInternalName());
            this.visitor.visit(49, 1, this.generatedType.getInternalName(), null, this.superclassType.getInternalName(), interfaceTypes.toArray(new String[interfaceTypes.size()]));
        }

        @Override
        public void addConstructor(Constructor<?> constructor) throws Exception {
            ArrayList<org.objectweb.asm.Type> paramTypes = new ArrayList<org.objectweb.asm.Type>();
            for (Class<?> paramType : constructor.getParameterTypes()) {
                paramTypes.add(org.objectweb.asm.Type.getType(paramType));
            }
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])paramTypes.toArray(new org.objectweb.asm.Type[paramTypes.size()]));
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "<init>", methodDescriptor, this.signature(constructor), new String[0]);
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                if (annotation.annotationType().getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotation.annotationType().getAnnotation(Retention.class);
                AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotation(org.objectweb.asm.Type.getType(annotation.annotationType()).getDescriptor(), retention != null && retention.value() == RetentionPolicy.RUNTIME);
                annotationVisitor.visitEnd();
            }
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                methodVisitor.visitVarInsn(org.objectweb.asm.Type.getType(constructor.getParameterTypes()[i]).getOpcode(21), i + 1);
            }
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), "<init>", methodDescriptor);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private String signature(Constructor<?> constructor) {
            StringBuilder builder = new StringBuilder();
            this.visitFormalTypeParameters(builder, constructor.getTypeParameters());
            this.visitParameters(builder, constructor.getGenericParameterTypes());
            builder.append("V");
            this.visitExceptions(builder, constructor.getGenericExceptionTypes());
            return builder.toString();
        }

        private String signature(Method method) {
            StringBuilder builder = new StringBuilder();
            this.visitFormalTypeParameters(builder, method.getTypeParameters());
            this.visitParameters(builder, method.getGenericParameterTypes());
            this.visitType(method.getGenericReturnType(), builder);
            this.visitExceptions(builder, method.getGenericExceptionTypes());
            return builder.toString();
        }

        private void visitExceptions(StringBuilder builder, Type[] exceptionTypes) {
            for (Type exceptionType : exceptionTypes) {
                builder.append('^');
                this.visitType(exceptionType, builder);
            }
        }

        private void visitParameters(StringBuilder builder, Type[] parameterTypes) {
            builder.append('(');
            for (Type paramType : parameterTypes) {
                this.visitType(paramType, builder);
            }
            builder.append(")");
        }

        private void visitFormalTypeParameters(StringBuilder builder, TypeVariable<?>[] typeParameters) {
            if (typeParameters.length > 0) {
                builder.append('<');
                for (TypeVariable<?> typeVariable : typeParameters) {
                    builder.append(typeVariable.getName());
                    for (Type bound : typeVariable.getBounds()) {
                        builder.append(':');
                        this.visitType(bound, builder);
                    }
                }
                builder.append('>');
            }
        }

        private void visitType(Type type, StringBuilder builder) {
            if (type instanceof Class) {
                Class cl = (Class)type;
                if (cl.isPrimitive()) {
                    builder.append(org.objectweb.asm.Type.getType((Class)cl).getDescriptor());
                } else if (cl.isArray()) {
                    builder.append(cl.getName().replace('.', '/'));
                } else {
                    builder.append('L');
                    builder.append(cl.getName().replace('.', '/'));
                    builder.append(';');
                }
            } else if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                this.visitNested(parameterizedType.getRawType(), builder);
                builder.append('<');
                for (Type param : parameterizedType.getActualTypeArguments()) {
                    this.visitType(param, builder);
                }
                builder.append(">;");
            } else if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                if (wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0].equals(Object.class)) {
                    if (wildcardType.getLowerBounds().length == 0) {
                        builder.append('*');
                        return;
                    }
                } else {
                    for (Type upperType : wildcardType.getUpperBounds()) {
                        builder.append('+');
                        this.visitType(upperType, builder);
                    }
                }
                for (Type lowerType : wildcardType.getLowerBounds()) {
                    builder.append('-');
                    this.visitType(lowerType, builder);
                }
            } else if (type instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)type;
                builder.append('T');
                builder.append(typeVar.getName());
                builder.append(';');
            } else if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                builder.append('[');
                this.visitType(arrayType.getGenericComponentType(), builder);
            } else {
                throw new IllegalArgumentException(String.format("Cannot generate signature for %s.", type));
            }
        }

        private void visitNested(Type type, StringBuilder builder) {
            if (type instanceof Class) {
                Class cl = (Class)type;
                if (cl.isPrimitive()) {
                    builder.append(org.objectweb.asm.Type.getType((Class)cl).getDescriptor());
                } else {
                    builder.append('L');
                    builder.append(cl.getName().replace('.', '/'));
                }
            } else {
                this.visitType(type, builder);
            }
        }

        @Override
        public void mixInDynamicAware() throws Exception {
            org.objectweb.asm.Type extensibleObjectFieldType = this.extensible ? this.extensibleDynamicObjectHelperType : this.nonExtensibleDynamicObjectHelperType;
            final String fieldSignature = extensibleObjectFieldType.getDescriptor();
            this.visitor.visitField(2, DYNAMIC_OBJECT_HELPER_FIELD, fieldSignature, null, null);
            final Method getAsDynamicObject = DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]);
            if (this.extensible) {
                this.addGetter(HasConvention.class.getDeclaredMethod("getConvention", new Class[0]), new MethodCodeBody(){

                    public void add(MethodVisitor visitor) throws Exception {
                        visitor.visitVarInsn(25, 0);
                        visitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getAsDynamicObject", org.objectweb.asm.Type.getMethodDescriptor((Method)getAsDynamicObject));
                        visitor.visitTypeInsn(192, ClassBuilderImpl.this.extensibleDynamicObjectHelperType.getInternalName());
                        String getterDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)ExtensibleDynamicObject.class.getDeclaredMethod("getConvention", new Class[0]));
                        visitor.visitMethodInsn(182, ClassBuilderImpl.this.extensibleDynamicObjectHelperType.getInternalName(), "getConvention", getterDescriptor);
                    }
                });
                this.addGetter(ExtensionAware.class.getDeclaredMethod("getExtensions", new Class[0]), new MethodCodeBody(){

                    public void add(MethodVisitor visitor) throws Exception {
                        visitor.visitVarInsn(25, 0);
                        String getterDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)ExtensibleDynamicObject.class.getDeclaredMethod("getConvention", new Class[0]));
                        visitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getConvention", getterDescriptor);
                    }
                });
            }
            this.addGetter(getAsDynamicObject, new MethodCodeBody(){

                public void add(MethodVisitor visitor) {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitFieldInsn(180, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.DYNAMIC_OBJECT_HELPER_FIELD, fieldSignature);
                    Label returnValue = new Label();
                    visitor.visitInsn(89);
                    visitor.visitJumpInsn(199, returnValue);
                    visitor.visitInsn(87);
                    visitor.visitVarInsn(25, 0);
                    ClassBuilderImpl.this.generateCreateDynamicObject(visitor);
                    visitor.visitFieldInsn(181, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.DYNAMIC_OBJECT_HELPER_FIELD, fieldSignature);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitFieldInsn(180, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.DYNAMIC_OBJECT_HELPER_FIELD, fieldSignature);
                    visitor.visitLabel(returnValue);
                }
            });
        }

        private void generateCreateDynamicObject(MethodVisitor visitor) {
            if (this.extensible) {
                String helperTypeConstructorDesc = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Object.class), this.dynamicObjectType});
                visitor.visitTypeInsn(187, this.extensibleDynamicObjectHelperType.getInternalName());
                visitor.visitInsn(89);
                visitor.visitVarInsn(25, 0);
                if (this.providesOwnDynamicObject) {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(183, org.objectweb.asm.Type.getType(this.type).getInternalName(), "getAsDynamicObject", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)this.dynamicObjectType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
                } else {
                    visitor.visitInsn(1);
                }
                visitor.visitMethodInsn(183, this.extensibleDynamicObjectHelperType.getInternalName(), "<init>", helperTypeConstructorDesc);
            } else {
                String helperTypeConstructorDesc = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Object.class)});
                visitor.visitTypeInsn(187, this.nonExtensibleDynamicObjectHelperType.getInternalName());
                visitor.visitInsn(89);
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(183, this.nonExtensibleDynamicObjectHelperType.getInternalName(), "<init>", helperTypeConstructorDesc);
            }
        }

        @Override
        public void mixInConventionAware() throws Exception {
            if (!this.extensible) {
                return;
            }
            final String mappingFieldSignature = org.objectweb.asm.Type.getDescriptor(ConventionMapping.class);
            final String getConventionDesc = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)this.conventionType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            this.visitor.visitField(2, MAPPING_FIELD, mappingFieldSignature, null, null);
            final MethodCodeBody initConventionAwareHelper = new MethodCodeBody(){

                public void add(MethodVisitor visitor) throws Exception {
                    org.objectweb.asm.Type helperType = org.objectweb.asm.Type.getType(ConventionAwareHelper.class);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitTypeInsn(187, helperType.getInternalName());
                    visitor.visitInsn(89);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getConvention", getConventionDesc);
                    String constructorDesc = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{ClassBuilderImpl.this.conventionAwareType, ClassBuilderImpl.this.conventionType});
                    visitor.visitMethodInsn(183, helperType.getInternalName(), "<init>", constructorDesc);
                    visitor.visitFieldInsn(181, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.MAPPING_FIELD, mappingFieldSignature);
                }
            };
            this.addGetter(IConventionAware.class.getDeclaredMethod("getConventionMapping", new Class[0]), new MethodCodeBody(){

                public void add(MethodVisitor visitor) throws Exception {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitFieldInsn(180, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.MAPPING_FIELD, mappingFieldSignature);
                    visitor.visitInsn(89);
                    Label returnValue = new Label();
                    visitor.visitJumpInsn(199, returnValue);
                    visitor.visitInsn(87);
                    initConventionAwareHelper.add(visitor);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitFieldInsn(180, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.MAPPING_FIELD, mappingFieldSignature);
                    visitor.visitLabel(returnValue);
                }
            });
        }

        @Override
        public void mixInGroovyObject() throws Exception {
            final String metaClassFieldSignature = org.objectweb.asm.Type.getDescriptor(MetaClass.class);
            this.visitor.visitField(2, META_CLASS_FIELD, metaClassFieldSignature, null, null);
            final MethodCodeBody initMetaClass = new MethodCodeBody(){

                public void add(MethodVisitor visitor) throws Exception {
                    visitor.visitVarInsn(25, 0);
                    String getMetaClassRegistryDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)GroovySystem.class.getDeclaredMethod("getMetaClassRegistry", new Class[0]));
                    visitor.visitMethodInsn(184, org.objectweb.asm.Type.getType(GroovySystem.class).getInternalName(), "getMetaClassRegistry", getMetaClassRegistryDesc);
                    visitor.visitVarInsn(25, 0);
                    String getClassDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)Object.class.getDeclaredMethod("getClass", new Class[0]));
                    visitor.visitMethodInsn(182, org.objectweb.asm.Type.getType(Object.class).getInternalName(), "getClass", getClassDesc);
                    String getMetaClassDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)MetaClassRegistry.class.getDeclaredMethod("getMetaClass", Class.class));
                    visitor.visitMethodInsn(185, org.objectweb.asm.Type.getType(MetaClassRegistry.class).getInternalName(), "getMetaClass", getMetaClassDesc);
                    visitor.visitFieldInsn(181, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.META_CLASS_FIELD, metaClassFieldSignature);
                }
            };
            this.addGetter(GroovyObject.class.getDeclaredMethod("getMetaClass", new Class[0]), new MethodCodeBody(){

                public void add(MethodVisitor visitor) throws Exception {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitFieldInsn(180, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.META_CLASS_FIELD, metaClassFieldSignature);
                    visitor.visitInsn(89);
                    Label returnValue = new Label();
                    visitor.visitJumpInsn(199, returnValue);
                    visitor.visitInsn(87);
                    initMetaClass.add(visitor);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitFieldInsn(180, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.META_CLASS_FIELD, metaClassFieldSignature);
                    visitor.visitLabel(returnValue);
                }
            });
            this.addSetter(GroovyObject.class.getDeclaredMethod("setMetaClass", MetaClass.class), new MethodCodeBody(){

                public void add(MethodVisitor visitor) throws Exception {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitVarInsn(25, 1);
                    visitor.visitFieldInsn(181, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.META_CLASS_FIELD, metaClassFieldSignature);
                }
            });
        }

        private void addSetter(Method method, MethodCodeBody body) throws Exception {
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)method);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, new String[0]);
            methodVisitor.visitCode();
            body.add(methodVisitor);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void addGetter(Method method, MethodCodeBody body) throws Exception {
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)method);
            String methodName = method.getName();
            this.addGetter(methodName, methodDescriptor, body);
        }

        private void addGetter(String methodName, String methodDescriptor, MethodCodeBody body) throws Exception {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, methodName, methodDescriptor, null, new String[0]);
            methodVisitor.visitCode();
            body.add(methodVisitor);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addDynamicMethods() throws Exception {
            this.addGetter(GroovyObject.class.getDeclaredMethod("getProperty", String.class), new MethodCodeBody(){

                public void add(MethodVisitor methodVisitor) throws Exception {
                    methodVisitor.visitVarInsn(25, 0);
                    String getAsDynamicObjectDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]));
                    methodVisitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getAsDynamicObject", getAsDynamicObjectDesc);
                    methodVisitor.visitVarInsn(25, 1);
                    String getPropertyDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)DynamicObject.class.getDeclaredMethod("getProperty", String.class));
                    methodVisitor.visitMethodInsn(185, ClassBuilderImpl.this.dynamicObjectType.getInternalName(), "getProperty", getPropertyDesc);
                }
            });
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Boolean.TYPE), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(String.class)});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "hasProperty", methodDescriptor, null, new String[0]);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            String getAsDynamicObjectDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]));
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getAsDynamicObject", getAsDynamicObjectDesc);
            methodVisitor.visitVarInsn(25, 1);
            String getPropertyDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)DynamicObject.class.getDeclaredMethod("hasProperty", String.class));
            methodVisitor.visitMethodInsn(185, this.dynamicObjectType.getInternalName(), "hasProperty", getPropertyDesc);
            methodVisitor.visitInsn(172);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            this.addSetter(GroovyObject.class.getDeclaredMethod("setProperty", String.class, Object.class), new MethodCodeBody(){

                public void add(MethodVisitor methodVisitor) throws Exception {
                    methodVisitor.visitVarInsn(25, 0);
                    String getAsDynamicObjectDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]));
                    methodVisitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getAsDynamicObject", getAsDynamicObjectDesc);
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitVarInsn(25, 2);
                    String setPropertyDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)DynamicObject.class.getDeclaredMethod("setProperty", String.class, Object.class));
                    methodVisitor.visitMethodInsn(185, ClassBuilderImpl.this.dynamicObjectType.getInternalName(), "setProperty", setPropertyDesc);
                }
            });
            this.addGetter(GroovyObject.class.getDeclaredMethod("invokeMethod", String.class, Object.class), new MethodCodeBody(){

                public void add(MethodVisitor methodVisitor) throws Exception {
                    String invokeMethodDesc = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(String.class), org.objectweb.asm.Type.getType(Object[].class)});
                    String objArrayDesc = org.objectweb.asm.Type.getType(Object[].class).getDescriptor();
                    methodVisitor.visitVarInsn(25, 0);
                    String getAsDynamicObjectDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]));
                    methodVisitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getAsDynamicObject", getAsDynamicObjectDesc);
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitTypeInsn(193, objArrayDesc);
                    Label end = new Label();
                    Label notArray = new Label();
                    methodVisitor.visitJumpInsn(153, notArray);
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitTypeInsn(192, objArrayDesc);
                    methodVisitor.visitJumpInsn(167, end);
                    methodVisitor.visitLabel(notArray);
                    methodVisitor.visitInsn(4);
                    methodVisitor.visitTypeInsn(189, org.objectweb.asm.Type.getType(Object.class).getInternalName());
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitInsn(83);
                    methodVisitor.visitLabel(end);
                    methodVisitor.visitMethodInsn(185, ClassBuilderImpl.this.dynamicObjectType.getInternalName(), "invokeMethod", invokeMethodDesc);
                }
            });
        }

        @Override
        public void addInjectorProperty(AbstractClassGenerator.PropertyMetaData property) {
            String flagName = this.propFieldName(property);
            this.visitor.visitField(2, flagName, org.objectweb.asm.Type.getDescriptor(property.getType()), null, null);
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetaData property, Method getter) throws Exception {
            org.objectweb.asm.Type serviceRegistryType = org.objectweb.asm.Type.getType(ServiceRegistry.class);
            org.objectweb.asm.Type classType = org.objectweb.asm.Type.getType(Class.class);
            org.objectweb.asm.Type methodType = org.objectweb.asm.Type.getType(Method.class);
            org.objectweb.asm.Type typeType = org.objectweb.asm.Type.getType(Type.class);
            String getterName = getter.getName();
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            org.objectweb.asm.Type serviceType = org.objectweb.asm.Type.getType(property.getType());
            String propFieldName = this.propFieldName(property);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, getterName, methodDescriptor, this.signature(getter), new String[0]);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), propFieldName, serviceType.getDescriptor());
            Label alreadyLoaded = new Label();
            methodVisitor.visitJumpInsn(199, alreadyLoaded);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getServices", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)serviceRegistryType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getClass", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)classType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
            methodVisitor.visitLdcInsn((Object)getterName);
            methodVisitor.visitInsn(3);
            methodVisitor.visitTypeInsn(189, classType.getInternalName());
            methodVisitor.visitMethodInsn(182, classType.getInternalName(), "getDeclaredMethod", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)methodType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(String.class), org.objectweb.asm.Type.getType(Class[].class)}));
            methodVisitor.visitMethodInsn(182, methodType.getInternalName(), "getGenericReturnType", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)typeType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
            methodVisitor.visitMethodInsn(185, serviceRegistryType.getInternalName(), "get", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{typeType}));
            methodVisitor.visitTypeInsn(192, serviceType.getInternalName());
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, serviceType.getDescriptor());
            methodVisitor.visitLabel(alreadyLoaded);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), propFieldName, serviceType.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetaData property, Method setter) throws Exception {
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)setter);
            org.objectweb.asm.Type serviceType = org.objectweb.asm.Type.getType(property.getType());
            String propFieldName = this.propFieldName(property);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, setter.getName(), methodDescriptor, this.signature(setter), new String[0]);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, serviceType.getDescriptor());
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addConventionProperty(AbstractClassGenerator.PropertyMetaData property) throws Exception {
            String flagName = this.propFieldName(property);
            this.visitor.visitField(2, flagName, org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor(), null, null);
        }

        private String propFieldName(AbstractClassGenerator.PropertyMetaData property) {
            return String.format("__%s__", property.getName());
        }

        @Override
        public void applyConventionMappingToGetter(AbstractClassGenerator.PropertyMetaData property, Method getter) throws Exception {
            String flagName = this.propFieldName(property);
            String getterName = getter.getName();
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, getterName, methodDescriptor, null, new String[0]);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(185, this.conventionAwareType.getInternalName(), "getConventionMapping", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)this.conventionMappingType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), getterName, methodDescriptor);
            org.objectweb.asm.Type boxedType = null;
            if (getter.getReturnType().isPrimitive()) {
                boxedType = org.objectweb.asm.Type.getType((Class)JavaReflectionUtil.getWrapperTypeForPrimitiveType(getter.getReturnType()));
                String valueOfMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)boxedType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{returnType});
                methodVisitor.visitMethodInsn(184, boxedType.getInternalName(), "valueOf", valueOfMethodDescriptor);
            }
            methodVisitor.visitLdcInsn((Object)property.getName());
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), flagName, org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor());
            String getConventionValueDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)ConventionMapping.class.getMethod("getConventionValue", Object.class, String.class, Boolean.TYPE));
            methodVisitor.visitMethodInsn(185, this.conventionMappingType.getInternalName(), "getConventionValue", getConventionValueDesc);
            if (getter.getReturnType().isPrimitive()) {
                methodVisitor.visitTypeInsn(192, boxedType.getInternalName());
                String valueMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
                methodVisitor.visitMethodInsn(182, boxedType.getInternalName(), getter.getReturnType().getName() + "Value", valueMethodDescriptor);
            } else {
                methodVisitor.visitTypeInsn(192, getter.getReturnType().isArray() ? "[" + returnType.getElementType().getDescriptor() : returnType.getInternalName());
            }
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetaData property, Method setter) throws Exception {
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(setter.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(setter.getReturnType());
            String setterDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, setter.getName(), setterDescriptor, null, new String[0]);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), setter.getName(), setterDescriptor);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn((Object)true);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), this.propFieldName(property), org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetaData property, Method setter) throws Exception {
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(setter.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(setter.getReturnType());
            String setterDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            String setMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, property.getName(), setMethodDescriptor, null, new String[0]);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), setter.getName(), setterDescriptor);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetaData property, Method method) throws Exception {
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(method.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(method.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, new String[0]);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), method.getName(), methodDescriptor);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn((Object)true);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), this.propFieldName(property), org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addActionMethod(Method method) throws Exception {
            org.objectweb.asm.Type actionImplType = org.objectweb.asm.Type.getType(ClosureBackedAction.class);
            org.objectweb.asm.Type closureType = org.objectweb.asm.Type.getType(Closure.class);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(method.getReturnType());
            org.objectweb.asm.Type[] originalParameterTypes = (org.objectweb.asm.Type[])CollectionUtils.collectArray((Object[])method.getParameterTypes(), org.objectweb.asm.Type.class, (Transformer)new Transformer<org.objectweb.asm.Type, Class>(){

                public org.objectweb.asm.Type transform(Class clazz) {
                    return org.objectweb.asm.Type.getType((Class)clazz);
                }
            });
            int numParams = originalParameterTypes.length;
            org.objectweb.asm.Type[] closurisedParameterTypes = new org.objectweb.asm.Type[numParams];
            System.arraycopy(originalParameterTypes, 0, closurisedParameterTypes, 0, numParams);
            closurisedParameterTypes[numParams - 1] = closureType;
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])closurisedParameterTypes);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, new String[0]);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            for (int stackVar = 1; stackVar < numParams; ++stackVar) {
                methodVisitor.visitVarInsn(closurisedParameterTypes[stackVar - 1].getOpcode(21), stackVar);
            }
            methodVisitor.visitTypeInsn(187, actionImplType.getInternalName());
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, numParams);
            String constuctorDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{closureType});
            methodVisitor.visitMethodInsn(183, actionImplType.getInternalName(), "<init>", constuctorDescriptor);
            methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(method.getReturnType()), (org.objectweb.asm.Type[])originalParameterTypes);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), method.getName(), methodDescriptor);
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public Class<? extends T> generate() {
            this.visitor.visitEnd();
            byte[] bytecode = this.visitor.toByteArray();
            return (Class)DEFINE_CLASS_METHOD.invoke((Object)this.type.getClassLoader(), new Object[]{this.typeName, bytecode, 0, bytecode.length});
        }
    }
}

