/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Consumer;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.ui.branch.GitBranchPopup;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class GitBranchWidget
extends EditorBasedWidget
implements StatusBarWidget.MultipleTextValuesPresentation,
StatusBarWidget.Multiframe,
GitRepositoryChangeListener {
    private static final Logger LOG = Logger.getInstance(GitBranchWidget.class);
    private final GitVcsSettings mySettings;
    private volatile String myText = "";
    private volatile String myTooltip = "";
    private final String myMaxString;

    public GitBranchWidget(Project project) {
        super(project);
        project.getMessageBus().connect().subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this);
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myMaxString = "Git: Rebasing master";
        this.updateLater();
    }

    public StatusBarWidget copy() {
        return new GitBranchWidget(this.getProject());
    }

    @NotNull
    public String ID() {
        String string = GitBranchWidget.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchWidget", "ID"));
        }
        return string;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "git4idea/ui/branch/GitBranchWidget", "getPresentation"));
        }
        return this;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/ui/branch/GitBranchWidget", "selectionChanged"));
        }
        LOG.debug("selection changed");
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "git4idea/ui/branch/GitBranchWidget", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/ui/branch/GitBranchWidget", "fileOpened"));
        }
        LOG.debug("file opened");
        this.update();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "git4idea/ui/branch/GitBranchWidget", "fileClosed"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/ui/branch/GitBranchWidget", "fileClosed"));
        }
        LOG.debug("file closed");
        this.update();
    }

    @Override
    public void repositoryChanged(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/ui/branch/GitBranchWidget", "repositoryChanged"));
        }
        LOG.debug("repository changed");
        this.updateLater();
    }

    private void updateLater() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                LOG.debug("update after repository change");
                GitBranchWidget.this.update();
            }
        });
    }

    public ListPopup getPopupStep() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        GitRepository repo = GitBranchUtil.getCurrentRepository(project);
        if (repo == null) {
            return null;
        }
        this.update();
        return GitBranchPopup.getInstance(project, repo).asListPopup();
    }

    public String getSelectedValue() {
        String text = this.myText;
        return StringUtil.isEmpty((String)text) ? "" : "Git: " + text;
    }

    @Deprecated
    @NotNull
    public String getMaxValue() {
        String string = this.myMaxString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchWidget", "getMaxValue"));
        }
        return string;
    }

    public String getTooltipText() {
        return this.myTooltip;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent mouseEvent) {
                GitBranchWidget.this.update();
            }
        };
    }

    private void update() {
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            this.emptyTextAndTooltip();
            return;
        }
        GitRepository repo = GitBranchUtil.getCurrentRepository(project);
        if (repo == null) {
            this.emptyTextAndTooltip();
            return;
        }
        int maxLength = this.myMaxString.length() - 1;
        this.myText = StringUtil.shortenTextWithEllipsis((String)GitBranchUtil.getDisplayableBranchText(repo), (int)maxLength, (int)5);
        this.myTooltip = GitBranchWidget.getDisplayableBranchTooltip(repo);
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
        this.mySettings.setRecentRoot(repo.getRoot().getPath());
    }

    private void emptyTextAndTooltip() {
        this.myText = "";
        this.myTooltip = "";
    }

    @NotNull
    private static String getDisplayableBranchTooltip(GitRepository repo) {
        String text = GitBranchUtil.getDisplayableBranchText(repo);
        if (!GitUtil.justOneGitRepository(repo.getProject())) {
            String string = text + "\n" + "Root: " + repo.getRoot().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchWidget", "getDisplayableBranchTooltip"));
            }
            return string;
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchWidget", "getDisplayableBranchTooltip"));
        }
        return string;
    }
}

