/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StoragePathMacros;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.StreamProvider$;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.SingleAlarm;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ProjectId;
import org.jetbrains.settingsRepository.ReadOnlySourcesManager;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$d5f67752;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsSettings$fc6165a3;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsUrlBuilder$266bde63;
import org.jetbrains.settingsRepository.SyncManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.GitPackage$GitEx$3dc0a22d;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryService;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"i\u000e)Q\u0011jY:NC:\fw-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*\u00112/\u001a;uS:<7OU3q_NLGo\u001c:z\u0015\r\te.\u001f\u0006\u0007W>$H.\u001b8\u000b\rqJg.\u001b;?\u0015\r!\u0017N\u001d\u0006\u0005\r&dWM\u0003\u0003kCZ\f'BA5p\u0015E\tW\u000f^8D_6l\u0017\u000e^#oC\ndW\r\u001a\u0006\b\u0005>|G.Z1o\u0015=\tW\u000f^8Ts:\u001cW*\u00198bO\u0016\u0014(bD!vi>\u001c\u0016P\\2NC:\fw-\u001a:\u000b\u0017\r|W.\\5u\u00032\f'/\u001c\u0006\f'&tw\r\\3BY\u0006\u0014XNC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0005kRLGN\u0003\fsK\u0006$wJ\u001c7z'>,(oY3t\u001b\u0006t\u0017mZ3s\u0015Y\u0011V-\u00193P]2L8k\\;sG\u0016\u001cX*\u00198bO\u0016\u0014(\"G4fiJ+\u0017\rZ(oYf\u001cv.\u001e:dKNl\u0015M\\1hKJT\u0001C]3q_NLGo\u001c:z\u0003\u000e$\u0018N^3\u000b'\u001d,GOU3q_NLGo\u001c:z\u0003\u000e$\u0018N^3\u000b'M,GOU3q_NLGo\u001c:z\u0003\u000e$\u0018N^3\u000b#I,\u0007o\\:ji>\u0014\u00180T1oC\u001e,'OC\tSKB|7/\u001b;pefl\u0015M\\1hKJTAcZ3u%\u0016\u0004xn]5u_JLX*\u00198bO\u0016\u0014(\"\u0005:fa>\u001c\u0018\u000e^8ssN+'O^5dK*\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\u000b)\u001d,GOU3q_NLGo\u001c:z'\u0016\u0014h/[2f\u0015!\u0019X\r\u001e;j]\u001e\u001c(bC%dgN+G\u000f^5oONT1bZ3u'\u0016$H/\u001b8hg*Y1/\u001f8d\u001b\u0006t\u0017mZ3s\u0015-\u0019\u0016P\\2NC:\fw-\u001a:\u000b/\t,gm\u001c:f\u0003B\u0004H.[2bi&|g\u000eT8bI\u0016$'bC1qa2L7-\u0019;j_:T1\"\u00119qY&\u001c\u0017\r^5p]*9q\u000e]3oCBL'\u0002B+oSRT!dY1oG\u0016d\u0017I\u001c3ESN\f'\r\\3BkR|7i\\7nSRTQD]3hSN$XM\u001d)s_*,7\r\u001e'fm\u0016d\u0007K]8wS\u0012,'o\u001d\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRT1D];o\u0013:\fU\u000f^8D_6l\u0017\u000e\u001e#jg\u0006\u0014G.\u001a3N_\u0012,'\u0002\u0002;bg.T\u0011BR;oGRLwN\u001c\u0019\u000b\u0007)4XNC\u0005gk:\u001cG/[8og*q1o\u00195fIVdWmQ8n[&$(\u0002B:z]\u000eT\u0001b]=oGRK\b/\u001a\u0006\t'ft7\rV=qK*QBn\\2bYJ+\u0007o\\:ji>\u0014\u00180\u00138ji&\fG.\u001b>fe*aQ\u000b\u001d3bi\u0016\u0014Vm];mi*A\u0012\t\u001d9mS\u000e\fG/[8o\u0019\u00164X\r\u001c)s_ZLG-\u001a:\u000b#%\u001b7o\u0015;sK\u0006l\u0007K]8wS\u0012,'O\u0003\u000bQe>TWm\u0019;MKZ,G\u000e\u0015:pm&$WM\u001dR\u0003\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQa\u0001\u0003\u0002\u0011\u0001a\u0001!B\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0003\u0019\u0001)\u0011\u0001#\u0003\u0006\u0005\u0011\u0019\u0001\"B\u0003\u0004\t\u000fAA\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0002B\u0003\u0004\t\tAa\u0001\u0004\u0001\u0006\u0007\u0011\t\u0001b\u0002\u0007\u0001\u000b\t!\u0011\u0001C\u0004\u0006\u0003!EQA\u0001C\u0007\u0011%)!\u0001B\u0004\t\u0014\u0015\u0019Aq\u0002\u0005\t\u0019\u0001)!\u0001b\u0004\t\u0011\u0015\u0019A!\u0001E\u000b\u0019\u0001)!\u0001B\u0001\t\u0016\u0015\u0019A!\u0001E\u000e\u0019\u0001)!\u0001B\u0001\t\u001c\u0015\u0019A!\u0001\u0005\u0010\u0019\u0001)!\u0001B\u0001\t\u001f\u0015\u0019A!\u0001E\u0011\u0019\u0001)!\u0001B\u0001\t\"\u0015\u0019A!\u0001\u0005\u0013\u0019\u0001)!\u0001B\u0001\t%\u0015\u0011Aa\u0002\u0005\u0015\u000b\t!a\u0002C\n\u0006\u0007\u0011u\u0001r\u0005\u0007\u0001\u000b\r!!\u0001#\u000b\r\u0001\u0015\u0011AQ\u0004E\u0014\u000b\t!a\u0002\u0003\f\u0006\u0007\u0011\u0005\u0002R\u0006\u0007\u0001\u000b\t!\t\u0003#\f\u0006\u0007\u0011\u0011\u0001\u0002\u0007\u0007\u0001\u000b\t!!\u0001#\r\u0006\u0005\u0011\u0015\u0002\"G\u0003\u0003\tMA\u0001$B\u0002\u0005\u0003!YB\u0002A\u0003\u0004\t\u0005AA\u0004\u0004\u0001\u0006\u0005\u0011\t\u0001\u0002H\u0003\u0003\t\u0005A1\u0004\u0002\u0001\r\u0004e\u0011Q!\u0001E\u00039saR\u0004h\u000f.\u001b\u0011\rM\u0002g\u0003\"\u0005\u0015\t\u0001\"\u0002\u0013\u0002Q\u0005)6\u0001B\u0003\u0004\t\u0017I\u0011\u0001\"\u0001.\u0017\u0011\tG\u0001'\u0004\"\u0005\u0015\t\u00012B+\u0004\t\u0015\u0019AQB\u0005\u0002\u0011\u0019i3\u0002B1\u00051\u001f\t#!B\u0001\t\u0011U\u001bA!B\u0002\u0005\u0010%\t\u0001\u0012C\u0017\u0010\t\u0001$\u0001DC\u0011\u0003\u000b\u0005A\u0011\"V\u0002\t\u000b\r!!\"C\u0001\t\u00145\u0019AaC\u0005\u0002\u0011'is\u0003\"a\r1/\t#!B\u0001\t\u000b\u0011\u0002\u0001\u0006A+\u0004\u001d\u0015\u0019AqC\u0005\u0002\t\u0003i1\u0001\u0002\u0007\n\u0003\u0011\u0005\u0011#\u0002C\r\u0013\u0005!\u0001!D\u0001\u0005\u00025zA\u0001\u0019\u0003\u0019\u001b\u0005\u0012Q!\u0001\u0005\u000b+\u000eAQa\u0001\u0003\u000e\u0013\u0005A)\"D\u0002\u0005\u001d%\t\u0001RC\u0017\u0010\t\u0001$\u0001TD\u0011\u0003\u000b\u0005A1\"V\u0002\t\u000b\r!i\"C\u0001\t\u00185\u0019AqD\u0005\u0002\u0011/is\u0002\u00021\u00051A\t#!B\u0001\t\u0019U\u001b\u0001\"B\u0002\u0005!%\t\u0001\u0012D\u0007\u0004\tEI\u0011\u0001#\u0007.\u0017\u0011\tG\u0001g\t\"\u0005\u0015\t\u0001\"D+\u0004\t\u0015\u0019A1E\u0005\u0002\u00117i3\u0003\u0002\u0001\u0019&u5A\u0001\u0001\u0005\u0014\u001b\t)\u0011\u0001C\bQ\u0007\u0001\t#!B\u0001\t E\u001bQ\u0001\"\n\n\u0003\u0011\u0001Q\"\u0001\u0005\u0011['!\u0011\u0001G\u000b\"\u0005\u0015\t\u0001rD)\u0004\u0007\u0011)\u0012\"\u0001\u0003\u0001[M!\u0011\u0001g\u000b\u001e\u000e\u0011\u0001\u0001BF\u0007\u0003\u000b\u0005A\u0011\u0003U\u0002\u0001C\t)\u0011\u0001c\bR\u0007\u0015!Y#C\u0001\u0005\u00015\t\u00012E\u0017\u0018\t\u0001Ar#(\u0006\u0005\u0001!=RBB\u0003\u0002\u0011II1!\u0003\u0002\u0006\u0003!}\u0001k\u0001\u0001\"\u0005\u0015\t\u0001rD)\u0004\u000b\u00119\u0012\"\u0001\u0003\u0001\u001b\u0005A9#l\u0005\u0005\u0003aM\u0012EA\u0003\u0002\u0011?\t6a\u0001C\u001a\u0013\u0005!\u0001!L\u0017\u0005\u0001aQRT\u0002\u0003\u0001\u0011ki!!B\u0001\t)A\u001b\u0001!h\u0004\u0005\u0001!1RbA\u0003\u0002\u0011Ea\t\u0001UB\u0001;/!\u0011\u0001c\u000e\u000e\u000f\u0015\t\u0001BE\u0005\u0004\u0013\t)\u0011\u0001c\b\r\u0002A\u001b\u0011!I\u0002\u0006\u0003!%B\u0012A)\u0004\u0013\u0011Q\u0012\"\u0001\u0005\u0016\u001b\u0005AY#D\u0001\t$5\t\u0001rE[\u0015\u000bO!1\u001d\u0001\r\u0004;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u0001\u0002\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\u0002#\u000e)AaA\u0005\u0002\t\u0001i\u0011\u0001#\u0003"})
public final class IcsManager {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final IcsSettings settings;
    @NotNull
    private final RepositoryManager repositoryManager;
    @NotNull
    private final ReadOnlySourcesManager readOnlySourcesManager;
    @NotNull
    private final RepositoryService repositoryService;
    private final SingleAlarm commitAlarm;
    private volatile boolean autoCommitEnabled;
    private volatile boolean repositoryActive;
    private final AutoSyncManager autoSyncManager;
    private final SyncManager syncManager;

    static {
        $kotlinClass = Reflection.createKotlinClass(IcsManager.class);
    }

    @NotNull
    public final IcsSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @NotNull
    public final ReadOnlySourcesManager getReadOnlySourcesManager() {
        return this.readOnlySourcesManager;
    }

    @NotNull
    public final RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public final boolean getRepositoryActive() {
        return this.repositoryActive;
    }

    public final void setRepositoryActive(@JetValueParameter(name="<set-?>") boolean bl) {
        this.repositoryActive = bl;
    }

    private final void scheduleCommit() {
        if (this.autoCommitEnabled) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (!application.isUnitTestMode()) {
                this.commitAlarm.cancelAndRequest();
            }
        }
    }

    private final void registerProjectLevelProviders(@JetValueParameter(name="project") Project project) {
        ProjectId projectId;
        Project project2 = project;
        if (project2 == null) {
            throw new TypeCastException("com.intellij.openapi.project.Project cannot be cast to com.intellij.openapi.project.ex.ProjectEx");
        }
        StateStorageManager storageManager = ((ProjectEx)project2).getStateStore().getStateStorageManager();
        StateStorage stateStorage = storageManager.getStateStorage(StoragePathMacros.WORKSPACE_FILE, RoamingType.DISABLED);
        if (stateStorage == null) {
            Intrinsics.throwNpe();
        }
        if ((projectId = (ProjectId)stateStorage.getState((Object)new ProjectId(), "IcsProjectId", ProjectId.class, null)) == null || projectId.getUid() == null) {
            return;
        }
        String string = projectId.getUid();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        storageManager.setStreamProvider((StreamProvider)new ProjectLevelProvider(string));
    }

    @Nullable
    public final UpdateResult sync(@JetValueParameter(name="syncType") @NotNull SyncType syncType, @JetValueParameter(name="project", type="?") @Nullable Project project, @JetValueParameter(name="localRepositoryInitializer", type="?") @Nullable Function0<? extends Unit> localRepositoryInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)syncType), (String)"syncType");
        return this.syncManager.sync(syncType, project, localRepositoryInitializer);
    }

    @Nullable
    public static /* synthetic */ UpdateResult sync$default(IcsManager icsManager2, SyncType syncType, Project project, Function0 function0, int n) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        return icsManager2.sync(syncType, project, (Function0<? extends Unit>)function0);
    }

    private final void cancelAndDisableAutoCommit() {
        if (this.autoCommitEnabled) {
            this.autoCommitEnabled = false;
            this.commitAlarm.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runInAutoCommitDisabledMode(@JetValueParameter(name="task") @NotNull Function0<? extends Unit> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        this.cancelAndDisableAutoCommit();
        try {
            task.invoke();
        }
        finally {
            this.autoCommitEnabled = true;
            this.repositoryActive = this.repositoryManager.isRepositoryExists();
        }
    }

    public final void beforeApplicationLoaded(@JetValueParameter(name="application") @NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.repositoryActive = this.repositoryManager.isRepositoryExists();
        ComponentsPackage.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager().setStreamProvider((StreamProvider)new ApplicationLevelProvider());
        this.autoSyncManager.registerListeners(application);
        application.getMessageBus().connect().subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ IcsManager this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(beforeApplicationLoaded.1.class);
            }

            public void beforeProjectLoaded(@JetValueParameter(name="project") @NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (project.isDefault()) {
                    return;
                }
                IcsManager.access$registerProjectLevelProviders$3(this.this$0, project);
                IcsManager.access$getAutoSyncManager$2(this.this$0).registerListeners(project);
            }

            public void afterProjectClosed(@JetValueParameter(name="project") @NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                AutoSyncManager.autoSync$default(IcsManager.access$getAutoSyncManager$2(this.this$0), false, 1);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public IcsManager(@JetValueParameter(name="dir") @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.repositoryManager = new GitRepositoryManager((NotNullLazyValue<CredentialsStore>)((NotNullLazyValue)SettingsRepositoryPackage$IcsManager$d5f67752.getCredentialsStore()), new File(dir, "repository"));
        try {
            this.settings = SettingsRepositoryPackage$IcsSettings$fc6165a3.loadSettings();
        }
        catch (Exception e) {
            this.settings = new IcsSettings();
            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().error((Throwable)e);
        }
        this.readOnlySourcesManager = new ReadOnlySourcesManager(this.settings, dir);
        this.repositoryService = new GitRepositoryService();
        this.commitAlarm = new SingleAlarm(new Runnable(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ IcsManager this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(commitAlarm.1.class);
            }

            public void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, null, IcsBundle.Companion.message("task.commit.title", new Object[0])){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ commitAlarm.1 this$0;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(commitAlarm.run.1.class);
                    }

                    public void run(@JetValueParameter(name="indicator") @NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        try {
                            this.this$0.this$0.getRepositoryManager().commit(indicator);
                        }
                        catch (Throwable e) {
                            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().error(e);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2);
                    }
                });
            }
            {
                this.this$0 = $outer;
            }
        }, this.settings.getCommitDelay());
        this.autoCommitEnabled = true;
        this.autoSyncManager = new AutoSyncManager(this);
        this.syncManager = new SyncManager(this, this.autoSyncManager);
    }

    @NotNull
    public static final /* synthetic */ AutoSyncManager access$getAutoSyncManager$2(@JetValueParameter(name="$this", type="?") IcsManager $this) {
        return $this.autoSyncManager;
    }

    public static final /* synthetic */ void access$registerProjectLevelProviders$3(@JetValueParameter(name="$this", type="?") IcsManager $this, @JetValueParameter(name="project") @NotNull Project project) {
        $this.registerProjectLevelProviders(project);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"X\u0004)A\u0012\t\u001d9mS\u000e\fG/[8o\u0019\u00164X\r\u001c)s_ZLG-\u001a:\u000b\u0015%\u001b7/T1oC\u001e,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\u0012\u0013\u000e\u001c8\u000b\u001e:fC6\u0004&o\u001c<jI\u0016\u0014(B\u0002\u001fj]&$hH\u0003\u0004eK2,G/\u001a\u0006\tM&dWm\u00159fG*11\u000b\u001e:j]\u001eTaa[8uY&t'b\u0003:pC6Lgn\u001a+za\u0016T1BU8b[&tw\rV=qK*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0006d_6\u0004xN\\3oiNTA!\u00168ji*!!.\u0019<b\u0015\u0011a\u0017M\\4w\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011Qa\u0001\u0003\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0004\t\u0007A)\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0012A\u0003\u0002\u0011\u0015)1\u0001b\u0002\t\n1\u0001Q!\u0001E\u0007\u000b\t!I\u0001C\u0004\u0006\u0005\u0011)\u0001rB\u0003\u0003\t\u0017A\u0001\"B\u0002\u0005\r!1A\u0002A\u0003\u0004\t\u000fA\t\u0002\u0004\u0001\u0006\u0003!IQA\u0001C\b\u0011')!\u0001\u0002\u0005\t\n\u0015\u0011AA\u0002\u0005\u0007\t\u0001\u0013ABA\r\u0003\u000b\u0005A)!,\u000f\u0005\u0017a\u001dQT\u0002\u0003\u0001\u0011\u0011i!!B\u0001\t\tA\u001b\u0001!(\u0004\u0005\u0001!-QBA\u0003\u0002\u0011\u001b\u00016\u0011A\u0011\u0003\u000b\u0005Aq!U\u0002\b\t\u000fI\u0011\u0001\u0002\u0001\u000e\u0003!EQ\"\u0001\u0005\nk5)A\u0002Br\u00011\r\t#!B\u0001\t\u0005E\u001bQ\u0001B\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0004"})
    public final class ApplicationLevelProvider
    extends IcsStreamProvider {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(ApplicationLevelProvider.class);
        }

        @Override
        public void delete(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.syncManager.getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Delete is prohibited now");
            }
            IcsManager.this.getRepositoryManager().delete(SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath$default(fileSpec, roamingType, null, 4));
            IcsManager.this.scheduleCommit();
        }

        public ApplicationLevelProvider() {
            super(null);
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"v\u0004)!\u0002K]8kK\u000e$H*\u001a<fYB\u0013xN^5eKJT!\"S2t\u001b\u0006t\u0017mZ3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT!c]3ui&twm\u001d*fa>\u001c\u0018\u000e^8ss*\t\u0012jY:TiJ,\u0017-\u001c)s_ZLG-\u001a:\u000b\rqJg.\u001b;?\u0015%\u0001(o\u001c6fGRLEM\u0003\u0004TiJLgn\u001a\u0006\u0007W>$H.\u001b8\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0007jg\u0006\u0003\b\u000f\\5dC\ndWM\u0003\u0005gS2,7\u000b]3d\u0015-\u0011x.Y7j]\u001e$\u0016\u0010]3\u000b\u0017I{\u0017-\\5oORK\b/\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*Q1m\\7q_:,g\u000e^:\u000b\u000f\t{w\u000e\\3b]*a\u0011n]!vi>\u001cu.\\7jiZT!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0004\t\u0005A\t\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\r!\u0019\u0001#\u0002\r\u0001\u0015\t\u0001\u0012B\u0003\u0004\t\rAA\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0012A\u0003\u0002\u0011\u0015)!\u0001\"\u0003\t\f\u0015\u0011A!\u0002\u0005\u0005\u000b\u0005A\u0001\"\u0002\u0002\u0005\r!EQA\u0001C\u0007\u0011%)!\u0001B\u0004\t\u0014\u0015\u0019Aq\u0002E\b\u0019\u0001)1\u0001B\u0002\t\u00151\u0001QA\u0001C\b\u0011\u001f!\u0011I\u0001\u0007\u00033\t)\u0011\u0001#\u0002.:\u0011Y\u0001DBO\u0007\t\u0001Ai!\u0004\u0002\u0006\u0003!\u001d\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001bB\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001C\t)\u0011\u0001#\u0005R\u0007\u001d!a!C\u0001\u0005\u00025\t\u00012B\u0007\u0002\u0011%iK\u0004\u0002\u0006\u0019\u0016u5A\u0001\u0001E\u0007\u001b\t)\u0011\u0001c\u0002Q\u0007\u0001ij\u0001\u0002\u0001\t\u000f5\u0011Q!\u0001\u0005\t!\u000e\u0005\u0011EA\u0003\u0002\u0011#\t6a\u0002C\u000b\u0013\u0005!\t!D\u0001\t\f5\t\u0001\"C[\u0017\u000bW!1\u001d\u0001\r\u0004;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u0001r\u0001)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u0003#\u000e9AaA\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0003\u000e\u0003!-\u0001"})
    private final class ProjectLevelProvider
    extends IcsStreamProvider {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(ProjectLevelProvider.class);
        }

        @Override
        protected boolean isAutoCommit(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return !StorageUtil.isProjectOrModuleFile((String)fileSpec);
        }

        @Override
        public boolean isApplicable(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (StorageUtil.isProjectOrModuleFile((String)fileSpec)) {
                return IcsManager.this.getRepositoryManager().has(SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath(fileSpec, roamingType, ((IcsStreamProvider)this).getProjectId()));
            }
            return IcsManager.this.getSettings().getShareProjectWorkspace() || Intrinsics.areEqual((Object)fileSpec, (Object)StoragePathMacros.WORKSPACE_FILE) ^ true;
        }

        public ProjectLevelProvider(String projectId) {
            Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
            super(projectId);
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"v\b)\t\u0012jY:TiJ,\u0017-\u001c)s_ZLG-\u001a:\u000b\u0015%\u001b7/T1oC\u001e,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\u000f'R\u0014X-Y7Qe>4\u0018\u000eZ3s\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'BC2p[B|g.\u001a8ug*!\u0011.\u001c9m\u0015\u0019\u0019Ho\u001c:fg*1A(\u001b8jizR\u0011\u0002\u001d:pU\u0016\u001cG/\u00133\u000b\rM#(/\u001b8h\u0015\u0019Yw\u000e\u001e7j]*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\u000f\u0015t\u0017M\u00197fI*9!i\\8mK\u0006t'BC4fi\u0016s\u0017M\u00197fI*aq-\u001a;Qe>TWm\u0019;JI*1A-\u001a7fi\u0016T\u0001BZ5mKN\u0003Xm\u0019\u0006\fe>\fW.\u001b8h)f\u0004XMC\u0006S_\u0006l\u0017N\\4UsB,'\u0002B+oSRTa\u0001Z8TCZ,'bB2p]R,g\u000e\u001e\u0006\n\u0005f$X-\u0011:sCfTAa]5{K*\u0019\u0011J\u001c;\u000b\u0019%\u001c\u0018)\u001e;p\u0007>lW.\u001b;\u000b\u00191L7\u000f^*vE\u001aKG.Z:\u000b#5+H/\u00192mK\u000e{G\u000e\\3di&|gN\u0003\u0003vi&d'BC\"pY2,7\r^5p]*YAn\\1e\u0007>tG/\u001a8u\u0015-Ie\u000e];u'R\u0014X-Y7\u000b\u0005%|'b\u00049s_\u000e,7o]\"iS2$'/\u001a8\u000b\tA\fG\u000f\u001b\u0006\u0007M&dG/\u001a:\u000b\u0013\u0019+hn\u0019;j_:\f$\"\u00039s_\u000e,7o]8s\u0015%1UO\\2uS>t7GC\u0002km6T\u0011BZ;oGRLwN\\:\u000b\u0017M\fg/Z\"p]R,g\u000e\u001ev\u0002\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011Qa\u0001\u0003\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0002\u0011\r)!\u0001\"\u0002\t\b\u0015\u0011Aa\u0001\u0005\u0005\u000b\t!9\u0001#\u0003\u0006\u0005\u0011!\u0001\"B\u0003\u0003\t\u0013AY!B\u0002\u0005\u000b!\u0015A\u0002A\u0003\u0002\u0011\u001f)1\u0001\u0002\u0004\t\u000f1\u0001QA\u0001\u0003\u0002\u0011\u0003)\u0011\u0001\u0003\u0005\u0006\u0005\u0011=\u0001\u0012C\u0003\u0003\t!Aq!B\u0002\u0005\r!MA\u0002A\u0003\u0004\t\u0011AI\u0002\u0004\u0001\u0006\u0007\u00111\u0001\"\u0004\u0007\u0001\u000b\t!A\u0001#\u0007\u0006\u0007\u00111\u0001R\u0004\u0007\u0001\u000b\r!a\u0001c\b\r\u0001\u0015\u0019AA\u0002\u0005\u0012\u0019\u0001)!\u0001b\u0004\t$\u0015\u0011A\u0011\u0004\u0005\u0013\u000b\t!y\u0001c\n\u0006\u0007\u0011m\u0001b\u0005\u0007\u0001\u000b\t!Y\u0002C\n\u0006\u0007\u00111\u00012\u0006\u0007\u0001\u000b\r!a\u0001#\f\r\u0001\u0015\u0011AA\u0002\u0005\u0018\u000b\t!\u0001\u0003c\f\u0006\u0005\u0011\u0005\u00022F\u0003\u0003\tCAi\u0003\u0002%\u0003\u0019\tI\"!B\u0001\t\f5bAa\u001b\u0003\u0019\u0013\u0005\u0012Q!\u0001\u0005\nI-*6\u0001B\u0007\u0004\t)I\u0011\u0001\"\u0001.!\u0011\u0011G\u0001'\u0004\"\u0007\u0015\t\u0001R\u0002G\u0001+\u000eAQa\u0001C\u0007\u0013\u0005A\t\"D\u0002\u0005\u0016%\t\u0001\u0012CW\u001d\t-A2\"(\u0004\u0005\u0001!]QBA\u0003\u0002\u0011\u001b\u00016\u0001AO\u0007\t\u0001AA\"\u0004\u0002\u0006\u0003!M\u0001k!\u0001\"\u0005\u0015\t\u0001BC)\u0004\u000f\u0011Y\u0011\"\u0001\u0003\u0001\u001b\u0005A\t\"D\u0001\t\u00165\u0006D\u0001\u0001M\u000e;\u001b!\u0001\u0001c\u0006\u000e\u0005\u0015\t\u0001R\u0002)\u0004\u0001u5A\u0001\u0001\u0005\u000f\u001b\t)\u0011\u0001C\u0006Q\u0007\u0003ij\u0001\u0002\u0001\t\u001f5\u0011Q!\u0001E\f!\u000e\tQT\u0002\u0003\u0001\u00111i!!B\u0001\t\u0014A\u001b\u0019!\t\u0002\u0006\u0003!Q\u0011k\u0001\u0007\u0005\u001c%\tA\u0001A\u0007\u0002\u0011#i!\u0001b\u0001\r\u00025\tAQA\u0007\u0002\u0011+iK\u0004\u0002\u0006\u0019!u5A\u0001\u0001E\f\u001b\t)\u0011\u0001#\u0004Q\u0007\u0001ij\u0001\u0002\u0001\t\u00195\u0011Q!\u0001E\n!\u000e\u0005\u0011EA\u0003\u0002\u0011%\t6a\u0002\u0003\u0011\u0013\u0005!\t!D\u0001\t\u00125\t\u0001RCW!\t-A\n#(\u0004\u0005\u0001!]QBA\u0003\u0002\u0011\u001b\u00016\u0001AO\u0007\t\u0001AA\"\u0004\u0002\u0006\u0003!M\u0001k!\u0001\"\r\u0015\t\u0001\u0002D\u0005\u0004\u0013\t)\u0011\u0001#\u0004R\u0007\u001d!\t#C\u0001\t\u001b5\t\u0001\u0012C\u0007\u0002\u0011+i[\u0004B\u0006\u0019&u5A\u0001\u0001E\f\u001b\t)\u0011\u0001#\u0004Q\u0007\u0001ij\u0001\u0002\u0001\t\u00195\u0011Q!\u0001E\n!\u000e\u0005\u0011eA\u0003\u0002\u00119a\t!U\u0002\b\tKI\u0011\u0001#\b\u000e\u0003!EQ\"\u0001E\u000b[\u001f\u0007Aa\u0003\r\u0015;\u001b!\u0001\u0001#\u000b\u000e\u0005\u0015\t\u0001R\u0002)\u0004\u0001u5A\u0001\u0001\u0005\r\u001b\t)\u0011\u0001c\u0005Q\u0007\u0003ij\u0002\u0002\u0001\t+5QQ!\u0001\u0005\u0010\u0013\rI!!B\u0001\t\u000e%\u0019\u0011BA\u0003\u0002\u0011%\u00016!AO\u0017\t\u0001Aa#\u0004\n\u0006\u0003!}\u0011bA\u0005\u0003\u000b\u0005Ai!C\u0002\n\u0005\u0015\t\u0001BD\u0005\u0004\u0013\t)\u0011\u0001C\u0005\n\u0007%\u0011Q!\u0001\u0005\n!\u000e\r\u0011EA\u0003\u0002\u0011)\t6a\u0003\u0003\u0015\u0013\u0005!\u0001!D\u0001\t\u00125\t\u0001RC\u0007\u0002\u0011Ei\u0011\u0001c\t.b\u0011Y\u0001\u0004GO\u0007\t\u0001A9\"\u0004\u0002\u0006\u0003!5\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BD\u0007\u0003\u000b\u0005A1\u0002UB\u0001;\u001b!\u0001\u0001C\b\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0003u5A\u0001\u0001\u0005\r\u001b\t)\u0011\u0001c\u0005Q\u0007\u0007\t#!B\u0001\t\u0015E\u001bA\u0002\u0002\r\n\u0003\u0011\u0001Q\"\u0001E\t\u001b\t!\u0019\u0001$\u0001\u000e\u0003\u0011\u0015Q\"\u0001E\u000bk_)i\u0003Br\u00011\u0019iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001E\u0007\u0019\u0003\u00016\u0011A\u0011\u0003\u000b\u0005A!!U\u0002\b\t\u0019I\u0011\u0001\u0002\u0001\u000e\u0003!9Q\"\u0001E\t"})
    public class IcsStreamProvider
    implements StreamProvider {
        public static final /* synthetic */ KClass $kotlinClass;
        @Nullable
        private final String projectId;

        static {
            $kotlinClass = Reflection.createKotlinClass(IcsStreamProvider.class);
        }

        public boolean getEnabled() {
            return IcsManager.this.getRepositoryActive();
        }

        @NotNull
        public Collection<String> listSubFiles(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            Collection<String> collection = IcsManager.this.getRepositoryManager().listSubFileNames(SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath(fileSpec, roamingType, null));
            if (collection == null) {
                throw new TypeCastException("kotlin.Collection<kotlin.String> cannot be cast to kotlin.MutableCollection<kotlin.String>");
            }
            return collection;
        }

        public void processChildren(@JetValueParameter(name="path") @NotNull String path, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType, @JetValueParameter(name="filter") @NotNull Function1<? super String, ? extends Boolean> filter, @JetValueParameter(name="processor") @NotNull Function3<? super String, ? super InputStream, ? super Boolean, ? extends Boolean> processor) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
            String fullPath = SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath(path, roamingType, null);
            for (Repository repository : IcsManager.this.getReadOnlySourcesManager().getRepositories()) {
                GitPackage$GitEx$3dc0a22d.processChildren(repository, fullPath, filter, (Function2<? super String, ? super InputStream, ? extends Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                    final /* synthetic */ Function3 $processor;

                    public final boolean invoke(@JetValueParameter(name="name") @NotNull String name, @JetValueParameter(name="input") @NotNull InputStream input) {
                        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                        return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)true);
                    }
                    {
                        this.$processor = function3;
                        super(2);
                    }
                }));
            }
            IcsManager.this.getRepositoryManager().processChildren(fullPath, filter, (Function2<? super String, ? super InputStream, ? extends Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                final /* synthetic */ Function3 $processor;

                public final boolean invoke(@JetValueParameter(name="name") @NotNull String name, @JetValueParameter(name="input") @NotNull InputStream input) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)false);
                }
                {
                    this.$processor = function3;
                    super(2);
                }
            }));
        }

        public void saveContent(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="content") @NotNull byte[] content, @JetValueParameter(name="size") int size, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.syncManager.getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Save is prohibited now");
            }
            this.doSave(fileSpec, content, size, roamingType);
            if (this.isAutoCommit(fileSpec, roamingType)) {
                IcsManager.this.scheduleCommit();
            }
        }

        public final void doSave(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="content") @NotNull byte[] content, @JetValueParameter(name="size") int size, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            IcsManager.this.getRepositoryManager().write(SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath(fileSpec, roamingType, this.projectId), content, size);
        }

        protected boolean isAutoCommit(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return true;
        }

        @Nullable
        public InputStream loadContent(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return IcsManager.this.getRepositoryManager().read(SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath(fileSpec, roamingType, this.projectId));
        }

        public void delete(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        }

        @Nullable
        protected final String getProjectId() {
            return this.projectId;
        }

        public IcsStreamProvider(String projectId) {
            this.projectId = projectId;
        }

        public boolean isApplicable(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return StreamProvider$.TImpl.isApplicable((StreamProvider)this, (String)fileSpec, (RoamingType)roamingType);
        }
    }
}

