/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.table.TableModelEditor;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.Configurable;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.ReadOnlySourcesManager;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$d5f67752;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$readOnlySourcesEditor$2ef65bfc;
import org.jetbrains.settingsRepository.git.GitPackage$GitEx$3dc0a22d;
import org.jetbrains.settingsRepository.git.GitPackage$JGitProgressMonitor$1fce68cd;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class SettingsRepositoryPackage$readOnlySourcesEditor$2ef65bfc {
    @NotNull
    static final TableModelEditor.EditableColumnInfo<ReadonlySource, ? extends Comparable<? extends Object>>[] COLUMNS = new TableModelEditor.EditableColumnInfo[]{(TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, Boolean>(){
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(COLUMNS.1.class);
        }

        @NotNull
        public Class<Boolean> getColumnClass() {
            return Boolean.TYPE;
        }

        @NotNull
        public Boolean valueOf(@JetValueParameter(name="item") @NotNull ReadonlySource item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getActive();
        }

        public void setValue(@JetValueParameter(name="item") @NotNull ReadonlySource item, @JetValueParameter(name="value") boolean value) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            item.setActive(value);
        }
    }, (TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, String>(){
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(COLUMNS.2.class);
        }

        @Nullable
        public String valueOf(@JetValueParameter(name="item") @NotNull ReadonlySource item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getUrl();
        }

        public void setValue(@JetValueParameter(name="item") @NotNull ReadonlySource item, @JetValueParameter(name="value") @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            item.setUrl(value);
        }
    }};

    @NotNull
    public static final TableModelEditor.EditableColumnInfo<ReadonlySource, ? extends Comparable<? extends Object>>[] getCOLUMNS() {
        return COLUMNS;
    }

    @NotNull
    public static final Configurable createReadOnlySourcesEditor(@JetValueParameter(name="dialogParent") @NotNull Component dialogParent, @JetValueParameter(name="project", type="?") @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)dialogParent, (String)"dialogParent");
        TableModelEditor.DialogItemEditor<ReadonlySource> itemEditor2 = new TableModelEditor.DialogItemEditor<ReadonlySource>(dialogParent){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ Component $dialogParent;

            static {
                $kotlinClass = Reflection.createKotlinClass(createReadOnlySourcesEditor.itemEditor.1.class);
            }

            @NotNull
            public ReadonlySource clone(@JetValueParameter(name="item") @NotNull ReadonlySource item, @JetValueParameter(name="forInPlaceEditing") boolean forInPlaceEditing) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return new ReadonlySource(item.getUrl(), item.getActive());
            }

            @NotNull
            public Class<ReadonlySource> getItemClass() {
                return ReadonlySource.class;
            }

            public void edit(@JetValueParameter(name="item") @NotNull ReadonlySource item, @JetValueParameter(name="mutator") @NotNull Function<ReadonlySource, ReadonlySource> mutator, @JetValueParameter(name="isAdd") boolean isAdd) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Intrinsics.checkParameterIsNotNull(mutator, (String)"mutator");
                DialogBuilder dialogBuilder = new DialogBuilder(this.$dialogParent);
                TextFieldWithBrowseButton urlField = new TextFieldWithBrowseButton(new JTextField(20));
                urlField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor()));
                urlField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(urlField, dialogBuilder){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ TextFieldWithBrowseButton $urlField;
                    final /* synthetic */ DialogBuilder $dialogBuilder;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(createReadOnlySourcesEditor.itemEditor.edit.1.class);
                    }

                    protected void textChanged(@JetValueParameter(name="event") @NotNull DocumentEvent event) {
                        boolean enabled;
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        String url = StringUtil.nullize((String)this.$urlField.getText());
                        try {
                            enabled = url != null && url.length() > 1 && SettingsRepositoryPackage$IcsManager$d5f67752.getIcsManager().getRepositoryService().checkUrl(url, null);
                        }
                        catch (Exception e) {
                            enabled = false;
                        }
                        this.$dialogBuilder.setOkActionEnabled(enabled);
                    }
                    {
                        this.$urlField = $captured_local_variable$0;
                        this.$dialogBuilder = $captured_local_variable$1;
                    }
                });
                dialogBuilder.title("Add read-only source").resizable(false).centerPanel((JComponent)FormBuilder.createFormBuilder().addLabeledComponent("URL:", (JComponent)urlField).getPanel()).setPreferredFocusComponent((JComponent)urlField);
                if (dialogBuilder.showAndGet()) {
                    ((ReadonlySource)mutator.fun((Object)item)).setUrl(urlField.getText());
                }
            }

            public void applyEdited(@JetValueParameter(name="oldItem") @NotNull ReadonlySource oldItem, @JetValueParameter(name="newItem") @NotNull ReadonlySource newItem) {
                Intrinsics.checkParameterIsNotNull((Object)oldItem, (String)"oldItem");
                Intrinsics.checkParameterIsNotNull((Object)newItem, (String)"newItem");
                newItem.setUrl(oldItem.getUrl());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
            {
                this.$dialogParent = $captured_local_variable$0;
            }
        };
        TableModelEditor editor = new TableModelEditor((ColumnInfo[])COLUMNS, (CollectionItemEditor)itemEditor2, "No sources configured");
        editor.reset(SettingsRepositoryPackage$IcsManager$d5f67752.getIcsManager().getSettings().getReadOnlySources());
        return new Configurable(editor, project){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ TableModelEditor $editor;
            final /* synthetic */ Project $project;

            static {
                $kotlinClass = Reflection.createKotlinClass(createReadOnlySourcesEditor.1.class);
            }

            public boolean isModified() {
                return this.$editor.isModified();
            }

            public void apply() {
                List<ReadonlySource> oldList = SettingsRepositoryPackage$IcsManager$d5f67752.getIcsManager().getSettings().getReadOnlySources();
                THashSet toDelete = new THashSet(oldList.size());
                for (ReadonlySource oldSource : oldList) {
                    ContainerUtil.addIfNotNull((Collection)((Collection)toDelete), (Object)oldSource.getPath());
                }
                THashSet toCheckout = new THashSet();
                List newList = this.$editor.apply();
                for (ReadonlySource newSource : newList) {
                    String path = newSource.getPath();
                    if (path == null || toDelete.remove((Object)path)) continue;
                    toCheckout.add((Object)newSource);
                }
                if (toDelete.isEmpty() && toCheckout.isEmpty()) {
                    return;
                }
                ProgressManager.getInstance().run((Task)new Task.Modal(toDelete, toCheckout, newList, this.$project, IcsBundle.Companion.message("task.sync.title", new Object[0]), true){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ THashSet $toDelete;
                    final /* synthetic */ THashSet $toCheckout;
                    final /* synthetic */ List $newList;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(createReadOnlySourcesEditor.apply.1.class);
                    }

                    public void run(@JetValueParameter(name="indicator") @NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        indicator.setIndeterminate(true);
                        File root = SettingsRepositoryPackage$IcsManager$d5f67752.getIcsManager().getReadOnlySourcesManager().getRootDir();
                        if (KotlinPackage.isNotEmpty((Collection)((Collection)this.$toDelete))) {
                            indicator.setText("Deleting old repositories");
                            for (String path : this.$toDelete) {
                                indicator.checkCanceled();
                                try {
                                    indicator.setText2(path);
                                    FileUtil.delete((File)new File(root, path));
                                }
                                catch (Exception e) {
                                    SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().error((Throwable)e);
                                }
                            }
                        }
                        if (KotlinPackage.isNotEmpty((Collection)((Collection)this.$toCheckout))) {
                            for (ReadonlySource source : this.$toCheckout) {
                                indicator.checkCanceled();
                                try {
                                    StringBuilder stringBuilder = new StringBuilder().append("Cloning ");
                                    String string = source.getUrl();
                                    if (string == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    indicator.setText(stringBuilder.append(StringUtil.trimMiddle((String)string, (int)255)).toString());
                                    String string2 = source.getUrl();
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    String string3 = source.getPath();
                                    if (string3 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    File file = new File(root, string3);
                                    NotNullLazyValue notNullLazyValue = (NotNullLazyValue)SettingsRepositoryPackage$IcsManager$d5f67752.getCredentialsStore();
                                    ProgressMonitor progressMonitor = GitPackage$JGitProgressMonitor$1fce68cd.asProgressMonitor(indicator);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)progressMonitor, (String)"indicator.asProgressMonitor()");
                                    GitPackage$GitEx$3dc0a22d.cloneBare(string2, file, (NotNullLazyValue<CredentialsStore>)notNullLazyValue, progressMonitor).close();
                                }
                                catch (Exception e) {
                                    SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().error((Throwable)e);
                                }
                            }
                        }
                        ReadOnlySourcesManager readOnlySourcesManager = SettingsRepositoryPackage$IcsManager$d5f67752.getIcsManager().getReadOnlySourcesManager();
                        List list = this.$newList;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"newList");
                        readOnlySourcesManager.setSources(list);
                    }
                    {
                        this.$toDelete = $captured_local_variable$0;
                        this.$toCheckout = $captured_local_variable$1;
                        this.$newList = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                    }
                });
            }

            public void reset() {
                this.$editor.reset(SettingsRepositoryPackage$IcsManager$d5f67752.getIcsManager().getSettings().getReadOnlySources());
            }

            @NotNull
            public JComponent getComponent() {
                return this.$editor.createComponent();
            }
            {
                this.$editor = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
            }
        };
    }
}

