/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.ui.UIUtil;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.KeychainPackage$CredentialsStore$dd08a8e9;
import org.jetbrains.keychain.KeychainPackage$OSXKeychainLibrary$2604f189;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$CredentialsStore$a492ae01;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$d5f67752;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$util$c8ef32c4;
import org.jetbrains.settingsRepository.git.GitPackage$JGitCredentialsProvider$8e7570ad;
import org.jetbrains.settingsRepository.git.GitPackage$gitCredential$f5f976e9;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"c\b)9\"jR5u\u0007J,G-\u001a8uS\u0006d7\u000f\u0015:pm&$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015I\u0019X\r\u001e;j]\u001e\u001c(+\u001a9pg&$xN]=\u000b\u0007\u001dLGOC\nDe\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'OC\u0004fG2L\u0007o]3\u000b\t)<\u0017\u000e\u001e\u0006\niJ\fgn\u001d9peRTa\u0001P5oSRt$\u0002E2sK\u0012,g\u000e^5bYN\u001cFo\u001c:f\u0015Aqu\u000e\u001e(vY2d\u0015M_=WC2,XMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\u0011)H/\u001b7\u000b!\r\u0013X\rZ3oi&\fGn]*u_J,'\u0002C6fs\u000eD\u0017-\u001b8\u000b\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0006SKB|7/\u001b;pefT1\u0001\\5c\u0015I\u0019'/\u001a3f]RL\u0017\r\\:Ge>lw)\u001b;\u000b\u0017\r\u0013X\rZ3oi&\fGn\u001d\u0006\u0006I><U\r\u001e\u0006\u0004kJL'BB+S\u0013&\u001c\bN\u0003\u0007vg\u0016\u0014h*Y7f\u0013R,WN\u0003\u0005Vg\u0016\u0014h.Y7f\u00159\u0019%/\u001a3f]RL\u0017\r\\%uK6TA\u0002]1tg^|'\u000fZ%uK6T!b]:i\u0017\u0016Lh)\u001b7f\u0015\u0019\u0019FO]5oO*11n\u001c;mS:TqAQ8pY\u0016\fgNC\fDe\u0016$WM\u001c;jC2LE/Z7%+N,'O\\1nK*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\u0007\u001d,GOC\u0003ji\u0016l7OC\u0003BeJ\f\u0017PC\u0007jg&sG/\u001a:bGRLg/\u001a\u0006\u0006e\u0016\u001cX\r\u001e\u0006\u0005+:LGO\u0003\u0005tkB\u0004xN\u001d;tU\bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0003\t\u0001A1!\u0002\u0002\u0005\u0006!\u001dQA\u0001\u0003\u0004\u0011\u0011)1\u0001b\u0002\t\u00061\u0001Q!\u0001\u0005\u0007\u000b\t!I\u0001#\u0004\u0006\u0005\u0011)\u0001bB\u0003\u0003\t\u0017Ay!B\u0002\u0005\r!-A\u0002A\u0003\u0003\t\u0003A\t\"B\u0002\u0005\u000f!AA\u0002A\u0003\u0003\t\rA!\"B\u0002\u0005\u0011!MA\u0002A\u0003\u0003\t\u0019AY!\u0002\u0002\u0005\u0011!MQa\u0001\u0003\b\u0011-a\u0001!\u0002\u0002\u0005\u000f!YQa\u0001C\u0004\u00113a\u0001!B\u0002\u0005\b!qA\u0002A\u0003\u0004\t/AY\u0002\u0004\u0001\u0006\u0003!\u0001Ra\u0001C\r\u0011?a\u0001!B\u0002\u0005\u001a!\u0005B\u0002A\u0003\u0003\t\u000fAI\"\u0002\u0002\u0005\b!\tRA\u0001C\u0004\u00119)\u0011\u0001c\t\u0006\u0005\u0011}\u0001BE\u0003\u0003\tAAy\"B\u0002\u0005\u001a!\u001dB\u0002A\u0003\u0004\t3AQ\u0003\u0004\u0001\u0005\u00011\u0011\u0011DA\u0003\u0002\u0011\u0011iC\u0002Ba\r1+\t3!B\u0001\t\u00151\u0005Qk\u0001\u0003\u0006\u0007\u0011U\u0011\"\u0001E\u000b[=!\u0011\r\u0002\r\u0006C\u0019)\u0011\u0001#\u0004\n\u0007%\u0011Q!\u0001E\b+\u000e!Qa\u0001\u0003\u0006\u0013\u0005A\u0011\"L\u0006\u0005C\u0012A\u0012\"\t\u0002\u0006\u0003!EQk\u0001\u0003\u0006\u0007\u0011I\u0011\"\u0001E\n[K\"\u0011\u0001g\u0006\u001e\u000e\u0011\u0001\u0001\u0002D\u0007\u0003\u000b\u0005A1\u0002U\u0002\u0001;\u001f!\u0001\u0001C\u0007\u000e\u0007\u0015\t\u0001\u0002\u0004G\u0001!\u000e\u0005Qt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u00181\u0005\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001bD\u0007\u0004\u000b\u0005AQ\u0002$\u0001Q\u0007\u0007\t#!B\u0001\t\u001cE\u001b1\u0002b\u0006\n\u0003\u0011\u0005Q\"\u0001\u0005\u000f\u001b\u0005Ai\"D\u0001\t\u001f5\t\u0001\u0012EW&\t-A*#(\u0004\u0005\u0001!aQBA\u0003\u0002\u0011-\u00016\u0001AO\u000f\t\u0001A1#D\u0004\u0006\u0003!\t\u0012\u0002\u0002C\u0001\u0013\t)\u0011\u0001c\u0006\u0012\u0005\u0015\t\u0001r\u0003)\u0004\u0002\u0005\u0012Q!\u0001E\u000e#\u000eAAQE\u0005\u0002\t\u0003i\u0011\u0001\u0003\b\u000e\u0005!yA\u0012AW\n\t-AB#\t\u0002\u0006\u0003!m\u0011kA\u0002\u0005)%\tA\u0011A\u0017\u0014\t-AJ#(\u0004\u0005\u0001!aQBA\u0003\u0002\u0011-\u00016\u0001A\u0011\u0003\u000b\u0005A\u0019#U\u0002\u0006\tSI\u0011\u0001\u0002\u0001\u000e\u0003!qQ\u0006\b\u0003\f1Wij\u0002\u0002\u0001\t'59Q!\u0001\u0005\u0012\u0013\u0011!\t!\u0003\u0002\u0006\u0003!]\u0011CA\u0003\u0002\u0011/\u00016\u0001A\u0011\u0003\u000b\u0005AY\"U\u0002\u0007\tWI\u0011\u0001\"\u0001\u000e\u0005!yA\u0012A\u001b#\u000b\u0005\"1\u001d\u0001M\u0005;+!\u0001\u0001C\u0003\u000e\r\u0015\t\u0001RB\u0005\u0004\u0013\t)\u0011\u0001c\u0004Q\u0007\u0001ij\u0001\u0002\u0001\t\u00135\u0011Q!\u0001E\t!\u000e\u0005\u0011EA\u0003\u0002\u0011\t\t6a\u0002C\u0005\u0013\u0005!\u0001!D\u0001\t\u00135\t\u00012\u0003"})
public final class JGitCredentialsProvider
extends CredentialsProvider {
    public static final /* synthetic */ KClass $kotlinClass;
    private Credentials credentialsFromGit;
    private final NotNullLazyValue<CredentialsStore> credentialsStore;
    private final Repository repository;

    static {
        $kotlinClass = Reflection.createKotlinClass(JGitCredentialsProvider.class);
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        for (int i = 0; i < items.length; ++i) {
            CredentialItem item = items[i];
            if (item instanceof CredentialItem.Password || item instanceof CredentialItem.Username || item instanceof CredentialItem.StringType || item instanceof CredentialItem.YesNoType) continue;
            return false;
        }
        return true;
    }

    public boolean get(@JetValueParameter(name="uri") @NotNull URIish uri, CredentialItem ... items) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        CredentialItem.Username userNameItem = null;
        CredentialItem passwordItem = null;
        String sshKeyFile = null;
        for (int i = 0; i < items.length; ++i) {
            CredentialItem item = items[i];
            if (item instanceof CredentialItem.Username) {
                userNameItem = (CredentialItem.Username)item;
                continue;
            }
            if (item instanceof CredentialItem.Password) {
                passwordItem = item;
                continue;
            }
            if (item instanceof CredentialItem.StringType) {
                String marker;
                String promptText = ((CredentialItem.StringType)item).getPromptText();
                if (promptText == null || !KotlinPackage.startsWith$default((String)promptText, (String)(marker = "Passphrase for "), (boolean)false, (int)2)) continue;
                sshKeyFile = KotlinPackage.substring((String)promptText, (int)marker.length());
                passwordItem = item;
                continue;
            }
            if (!(item instanceof CredentialItem.YesNoType)) continue;
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(item){
                final /* synthetic */ CredentialItem $item;

                public final void run() {
                    CredentialItem.YesNoType yesNoType = (CredentialItem.YesNoType)this.$item;
                    String string = ((CredentialItem.YesNoType)this.$item).getPromptText();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    yesNoType.setValue(MessageDialogBuilder.yesNo((String)"", (String)string).show() == 0);
                }
                {
                    this.$item = credentialItem;
                }
            });
            return true;
        }
        if (userNameItem == null && passwordItem == null) {
            return false;
        }
        return this.doGet(uri, userNameItem, passwordItem, sshKeyFile);
    }

    private final boolean doGet(@JetValueParameter(name="uri") URIish uri, @JetValueParameter(name="userNameItem", type="?") CredentialItem.Username userNameItem, @JetValueParameter(name="passwordItem", type="?") CredentialItem passwordItem, @JetValueParameter(name="sshKeyFile", type="?") String sshKeyFile) {
        Unit unit;
        Credentials credentials;
        String userFromUri = sshKeyFile == null ? SettingsRepositoryPackage$util$c8ef32c4.nullize(uri.getUser()) : (String)null;
        String passwordFromUri = SettingsRepositoryPackage$util$c8ef32c4.nullize(uri.getPass());
        boolean saveCredentialsToStore = false;
        if (userFromUri != null && passwordFromUri != null) {
            credentials = new Credentials(userFromUri, passwordFromUri);
        } else {
            if (sshKeyFile == null || !KeychainPackage$OSXKeychainLibrary$2604f189.getIsOSXCredentialsStoreSupported()) {
                if (this.credentialsFromGit == null) {
                    this.credentialsFromGit = GitPackage$gitCredential$f5f976e9.getCredentialsUsingGit(uri, this.repository);
                }
                credentials = this.credentialsFromGit;
            } else {
                credentials = null;
            }
            if (credentials == null) {
                try {
                    credentials = ((CredentialsStore)this.credentialsStore.getValue()).get(uri.getHost(), sshKeyFile);
                }
                catch (Throwable e) {
                    SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().error(e);
                }
                saveCredentialsToStore = true;
                if (userFromUri != null) {
                    Credentials credentials2 = credentials;
                    if (Intrinsics.areEqual((Object)userFromUri, (Object)(credentials2 != null ? credentials2.getId() : null)) ^ true) {
                        credentials = new Credentials(userFromUri, passwordFromUri);
                    } else if (passwordFromUri != null) {
                        Credentials credentials3 = credentials;
                        if (Intrinsics.areEqual((Object)passwordFromUri, (Object)(credentials3 != null ? credentials3.getToken() : null)) ^ true) {
                            credentials = new Credentials(userFromUri, passwordFromUri);
                        }
                    }
                }
            }
        }
        if (!KeychainPackage$CredentialsStore$dd08a8e9.isFulfilled(credentials)) {
            credentials = SettingsRepositoryPackage$CredentialsStore$a492ae01.showAuthenticationForm(credentials, GitPackage$JGitCredentialsProvider$8e7570ad.toStringWithoutCredentials(uri), uri.getHost(), uri.getPath(), sshKeyFile);
        }
        if (saveCredentialsToStore && KeychainPackage$CredentialsStore$dd08a8e9.isFulfilled(credentials)) {
            CredentialsStore credentialsStore2 = (CredentialsStore)this.credentialsStore.getValue();
            String string = uri.getHost();
            Credentials credentials4 = credentials;
            if (credentials4 == null) {
                Intrinsics.throwNpe();
            }
            credentialsStore2.save(string, credentials4, sshKeyFile);
        }
        CredentialItem.Username username = userNameItem;
        if (username != null) {
            Credentials credentials5 = credentials;
            username.setValue(credentials5 != null ? credentials5.getId() : null);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        if (passwordItem != null) {
            if (passwordItem instanceof CredentialItem.Password) {
                Object object = credentials;
                ((CredentialItem.Password)passwordItem).setValue(object != null && (object = ((Credentials)object).getToken()) != null ? KotlinPackage.toCharArray((String)object) : null);
            } else {
                CredentialItem credentialItem = passwordItem;
                if (credentialItem == null) {
                    throw new TypeCastException("org.eclipse.jgit.transport.CredentialItem? cannot be cast to org.eclipse.jgit.transport.CredentialItem.StringType");
                }
                Credentials credentials6 = credentials;
                ((CredentialItem.StringType)credentialItem).setValue(credentials6 != null ? credentials6.getToken() : null);
            }
        }
        return credentials != null;
    }

    public void reset(@JetValueParameter(name="uri") @NotNull URIish uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.credentialsFromGit = null;
        CredentialsStore credentialsStore2 = (CredentialsStore)this.credentialsStore.getValue();
        String string = uri.getHost();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        credentialsStore2.reset(string);
    }

    public JGitCredentialsProvider(@JetValueParameter(name="credentialsStore") @NotNull NotNullLazyValue<CredentialsStore> credentialsStore2, @JetValueParameter(name="repository") @NotNull Repository repository) {
        Intrinsics.checkParameterIsNotNull(credentialsStore2, (String)"credentialsStore");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.credentialsStore = credentialsStore2;
        this.repository = repository;
    }
}

