/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtil;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class FS_POSIX
extends FS {
    private static final int DEFAULT_UMASK = 18;
    private volatile int umask = -1;

    protected FS_POSIX() {
    }

    protected FS_POSIX(FS src) {
        super(src);
        if (src instanceof FS_POSIX) {
            this.umask = ((FS_POSIX)src).umask;
        }
    }

    @Override
    public FS newInstance() {
        return new FS_POSIX(this);
    }

    public void setUmask(int umask) {
        this.umask = umask;
    }

    private int umask() {
        int u = this.umask;
        if (u == -1) {
            this.umask = u = FS_POSIX.readUmask();
        }
        return u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readUmask() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "umask"}, null, null);
            BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset().name()));
            try {
                String s;
                if (p.waitFor() == 0 && (s = lineRead.readLine()).matches("0?\\d{3}")) {
                    int n = Integer.parseInt(s, 8);
                    return n;
                }
                int n = 18;
                return n;
            }
            finally {
                lineRead.close();
            }
        }
        catch (Exception e) {
            return 18;
        }
    }

    @Override
    protected File discoverGitExe() {
        String w;
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_POSIX.searchPath(path, "git");
        if (gitExe == null && SystemReader.getInstance().isMacOS() && FS_POSIX.searchPath(path, "bash") != null && !StringUtils.isEmptyOrNull(w = FS_POSIX.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name()))) {
            gitExe = new File(w);
        }
        return gitExe;
    }

    @Override
    public boolean isCaseSensitive() {
        return !SystemReader.getInstance().isMacOS();
    }

    @Override
    public boolean supportsExecute() {
        return true;
    }

    @Override
    public boolean canExecute(File f) {
        return FileUtil.canExecute(f);
    }

    @Override
    public boolean setExecute(File f, boolean canExecute) {
        if (!this.isFile(f)) {
            return false;
        }
        if (!canExecute) {
            return f.setExecutable(false);
        }
        return f.setExecutable(canExecute);
    }

    private static void apply(Set<PosixFilePermission> set, int umask, PosixFilePermission perm, int test) {
        if ((umask & test) == 0) {
            set.add(perm);
        } else {
            set.remove((Object)perm);
        }
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(4 + args.length);
        argv.add("sh");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        return this.internalRunHookIfPresent(repository, hookName, args, outRedirect, errRedirect, stdinArgs);
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return false;
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public boolean isSymLink(File path) throws IOException {
        return FileUtil.isSymlink(path);
    }

    @Override
    public long lastModified(File path) throws IOException {
        return FileUtil.lastModified(path);
    }

    @Override
    public void setLastModified(File path, long time) throws IOException {
        FileUtil.setLastModified(path, time);
    }

    @Override
    public void delete(File path) throws IOException {
        FileUtil.delete(path);
    }

    @Override
    public long length(File f) throws IOException {
        return FileUtil.getLength(f);
    }

    @Override
    public boolean exists(File path) {
        return FileUtil.exists(path);
    }

    @Override
    public boolean isDirectory(File path) {
        return FileUtil.isDirectory(path);
    }

    @Override
    public boolean isFile(File path) {
        return FileUtil.isFile(path);
    }

    @Override
    public boolean isHidden(File path) throws IOException {
        return FileUtil.isHidden(path);
    }

    @Override
    public void setHidden(File path, boolean hidden) throws IOException {
    }

    @Override
    public String readSymLink(File path) throws IOException {
        return FileUtil.readSymlink(path);
    }

    @Override
    public void createSymLink(File path, String target) throws IOException {
        FileUtil.createSymLink(path, target);
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtil.getFileAttributesPosix(this, path);
    }

    @Override
    public File normalize(File file) {
        return FileUtil.normalize(file);
    }

    @Override
    public String normalize(String name) {
        return FileUtil.normalize(name);
    }

    @Override
    public File findHook(Repository repository, String hookName) {
        File gitdir = repository.getDirectory();
        File hookPath = new File(gitdir, "hooks" + File.separatorChar + hookName);
        if (FileUtil.canExecute(hookPath)) {
            return hookPath;
        }
        return null;
    }
}

