/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubCommit;
import org.jetbrains.plugins.github.api.GithubCommitDetailed;
import org.jetbrains.plugins.github.api.GithubCommitSha;
import org.jetbrains.plugins.github.api.GithubFile;
import org.jetbrains.plugins.github.api.GithubFileRaw;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.api.GithubUserRaw;

class GithubCommitRaw
implements DataConstructor {
    @Nullable
    public String url;
    @Nullable
    public String sha;
    @Nullable
    public GithubUserRaw author;
    @Nullable
    public GithubUserRaw committer;
    @Nullable
    public GitCommitRaw commit;
    @Nullable
    public CommitStatsRaw stats;
    @Nullable
    public List<GithubFileRaw> files;
    @Nullable
    public List<GithubCommitRaw> parents;

    GithubCommitRaw() {
    }

    @NotNull
    public GithubCommitSha createCommitSha() {
        GithubCommitSha githubCommitSha = new GithubCommitSha(this.url, this.sha);
        if (githubCommitSha == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitRaw", "createCommitSha"));
        }
        return githubCommitSha;
    }

    @NotNull
    public GithubCommit createCommit() {
        GithubUser author = this.author == null ? null : this.author.createUser();
        GithubUser committer = this.committer == null ? null : this.committer.createUser();
        ArrayList<GithubCommitSha> parents = new ArrayList<GithubCommitSha>();
        for (GithubCommitRaw raw : this.parents) {
            parents.add(raw.createCommitSha());
        }
        GithubCommit githubCommit = new GithubCommit(this.url, this.sha, author, committer, parents, this.commit.create());
        if (githubCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitRaw", "createCommit"));
        }
        return githubCommit;
    }

    @NotNull
    public GithubCommitDetailed createCommitDetailed() {
        GithubCommit commit = this.createCommit();
        ArrayList<GithubFile> files = new ArrayList<GithubFile>();
        for (GithubFileRaw raw : this.files) {
            files.add(raw.createFile());
        }
        GithubCommitDetailed githubCommitDetailed = new GithubCommitDetailed(commit.getUrl(), commit.getSha(), commit.getAuthor(), commit.getCommitter(), commit.getParents(), commit.getCommit(), this.stats.create(), files);
        if (githubCommitDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitRaw", "createCommitDetailed"));
        }
        return githubCommitDetailed;
    }

    @Override
    @NotNull
    public <T> T create(@NotNull Class<T> resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultClass", "org/jetbrains/plugins/github/api/GithubCommitRaw", "create"));
        }
        if (resultClass == GithubCommitSha.class) {
            GithubCommitSha githubCommitSha = this.createCommitSha();
            if (githubCommitSha == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitRaw", "create"));
            }
            return (T)githubCommitSha;
        }
        if (resultClass == GithubCommit.class) {
            GithubCommit githubCommit = this.createCommit();
            if (githubCommit == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitRaw", "create"));
            }
            return (T)githubCommit;
        }
        if (resultClass == GithubCommitDetailed.class) {
            GithubCommitDetailed githubCommitDetailed = this.createCommitDetailed();
            if (githubCommitDetailed == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitRaw", "create"));
            }
            return (T)githubCommitDetailed;
        }
        throw new ClassCastException(this.getClass().getName() + ": bad class type: " + resultClass.getName());
    }

    public static class CommitStatsRaw {
        @Nullable
        public Integer additions;
        @Nullable
        public Integer deletions;
        @Nullable
        public Integer total;

        @NotNull
        public GithubCommitDetailed.CommitStats create() {
            GithubCommitDetailed.CommitStats commitStats = new GithubCommitDetailed.CommitStats(this.additions, this.deletions, this.total);
            if (commitStats == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitRaw$CommitStatsRaw", "create"));
            }
            return commitStats;
        }
    }

    public static class GitUserRaw {
        @Nullable
        public String name;
        @Nullable
        public String email;
        @Nullable
        public Date date;

        @NotNull
        public GithubCommit.GitUser create() {
            GithubCommit.GitUser gitUser = new GithubCommit.GitUser(this.name, this.email, this.date);
            if (gitUser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitRaw$GitUserRaw", "create"));
            }
            return gitUser;
        }
    }

    public static class GitCommitRaw {
        @Nullable
        public String url;
        @Nullable
        public String message;
        @Nullable
        public GitUserRaw author;
        @Nullable
        public GitUserRaw committer;

        @NotNull
        public GithubCommit.GitCommit create() {
            GithubCommit.GitCommit gitCommit = new GithubCommit.GitCommit(this.message, this.author.create(), this.committer.create());
            if (gitCommit == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitRaw$GitCommitRaw", "create"));
            }
            return gitCommit;
        }
    }
}

