/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.CompilerOutputParser;
import org.jetbrains.kotlin.compilerRunner.CompilerRunnerUtil;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class KotlinCompilerRunner {
    private static final String K2JVM_COMPILER = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    private static final String K2JS_COMPILER = "org.jetbrains.kotlin.cli.js.K2JSCompiler";
    private static final String INTERNAL_ERROR = ExitCode.INTERNAL_ERROR.toString();

    public static void runK2JvmCompiler(CommonCompilerArguments commonArguments, K2JVMCompilerArguments k2jvmArguments, CompilerSettings compilerSettings, MessageCollector messageCollector, CompilerEnvironment environment, File moduleFile, OutputItemsCollector collector) {
        K2JVMCompilerArguments arguments = KotlinCompilerRunner.mergeBeans(commonArguments, k2jvmArguments);
        KotlinCompilerRunner.setupK2JvmArguments(moduleFile, arguments);
        KotlinCompilerRunner.runCompiler(K2JVM_COMPILER, arguments, compilerSettings.getAdditionalArguments(), messageCollector, collector, environment);
    }

    public static void runK2JsCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JSCompilerArguments k2jsArguments, @NotNull CompilerSettings compilerSettings, @NotNull MessageCollector messageCollector, @NotNull CompilerEnvironment environment, @NotNull OutputItemsCollector collector, @NotNull Collection<File> sourceFiles, @NotNull List<String> libraryFiles, @NotNull File outputFile) {
        if (commonArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonArguments", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "runK2JsCompiler"));
        }
        if (k2jsArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2jsArguments", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "runK2JsCompiler"));
        }
        if (compilerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerSettings", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "runK2JsCompiler"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "runK2JsCompiler"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "runK2JsCompiler"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "runK2JsCompiler"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "runK2JsCompiler"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "runK2JsCompiler"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "runK2JsCompiler"));
        }
        K2JSCompilerArguments arguments = KotlinCompilerRunner.mergeBeans(commonArguments, k2jsArguments);
        KotlinCompilerRunner.setupK2JsArguments(outputFile, sourceFiles, libraryFiles, arguments);
        KotlinCompilerRunner.runCompiler(K2JS_COMPILER, arguments, compilerSettings.getAdditionalArguments(), messageCollector, collector, environment);
    }

    private static void runCompiler(String compilerClassName, CommonCompilerArguments arguments, String additionalArguments, MessageCollector messageCollector, OutputItemsCollector collector, CompilerEnvironment environment) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(stream);
        String exitCode = KotlinCompilerRunner.execCompiler(compilerClassName, arguments, additionalArguments, environment, out, messageCollector);
        BufferedReader reader = new BufferedReader(new StringReader(stream.toString()));
        CompilerOutputParser.parseCompilerMessagesFromReader(messageCollector, reader, collector);
        if (INTERNAL_ERROR.equals(exitCode)) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Compiler terminated with internal error", CompilerMessageLocation.NO_LOCATION);
        }
    }

    @NotNull
    private static String execCompiler(String compilerClassName, CommonCompilerArguments arguments, String additionalArguments, CompilerEnvironment environment, PrintStream out, MessageCollector messageCollector) {
        String string;
        try {
            messageCollector.report(CompilerMessageSeverity.INFO, "Using kotlin-home = " + environment.getKotlinPaths().getHomePath(), CompilerMessageLocation.NO_LOCATION);
            List<String> argumentsList = ArgumentUtils.convertArgumentsToStringList(arguments);
            argumentsList.addAll(StringUtil.split((String)additionalArguments, (String)" "));
            Object rc = CompilerRunnerUtil.invokeExecMethod(compilerClassName, ArrayUtil.toStringArray(argumentsList), environment, messageCollector, out);
            string = KotlinCompilerRunner.getReturnCodeFromObject(rc);
        }
        catch (Throwable e) {
            MessageCollectorUtil.reportException(messageCollector, e);
            String string2 = INTERNAL_ERROR;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "execCompiler"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "execCompiler"));
        }
        return string;
    }

    @NotNull
    private static String getReturnCodeFromObject(@Nullable Object rc) throws Exception {
        if (rc == null) {
            String string = INTERNAL_ERROR;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "getReturnCodeFromObject"));
            }
            return string;
        }
        if (ExitCode.class.getName().equals(rc.getClass().getName())) {
            String string = rc.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "getReturnCodeFromObject"));
            }
            return string;
        }
        throw new IllegalStateException("Unexpected return: " + rc);
    }

    private static <T extends CommonCompilerArguments> T mergeBeans(CommonCompilerArguments from, T to) {
        try {
            CommonCompilerArguments copy = (CommonCompilerArguments)XmlSerializerUtil.createCopy(to);
            List<Field> fromFields = KotlinCompilerRunner.collectFieldsToCopy(from.getClass());
            for (Field fromField : fromFields) {
                Field toField = copy.getClass().getField(fromField.getName());
                toField.set(copy, fromField.get(from));
            }
            return (T)copy;
        }
        catch (NoSuchFieldException e) {
            throw UtilsPackage.rethrow(e);
        }
        catch (IllegalAccessException e) {
            throw UtilsPackage.rethrow(e);
        }
    }

    private static List<Field> collectFieldsToCopy(Class<?> clazz) {
        ArrayList<Field> fromFields = new ArrayList<Field>();
        Class<?> currentClass = clazz;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                fromFields.add(field);
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return fromFields;
    }

    private static void setupK2JvmArguments(File moduleFile, K2JVMCompilerArguments settings) {
        settings.module = moduleFile.getAbsolutePath();
        settings.noStdlib = true;
        settings.noJdkAnnotations = true;
        settings.noJdk = true;
    }

    private static void setupK2JsArguments(@NotNull File outputFile, @NotNull Collection<File> sourceFiles, @NotNull List<String> libraryFiles, @NotNull K2JSCompilerArguments settings) {
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "setupK2JsArguments"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "setupK2JsArguments"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "setupK2JsArguments"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner", "setupK2JsArguments"));
        }
        settings.noStdlib = true;
        settings.freeArgs = ContainerUtil.map(sourceFiles, (Function)new Function<File, String>(){

            public String fun(File file) {
                return file.getPath();
            }
        });
        settings.outputFile = outputFile.getPath();
        settings.metaInfo = true;
        settings.libraryFiles = ArrayUtil.toStringArray(libraryFiles);
    }
}

