/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class BuildPackage$KotlinBuilder$c79545ad {
    static final Key<Set<File>> ALL_COMPILED_FILES_KEY = Key.create((String)"_all_kotlin_compiled_files_");
    static final Key<Set<ModuleBuildTarget>> PROCESSED_TARGETS_WITH_REMOVED_FILES = Key.create((String)"_processed_targets_with_removed_files_");

    public static final Key<Set<File>> getALL_COMPILED_FILES_KEY() {
        return ALL_COMPILED_FILES_KEY;
    }

    @NotNull
    public static final Set<File> getAllCompiledFilesContainer(@JetValueParameter(name="context") @NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Set allCompiledFiles = (Set)ALL_COMPILED_FILES_KEY.get((UserDataHolder)context);
        if (allCompiledFiles == null) {
            allCompiledFiles = (Set)new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            ALL_COMPILED_FILES_KEY.set((UserDataHolder)context, (Object)allCompiledFiles);
        }
        Set set = allCompiledFiles;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        return set;
    }

    public static final Key<Set<ModuleBuildTarget>> getPROCESSED_TARGETS_WITH_REMOVED_FILES() {
        return PROCESSED_TARGETS_WITH_REMOVED_FILES;
    }

    @NotNull
    public static final Set<ModuleBuildTarget> getProcessedTargetsWithRemovedFilesContainer(@JetValueParameter(name="context") @NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Set set = (Set)PROCESSED_TARGETS_WITH_REMOVED_FILES.get((UserDataHolder)context);
        if (set == null) {
            set = new HashSet();
            PROCESSED_TARGETS_WITH_REMOVED_FILES.set((UserDataHolder)context, (Object)set);
        }
        Set set2 = set;
        if (set2 == null) {
            Intrinsics.throwNpe();
        }
        return set2;
    }

    public static final boolean hasKotlinDirtyOrRemovedFiles(@JetValueParameter(name="dirtyFilesHolder") @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @JetValueParameter(name="chunk") @NotNull ModuleChunk chunk) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull(dirtyFilesHolder, (String)"dirtyFilesHolder");
            Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
            if (!KotlinSourceFileCollector.getDirtySourceFiles(dirtyFilesHolder).isEmpty()) {
                return true;
            }
            Iterable $receiver = chunk.getTargets();
            for (Object element : $receiver) {
                ModuleBuildTarget it = (ModuleBuildTarget)element;
                if (!(!KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, it).isEmpty())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }
}

