/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.StorageOwner;
import org.jetbrains.kotlin.jps.incremental.ByteArrayExternalizer;
import org.jetbrains.kotlin.jps.incremental.CacheFormatVersion;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl$ConstantsMapExternalizer$WhenMappings;
import org.jetbrains.kotlin.jps.incremental.IncrementalPackage$IncrementalCacheImpl$6579148b;
import org.jetbrains.kotlin.jps.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.jps.incremental.StringListExternalizer;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.header.HeaderPackage;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCache;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.utils.Printer;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0019\u0014)!\u0012J\\2sK6,g\u000e^1m\u0007\u0006\u001c\u0007.Z%na2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004UB\u001c(bC5oGJ,W.\u001a8uC2TAb\u0015;pe\u0006<WmT<oKJTqa\u001d;pe\u0006<WM\u0003\tJ]\u000e\u0014X-\\3oi\u0006d7)Y2iK*!An\\1e\u0015\u0015\u0019\u0017m\u00195f\u0015\u0019a\u0014N\\5u})qA/\u0019:hKR$\u0015\r^1S_>$(\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\bE\u0006\u001cX\rR5s\u0015I\u0019\u0017m\u00195f\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u000b%\r\u000b7\r[3G_Jl\u0017\r\u001e,feNLwN\u001c\u0006\rG>t7\u000f^1oiNl\u0015\r\u001d\u0006\r\u0007>t7\u000f^1oiNl\u0015\r\u001d\u0006\"\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7%\u0007>t7\u000f^1oiNl\u0015\r\u001d\u0006\u0016I&\u0014H/_(viB,Ho\u00117bgN,7/T1q\u0015U!\u0015N\u001d;z\u001fV$\b/\u001e;DY\u0006\u001c8/Z:NCBT!&\u00138de\u0016lWM\u001c;bY\u000e\u000b7\r[3J[BdG\u0005R5sif|U\u000f\u001e9vi\u000ec\u0017m]:fg6\u000b\u0007O\u0003\nj]2Lg.\u001a$v]\u000e$\u0018n\u001c8t\u001b\u0006\u0004(BE%oY&tWMR;oGRLwN\\:NCBTq%\u00138de\u0016lWM\u001c;bY\u000e\u000b7\r[3J[BdG%\u00138mS:,g)\u001e8di&|gn]'ba*!Q.\u00199t\u0015\u0011a\u0015n\u001d;\u000b\u0011\t\u000b7/[2NCBT1!\u00118z\u0015\u0011)H/\u001b7\u000b\u001dA\f7m[1hKB\u000b'\u000f^'ba*q\u0001+Y2lC\u001e,\u0007+\u0019:u\u001b\u0006\u0004(bI%oGJ,W.\u001a8uC2\u001c\u0015m\u00195f\u00136\u0004H\u000e\n)bG.\fw-\u001a)beRl\u0015\r\u001d\u0006\taJ|Go\\'ba*A\u0001K]8u_6\u000b\u0007OC\u000fJ]\u000e\u0014X-\\3oi\u0006d7)Y2iK&k\u0007\u000f\u001c\u0013Qe>$x.T1q\u0015I\u0019x.\u001e:dKR{7\t\\1tg\u0016\u001cX*\u00199\u000b%M{WO]2f)>\u001cE.Y:tKNl\u0015\r\u001d\u0006(\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7%'>,(oY3U_\u000ec\u0017m]:fg6\u000b\u0007OC\u0003dY\u0016\fgN\u0003\u0003V]&$(bG2mK\u0006\u00148)Y2iK\u001a{'OU3n_Z,Gm\u00117bgN,7OC\u000bSK\u000e|W\u000e]5mCRLwN\u001c#fG&\u001c\u0018n\u001c8\u000bU%s7M]3nK:$\u0018\r\\\"bG\",\u0017*\u001c9mII+7m\\7qS2\fG/[8o\t\u0016\u001c\u0017n]5p]*)1\r\\8tK*!A-^7q\u0015\u0019\u0019FO]5oO*!A.\u00198h\u0015\u00151G.^:i\u0015AiW-\\8ss\u000e\u000b7\r[3t\u001f:d\u0017PC\u0004C_>dW-\u00198\u000b/\u001d,Go\u00142t_2,G/\u001a)bG.\fw-\u001a)beR\u001c(BC\"pY2,7\r^5p]*qq-\u001a;QC\u000e\\\u0017mZ3ECR\f'B\u00024r\u001d\u0006lWMC\u0005CsR,\u0017I\u001d:bs*Ar-\u001a;SK\u000e|W\u000e]5mCRLwN\u001c#fG&\u001c\u0018n\u001c8\u000b\u0019A\u0014x\u000e^8DQ\u0006tw-\u001a3\u000b!\r|gn\u001d;b]R\u001c8\t[1oO\u0016$'BD5oY&tWm]\"iC:<W\r\u001a\u0006\u0017[\u0006\u00148nT;uaV$8\t\\1tg\u0016\u001cH)\u001b:us*I\"/Z7pm\u0016$\u0017I\u001c3D_6\u0004\u0018\u000e\\3e'>,(oY3t\u0015=\u0019\u0018M^3GS2,Gk\\\"bG\",'bC:pkJ\u001cWMR5mKNT1b[8uY&t7\t\\1tg*!Bj\\2bY\u001aKG.Z&pi2Lgn\u00117bgNT\u0011bQ8na\u0006t\u0017n\u001c8\u000b1\r{gn\u001d;b]R\u001cX*\u00199FqR,'O\\1mSj,'O\u0003\u0010J]2Lg.\u001a$v]\u000e$\u0018n\u001c8t\u001b\u0006\u0004X\t\u001f;fe:\fG.\u001b>feZ\u0017!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0007!\u0015QA\u0001C\u0004\u0011\u000f)1\u0001\u0002\u0003\t\u00071\u0001QA\u0001\u0003\u0002\u0011\u0013)!\u0001B\u0003\t\u0004\u0015\u0011A1\u0002E\u0003\u000b\t!a\u0001C\u0003\u0006\u0007\u00115\u0001\u0002\u0002\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\u0010!=Qa\u0001\u0003\t\u0011\u001ba\u0001!\u0002\u0002\u0005\u0011!5Qa\u0001\u0003\u0003\u0011%a\u0001!\u0002\u0002\u0005\u0005!IQa\u0001C\u0003\u0011)a\u0001!\u0002\u0002\u0005\u0005!UQa\u0001C\u0003\u0011/a\u0001!\u0002\u0002\u0005\u0005!aQa\u0001C\u0003\u00115a\u0001!\u0002\u0002\u0005\u0005!mQ!\u0001E\u0002\u000b\r!Y\u0002#\b\r\u0001\u0015\u0019AQ\u0001\u0005\u0010\u0019\u0001)1\u0001b\u0007\t 1\u0001QA\u0001C\b\u0011A)!\u0001b\b\t\u001e\u0015\u0019AQ\u0001\u0005\u0012\u0019\u0001)!\u0001\u0002\u0002\t$\u0015\u0019AQ\u0001E\u0013\u0019\u0001)!\u0001\u0002\u0002\t'\u0015\u0019AQ\u0001\u0005\u0015\u0019\u0001)!\u0001\u0002\u0002\t*\u0015\u0019A1\u0004E\u0016\u0019\u0001)1\u0001\"\u0002\t.1\u0001QA\u0001\u0003\u0003\u0011])1\u0001b\u0007\t21\u0001QA\u0001C\b\u0011e)!\u0001b\u000b\t2\u0015\u0019A1\u0004E\u001b\u0019\u0001)1\u0001b\u0007\t81\u0001QA\u0001C\u0010\u0011o)1\u0001b\u0007\t;1\u0001Qa\u0001\u0003\u0003\u0011\tb\u0001!\u0002\u0002\u0005\u0005!\u0011Ca\u0001G\u0003!\u000bJ\"!B\u0001\t\ne\u0011Q!\u0001\u0005\b9=a*\u0005\b\u0006\u001dGq]A$\u0004O$9Ea*\u0003(\f\u001d)5ZA!\u0019\u0003\u0019\u0011\u0005\u0012Q!\u0001E\t+\u000e!Qa\u0001\u0003\t\u0013\u0005A\u0011\"L\u0006\u0005C\u0012A\n\"\t\u0002\u0006\u0003!MQk\u0001\u0003\u0006\u0007\u0011E\u0011\"\u0001\u0005\u000b[-!\u0011\r\u0002M\nC\t)\u0011\u0001#\u0006V\u0007\u0011)1\u0001b\u0005\n\u0003!YQf\u0003\u0003b\taY\u0011EA\u0003\u0002\u0011/)6\u0001B\u0003\u0004\t-I\u0011\u0001\u0003\u0007.\u0017\u0011\tG\u0001'\u0007\"\u0005\u0015\t\u0001\u0012D+\u0004\t\u0015\u0019A\u0011D\u0005\u0002\u00115iC\u0003B1\u000519\t3\"B\u0001\t\u001d%A\u0011bB\u0003\u0002\u0011;IA\u0001\"\u0001\n\u0005\u0015\t\u0001bD+\u0004\t\u0015\u0019AAD\u0005\u0002\u0011Ai3\u0002B1\u00051C\t#!B\u0001\t\"U\u001bA!B\u0002\u0005\"%\t\u0001\"E\u0017\f\t\u0005$\u0001DE\u0011\u0003\u000b\u0005A\u0019#V\u0002\u0005\u000b\r!!#C\u0001\t%5ZA!\u0019\u0003\u0019(\u0005\u0012Q!\u0001E\u0013+\u000e!Qa\u0001C\u0014\u0013\u0005A1#l\u0005\u0005\u0017a)\u0012EA\u0003\u0002\u0011O\t6a\u0001\u0003\u0016\u0013\u0005!\u0001!l\u0005\u0005\u0007a1\u0012EA\u0003\u0002\u0011Q\t6a\u0001\u0003\u0017\u0013\u0005AI#l\u0005\u0005\u0017a=\u0012EA\u0003\u0002\u0011O\t6a\u0001C\u0018\u0013\u0005!\u0001!l\u0005\u0005\baA\u0012EA\u0003\u0002\u0011U\t6a\u0001\u0003\u0019\u0013\u0005Aa#L\n\u0005\u0017aMRT\u0002\u0003\u0001\u0011ii!!B\u0001\t.A\u001b\u0001!\t\u0002\u0006\u0003!\u001d\u0012kA\u0003\u00054%\tA\u0001A\u0007\u0002\t\u0003i[\u0002B\u0006\u00197\u00052Q!\u0001\u0005\u0018\u0013\rI!!B\u0001\t+E\u001b1\u0001B\u000e\n\u0003!=R&\u0006\u0003\f1qij\u0001\u0002\u0001\t:5\u0011Q!\u0001\u0005\u0016!\u000e\u0001\u0011eA\u0003\u0002\u0011aa\t!U\u0002\u0007\tqI!\u0001b\u0001\r\u00025\t\u0001BF\u0017'\t\u0005AZ$(\u0004\u0005\u0001!qRBA\u0003\u0002\u0011[\u00016\u0001AO\u0007\t\u0001Ai$\u0004\u0002\u0006\u0003!5\u0002k!\u0001\u001e\u000e\u0011\u0001\u0001bH\u0007\u0003\u000b\u0005Ai\u0003U\u0002\u0002C\t)\u0011\u0001\u0003\u000bR\u0007%!Y$C\u0001\t*5\tA\u0011A\u0007\u0002\t\u0003i\u0011\u0001\"\u0001./\u0011\u0019\u0001tHO\u000b\t\u0001A\u0001%\u0004\u0004\u0006\u0003!q\u0011bA\u0005\u0003\u000b\u0005A\t\u0002U\u0002\u0001C\t)\u0011\u0001c\nR\u0007\u0015!y$C\u0001\u0005\u00015\t\u0001\u0002EW!\t\rA\n%(\u0006\u0005\u0001!\tSBB\u0003\u0002\u0011]I1!\u0003\u0002\u0006\u0003!E\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012I\u0007\u0003\u000b\u0005A\t\u0004UB\u0001C\t)\u0011\u0001\u0003\u000bR\u0007\u001d!\t%C\u0001\t*5\t\u0001rF\u0007\u0002\u0011e)L#b\n\u0005G\u0004AZ!(\u0004\u0005\u0001!1QBA\u0003\u0002\u0011#\u00016\u0001A\u0011\u0003\u000b\u0005A)!U\u0002\u0006\t\u0017I\u0011\u0001\u0002\u0001\u000e\u0003!I\u0001"})
public final class IncrementalCacheImpl
implements StorageOwner,
IncrementalCache {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final String PROTO_MAP = "proto.tab";
    @NotNull
    public static final String CONSTANTS_MAP = "constants.tab";
    @NotNull
    public static final String INLINE_FUNCTIONS = "inline-functions.tab";
    @NotNull
    public static final String PACKAGE_PARTS = "package-parts.tab";
    @NotNull
    public static final String SOURCE_TO_CLASSES = "source-to-classes.tab";
    @NotNull
    public static final String DIRTY_OUTPUT_CLASSES = "dirty-output-classes.tab";
    private final File baseDir;
    private final ProtoMap protoMap;
    private final ConstantsMap constantsMap;
    private final InlineFunctionsMap inlineFunctionsMap;
    private final PackagePartMap packagePartMap;
    private final SourceToClassesMap sourceToClassesMap;
    private final DirtyOutputClassesMap dirtyOutputClassesMap;
    private final List<? extends BasicMap<? extends Object>> maps;
    private final CacheFormatVersion cacheFormatVersion;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(IncrementalCacheImpl.class);
        OBJECT$ = Companion = org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl$Companion.access$init$0();
        PROTO_MAP = PROTO_MAP;
        CONSTANTS_MAP = CONSTANTS_MAP;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        PACKAGE_PARTS = PACKAGE_PARTS;
        SOURCE_TO_CLASSES = SOURCE_TO_CLASSES;
        DIRTY_OUTPUT_CLASSES = DIRTY_OUTPUT_CLASSES;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.maps;
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            BasicMap basicMap = (BasicMap)item;
            Collection collection = destination;
            String string = it.dump();
            collection.add(string);
        }
        return KotlinPackage.join$default((Iterable)((List)var3_3), (String)"\n\n", null, null, (int)0, null, (int)30);
    }

    /*
     * WARNING - void declaration
     */
    public final void markOutputClassesDirty(@JetValueParameter(name="removedAndCompiledSources") @NotNull List<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        for (File file : removedAndCompiledSources) {
            void $receiver;
            Collection<JvmClassName> classes = this.sourceToClassesMap.get(file);
            Iterable iterable = classes;
            for (Object element : $receiver) {
                JvmClassName it = (JvmClassName)element;
                DirtyOutputClassesMap dirtyOutputClassesMap = this.dirtyOutputClassesMap;
                String string = it.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.getInternalName()");
                dirtyOutputClassesMap.markDirty(string);
            }
            this.sourceToClassesMap.clearOutputsForSource(file);
        }
    }

    private final RecompilationDecision getRecompilationDecision(@JetValueParameter(name="protoChanged") boolean protoChanged, @JetValueParameter(name="constantsChanged") boolean constantsChanged, @JetValueParameter(name="inlinesChanged") boolean inlinesChanged) {
        return inlinesChanged ? RecompilationDecision.RECOMPILE_ALL_IN_CHUNK_AND_DEPENDANTS : (constantsChanged ? RecompilationDecision.RECOMPILE_OTHER_IN_CHUNK_AND_DEPENDANTS : (protoChanged ? RecompilationDecision.RECOMPILE_OTHER_KOTLIN_IN_CHUNK : RecompilationDecision.DO_NOTHING));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RecompilationDecision saveFileToCache(@JetValueParameter(name="sourceFiles") @NotNull Collection<? extends File> sourceFiles, @JetValueParameter(name="kotlinClass") @NotNull LocalFileKotlinClass kotlinClass) {
        RecompilationDecision recompilationDecision;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
        this.cacheFormatVersion.saveIfNeeded();
        byte[] fileBytes = kotlinClass.getFileContents();
        JvmClassName className = JvmClassName.byClassId((ClassId)kotlinClass.getClassId());
        KotlinClassHeader header = kotlinClass.getClassHeader();
        String string = className.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.getInternalName()");
        this.dirtyOutputClassesMap.notDirty(string);
        Iterable iterable = sourceFiles;
        for (Object element : $receiver2) {
            File it = (File)element;
            SourceToClassesMap sourceToClassesMap = this.sourceToClassesMap;
            JvmClassName jvmClassName = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            sourceToClassesMap.addSourceToClass(it, jvmClassName);
        }
        if (HeaderPackage.isCompatiblePackageFacadeKind((KotlinClassHeader)header)) {
            JvmClassName jvmClassName = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            byte[] byArray = BitEncoding.decodeBytes((String[])header.getAnnotationData());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BitEncoding.decodeBytes(header.annotationData)");
            recompilationDecision = this.getRecompilationDecision(this.protoMap.put(jvmClassName, byArray), false, false);
        } else if (HeaderPackage.isCompatibleClassKind((KotlinClassHeader)header)) {
            JvmClassName jvmClassName = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            byte[] byArray = BitEncoding.decodeBytes((String[])header.getAnnotationData());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BitEncoding.decodeBytes(header.annotationData)");
            boolean bl = this.protoMap.put(jvmClassName, byArray);
            JvmClassName jvmClassName2 = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"className");
            boolean bl2 = this.constantsMap.process(jvmClassName2, fileBytes);
            JvmClassName jvmClassName3 = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"className");
            recompilationDecision = this.getRecompilationDecision(bl, bl2, this.inlineFunctionsMap.process(jvmClassName3, fileBytes));
        } else if (Intrinsics.areEqual((Object)header.getSyntheticClassKind(), (Object)JvmAnnotationNames.KotlinSyntheticClass.Kind.PACKAGE_PART)) {
            void value;
            boolean $receiver2 = sourceFiles.size() == 1;
            if (KotlinPackage.getASSERTIONS_ENABLED() && value == false) {
                String message = "Package part from several source files: " + sourceFiles;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            JvmClassName jvmClassName = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.packagePartMap.addPackagePart(jvmClassName);
            JvmClassName jvmClassName4 = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"className");
            boolean bl = this.constantsMap.process(jvmClassName4, fileBytes);
            JvmClassName jvmClassName5 = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName5, (String)"className");
            recompilationDecision = this.getRecompilationDecision(false, bl, this.inlineFunctionsMap.process(jvmClassName5, fileBytes));
        } else {
            recompilationDecision = RecompilationDecision.DO_NOTHING;
        }
        return recompilationDecision;
    }

    @NotNull
    public final RecompilationDecision clearCacheForRemovedClasses() {
        RecompilationDecision recompilationDecision = RecompilationDecision.DO_NOTHING;
        for (String internalClassName : this.dirtyOutputClassesMap.getDirtyOutputClasses()) {
            JvmClassName className = JvmClassName.byInternalName((String)internalClassName);
            RecompilationDecision newDecision = this.getRecompilationDecision(this.protoMap.contains(internalClassName), this.constantsMap.contains(internalClassName), this.inlineFunctionsMap.contains(internalClassName));
            recompilationDecision = recompilationDecision.merge(newDecision);
            JvmClassName jvmClassName = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.protoMap.remove(jvmClassName);
            JvmClassName jvmClassName2 = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"className");
            this.packagePartMap.remove(jvmClassName2);
            JvmClassName jvmClassName3 = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"className");
            this.constantsMap.remove(jvmClassName3);
            JvmClassName jvmClassName4 = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"className");
            this.inlineFunctionsMap.remove(jvmClassName4);
        }
        this.dirtyOutputClassesMap.clear();
        return recompilationDecision;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            String it = (String)element;
            PackagePartMap packagePartMap = this.packagePartMap;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(it)");
            if (!packagePartMap.isPackagePart(jvmClassName)) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    @Nullable
    public byte[] getPackageData(@JetValueParameter(name="fqName") @NotNull String fqName) {
        Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses((FqName)PackageClassUtils.getPackageClassFqName((FqName)new FqName(fqName)));
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byFqNameWit\u2026ssFqName(FqName(fqName)))");
        return this.protoMap.get(jvmClassName);
    }

    public void flush(@JetValueParameter(name="memoryCachesOnly") boolean memoryCachesOnly) {
        Iterable $receiver = this.maps;
        for (Object element : $receiver) {
            BasicMap it = (BasicMap)element;
            it.flush(memoryCachesOnly);
        }
    }

    public void clean() {
        Iterable $receiver = this.maps;
        for (Object element : $receiver) {
            BasicMap it = (BasicMap)element;
            it.clean();
        }
        this.cacheFormatVersion.clean();
    }

    public void close() {
        Iterable $receiver = this.maps;
        for (Object element : $receiver) {
            BasicMap it = (BasicMap)element;
            it.close();
        }
    }

    public IncrementalCacheImpl(@JetValueParameter(name="targetDataRoot") @NotNull File targetDataRoot) {
        Intrinsics.checkParameterIsNotNull((Object)targetDataRoot, (String)"targetDataRoot");
        this.baseDir = new File(targetDataRoot, IncrementalPackage$IncrementalCacheImpl$6579148b.getCACHE_DIRECTORY_NAME());
        this.protoMap = new ProtoMap();
        this.constantsMap = new ConstantsMap();
        this.inlineFunctionsMap = new InlineFunctionsMap();
        this.packagePartMap = new PackagePartMap();
        this.sourceToClassesMap = new SourceToClassesMap();
        this.dirtyOutputClassesMap = new DirtyOutputClassesMap();
        this.maps = KotlinPackage.listOf((Object[])new BasicMap[]{this.protoMap, this.constantsMap, this.inlineFunctionsMap, this.packagePartMap, this.sourceToClassesMap, this.dirtyOutputClassesMap});
        this.cacheFormatVersion = new CacheFormatVersion(targetDataRoot);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"?\u0006)I1i\\7qC:LwN\u001c\u0006\u0015\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015-Ign\u0019:f[\u0016tG/\u00197\u000b\u0007\u0005s\u0017PC\u0007D\u001f:\u001bF+\u0011(U'~k\u0015\t\u0015\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\thKR\u001cuJT*U\u0003:#6kX'B!*!B)\u0013*U3~{U\u000b\u0016)V)~\u001bE*Q*T\u000bNSqcZ3u\t&\u0013F+W0P+R\u0003V\u000bV0D\u0019\u0006\u001b6+R*\u000b!%sE*\u0013(F?\u001a+fj\u0011+J\u001f:\u001b&bE4fi&sE*\u0013(F?\u001a+fj\u0011+J\u001f:\u001b&\"\u0004)B\u0007.\u000bu)R0Q\u0003J#6K\u0003\thKR\u0004\u0016iQ&B\u000f\u0016{\u0006+\u0011*U'*I\u0001KU(U\u001f~k\u0015\t\u0015\u0006\rO\u0016$\bKU(U\u001f~k\u0015\t\u0015\u0006\u0012'>+&kQ#`)>{6\tT!T'\u0016\u001b&\u0002F4fiN{UKU\"F?R{ul\u0011'B'N+5\u000b\u0015\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u0001\u0012\u0002\u0007\u0001\u000b\u0005AQ!\u0002\u0002\u0005\u000b!-QA\u0001C\u0006\u0011\u0013!19\u0001\u0007\u00043\t)\u0011\u0001\u0003\u0003.!\u0011\u0001G\u0003\u0007\u0003\"\u0005\u0015\t\u0001\u0012B+\u0004\u0013\u0015!A\u0001B\u0005\u0002\u0011\u0019a\t!D\u0002\u0005\r%\t\u0001BB\u0017\u0011\t\u0001$\u0002TB\u0011\u0003\u000b\u0005AI!V\u0002\n\u000b\u0011!i!C\u0001\t\r1\u0005Qb\u0001\u0003\b\u0013\u0005Aa!\f\t\u0005ARAz!\t\u0002\u0006\u0003!%QkA\u0005\u0006\t\u0011=\u0011\"\u0001\u0005\u0007\u0019\u0003i1\u0001\u0002\u0005\n\u0003!1Q\u0006\u0005\u0003a)aE\u0011EA\u0003\u0002\u0011\u0013)6!C\u0003\u0005\t#I\u0011\u0001\u0003\u0004\r\u00025\u0019A!C\u0005\u0002\u0011\u0019i\u0003\u0003\u00021\u00151'\t#!B\u0001\t\nU\u001b\u0011\"\u0002\u0003\u0005\u0014%\t\u0001B\u0002G\u0001\u001b\r!!\"C\u0001\t\r5\u0002B\u0001\u0019\u000b\u0019\u0016\u0005\u0012Q!\u0001E\u0005+\u000eIQ\u0001\u0002C\u000b\u0013\u0005Aa\u0001$\u0001\u000e\u0007\u0011Y\u0011\"\u0001\u0005\u0007k\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final String getPROTO_MAP() {
            return PROTO_MAP;
        }

        @NotNull
        public final String getCONSTANTS_MAP() {
            return CONSTANTS_MAP;
        }

        @NotNull
        public final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        @NotNull
        public final String getPACKAGE_PARTS() {
            return PACKAGE_PARTS;
        }

        @NotNull
        public final String getSOURCE_TO_CLASSES() {
            return SOURCE_TO_CLASSES;
        }

        @NotNull
        public final String getDIRTY_OUTPUT_CLASSES() {
            return DIRTY_OUTPUT_CLASSES;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$0() {
            return new Companion();
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={",\u0006)A!)Y:jG6\u000b\u0007O\u0003\u000bJ]\u000e\u0014X-\\3oi\u0006d7)Y2iK&k\u0007\u000f\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*\u0019!\u000e]:\u000b\u0017%t7M]3nK:$\u0018\r\u001c\u0006\u0002-*\u0019\u0011I\\=\u000b\rqJg.\u001b;?\u0015\u001d\u0019Ho\u001c:bO\u0016T\u0011\u0003U3sg&\u001cH/\u001a8u\u0011\u0006\u001c\b.T1q\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*!Q\u000f^5m\u0015\tIwN\u0003\u0004TiJLgn\u001a\u0006\u000bO\u0016$8\u000b^8sC\u001e,'BC:fiN#xN]1hK*)1\r\\3b]*!QK\\5u\u0015\u0015\u0019Gn\\:f\u0015!\u0019wN\u001c;bS:\u001c(bA6fs*9!i\\8mK\u0006t'\u0002\u00026bm\u0006TA\u0001\\1oO*I1M]3bi\u0016l\u0015\r\u001d\u0006\u0005IVl\u0007OC\u0005ek6\u0004h+\u00197vK*)a/\u00197vK*1qJ\u00196fGRTQA\u001a7vg\"T\u0001#\\3n_JL8)Y2iKN|e\u000e\\=\u000b\u0004)\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)1\u0001\u0002\u0002\t\u00021\u0001Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0005\u0015\u0019Aq\u0001\u0005\u0005\u0019\u0001)\u0011\u0001\u0003\u0004\u0006\u0005\u0011%\u0001RB\u0003\u0003\t\u0015Aq!\u0002\u0002\u0005\f!=Qa\u0001\u0003\u0007\u0011\u0017a\u0001!B\u0002\u0005\b!AA\u0002A\u0003\u0003\t\u0019AY!B\u0002\u0005\b!QA\u0002A\u0003\u0004\t\u000fAA\u0002\u0004\u0001\u0006\u0003!eQA\u0001\u0003\n\u00115)!\u0001b\u0005\t\u0011\u0015\u0011A1\u0003E\u0010\tEa1!\u0006\u0004\u0005\u0001!\u001dQcA\u0003\u0002\u0011\u0011a\t!\u0007\u0002\u0006\u0003!!QF\b\u0003C\u001aa)\u0011eC\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!9\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001V\u00079)1\u0001B\u0003\n\u0003!=Qb\u0001C\t\u0013\u0005Ay!E\u0003\u0005\u0013%\tA\u0001A\u0007\u0002\u0011\u001fi\u001b\u0002B\u0002\u0019\u0014\u0005\u0012Q!\u0001\u0005\t#\u000e\u0019A1C\u0005\u0002\t\u0001i\u001b\u0002B\u0002\u0019\u0016\u0005\u0012Q!\u0001\u0005\t#\u000e\u0019AQC\u0005\u0002\t\u0001i3\u0003B\u0002\u0019\u0017u5A\u0001\u0001E\f\u001b\t)\u0011\u0001C\u0004Q\u0007\u0001\t#!B\u0001\t\u0012E\u001bQ\u0001B\u0006\n\u0003\u0011\u0005Q\"\u0001\u0005\u000b[K!!\u0003g\u0007\"\u0017\u0015\t\u0001RB\u0005\u0004\u0013\t)\u0011\u0001C\u0004\n\t%\u0019QA\u0001C\u0001\u0011\u0001\t6a\u0001C\u000e\u0013\u0005Ay!l\u0005\u0005\baq\u0011EA\u0003\u0002\u0011\u001d\t6a\u0001\u0003\u000f\u0013\u0005A!\"\f\u000b\u0005%auQt\u0002\u0003\u0001\u0011=i1!\u0002\u0002\u0005\u0002!\u0001\u0001k\u0001\u0001\"\u0005\u0015\t\u0001bB)\u0004\u000b\u0011u\u0011\"\u0001\u0005\u000b\u001b\u0005A)\"L\n\u0005\u0007a\u0001RT\u0002\u0003\u0001\u0011Ci!!B\u0001\t\u0012A\u001b\u0001!\t\u0002\u0006\u0003!A\u0011kA\u0003\u0005!%\tA\u0001A\u0007\u0002\t\u0003)t#\u0002\f\u0005G\u0004\tb\u0001\u0002\u0001\t\bU\u0019Q!\u0001\u0005\u0005\u0019\u0003AJ!I\u0004\u0006\u0003!\u0019\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001R\u0007\r!I!C\u0001\u0005\u0001\u0001"})
    private static abstract class BasicMap<V> {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private PersistentHashMap<String, V> storage = this.createMap();

        static {
            $kotlinClass = Reflection.createKotlinClass(BasicMap.class);
        }

        @NotNull
        protected final PersistentHashMap<String, V> getStorage() {
            return this.storage;
        }

        protected final void setStorage(@JetValueParameter(name="<set-?>") @NotNull PersistentHashMap<String, V> persistentHashMap) {
            Intrinsics.checkParameterIsNotNull(persistentHashMap, (String)"<set-?>");
            this.storage = persistentHashMap;
        }

        @NotNull
        protected abstract PersistentHashMap<String, V> createMap();

        public final boolean contains(@JetValueParameter(name="key") @NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return this.storage.containsMapping((Object)key);
        }

        public final void clean() {
            try {
                this.storage.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            File file = this.storage.getBaseFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            PersistentHashMap.deleteFilesStartingWith((File)file);
            try {
                this.storage = this.createMap();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public final void flush(@JetValueParameter(name="memoryCachesOnly") boolean memoryCachesOnly) {
            if (memoryCachesOnly) {
                if (this.storage.isDirty()) {
                    this.storage.dropMemoryCaches();
                }
            } else {
                this.storage.force();
            }
        }

        public final void close() {
            this.storage.close();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String dump() {
            void var2_2;
            StringBuilder receiver = new StringBuilder();
            StringBuilder $receiver = receiver;
            Printer receiver2 = new Printer($receiver);
            Printer $receiver2 = receiver2;
            $receiver2.println(this.getClass().getSimpleName());
            $receiver2.pushIndent();
            for (String key : KotlinPackage.sort((Iterable)this.getStorage().getAllKeysWithExistingMapping())) {
                $receiver2.println(key + " -> " + this.dumpValue(this.getStorage().get((Object)key)));
            }
            $receiver2.popIndent();
            String string = ((StringBuilder)var2_2).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"with(StringBuilder()) {\n\u2026\n            }.toString()");
            return string;
        }

        @NotNull
        protected abstract String dumpValue(@JetValueParameter(name="value") V var1);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0013\u0006)A\u0001K]8u_6\u000b\u0007O\u0003\u000bJ]\u000e\u0014X-\\3oi\u0006d7)Y2iK&k\u0007\u000f\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*\u0019!\u000e]:\u000b\u0017%t7M]3nK:$\u0018\r\u001c\u0006\t\u0005\u0006\u001c\u0018nY'ba*I!)\u001f;f\u0003J\u0014\u0018-\u001f\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0013\r\u0014X-\u0019;f\u001b\u0006\u0004(\"\u0005)feNL7\u000f^3oi\"\u000b7\u000f['ba*\u00191m\\7\u000b\u0011%tG/\u001a7mS*TA!\u001e;jY*\u0011\u0011n\u001c\u0006\u0007'R\u0014\u0018N\\4\u000b\u0013\u0011,X\u000e\u001d,bYV,'\"\u0002<bYV,'\u0002\u00026bm\u0006TA\u0001\\1oO*\u0019q-\u001a;\u000b\u0013\rd\u0017m]:OC6,'\u0002\u0004&w[\u000ec\u0017m]:OC6,'b\u0002:fg>dg/\u001a\u0006\u0004UZl'b\u00019vi*!A-\u0019;b\u0015\u001d\u0011un\u001c7fC:TaA]3n_Z,'\u0002B+oSRd\u001bA\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\tA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\r!)\u0001c\u0002\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u0011AA\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0012A\u0003\u0002\u0011\u0019)!\u0001b\u0003\t\u000e\u0015\u0011AA\u0002\u0005\b\u000b\t!i\u0001c\u0004\u0006\u0007\u00119\u00012\u0002\u0007\u0001\u000b\r!A\u0001\u0003\u0005\r\u0001\u0015\u0011Aa\u0002E\u0006\u000b\u0005A\u0019\"\u0002\u0002\u0005\u0013!QQA\u0001C\n\u0011!)!\u0001B\u0001\t\u0019\u0015\u0011AQ\u0003E\r\u000b\r!1\u0002c\u0006\r\u0001\u0015\u0011Aa\u0003E\f\u000b\r!A\u0001\u0003\b\r\u0001\u0015\u0019A\u0001\u0002\u0005\u0010\u0019\u0001!\u0011I\u0001\u0007\u00043\u0019)\u0011\u0001c\u0002\n\u0007%\u0011Q!\u0001E\u0005[G!!\u0002G\u0003\"\u0015\u0015\t\u0001rB\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0005\n\u0007%\u0011Q!\u0001E\u0005#\u000e\u0019A!B\u0005\u0002\u0011#iC\u0003\u0002\u0006\u0019\u0012u5A\u0001\u0001\u0005\n\u001b\t)\u0011\u0001#\u0003Q\u0007\u0001\t#!B\u0001\t\u0011E\u001ba\u0001\"\u0005\n\u0003!QQB\u0001C\u0002\u0019\u0003iS\u0003B\u0002\u0019\u0016u5A\u0001\u0001\u0005\f\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001\t3!B\u0001\t\n1\u0005\u0011k\u0001\u0004\u0005\u0016%\u0011A1\u0001G\u0001\u001b\u0005AA\"l\u000f\u0005\u0007aiQT\u0002\u0003\u0001\u0011-i!!B\u0001\t\u0018A\u001b\u0001!(\u0004\u0005\u0001!mQBA\u0003\u0002\u0011\u0013\u00016\u0011A\u0011\u0003\u000b\u0005AI\"U\u0002\t\t5I\u0011\u0001\"\u0001\u000e\u0003!aQB\u0001C\u0002\u0019\u0003i3\u0003B\u0002\u0019\u001eu5A\u0001\u0001\u0005\f\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001\t#!B\u0001\t\u001bE\u001bQ\u0001\"\b\n\u0003\u0011\u0001Q\"\u0001\u0005\rk5)A\u0002Br\u00011\u0013\t#!B\u0001\t\u0007E\u001bQ\u0001\"\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\u0006"})
    private final class ProtoMap
    extends BasicMap<byte[]> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(ProtoMap.class);
        }

        @Override
        @NotNull
        protected PersistentHashMap<String, byte[]> createMap() {
            return new PersistentHashMap(new File(IncrementalCacheImpl.this.baseDir, Companion.getPROTO_MAP()), (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)ByteArrayExternalizer.INSTANCE$);
        }

        public final boolean put(@JetValueParameter(name="className") @NotNull JvmClassName className, @JetValueParameter(name="data") @NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            String key = className.getInternalName();
            byte[] oldData = (byte[])this.getStorage().get((Object)key);
            if (Arrays.equals(data, oldData)) {
                return false;
            }
            this.getStorage().put((Object)key, (Object)data);
            return true;
        }

        @Nullable
        public final byte[] get(@JetValueParameter(name="className") @NotNull JvmClassName className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            return (byte[])this.getStorage().get((Object)className.getInternalName());
        }

        public final void remove(@JetValueParameter(name="className") @NotNull JvmClassName className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            this.getStorage().remove((Object)className.getInternalName());
        }

        @Override
        @NotNull
        protected String dumpValue(@JetValueParameter(name="value") @NotNull byte[] value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            String string = Long.toHexString(IncrementalPackage$IncrementalCacheImpl$6579148b.md5(value));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Long.toHexString(value.md5())");
            return string;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"E\u0006)a1i\u001c8ti\u0006tGo]'ba*!\u0012J\\2sK6,g\u000e^1m\u0007\u0006\u001c\u0007.Z%na2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004UB\u001c(bC5oGJ,W.\u001a8uC2T\u0001BQ1tS\u000el\u0015\r\u001d\u0006\u0004\u001b\u0006\u0004(BB*ue&twMC\u0002B]fTa\u0001P5oSRt$\"C2sK\u0006$X-T1q\u0015E\u0001VM]:jgR,g\u000e\u001e%bg\"l\u0015\r\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\tU$\u0018\u000e\u001c\u0006\u0003S>T\u0011\u0002Z;naZ\u000bG.^3\u000b\u000bY\fG.^3\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\bhKR\u001cuN\\:uC:$8/T1q\u0015\u0015\u0011\u0017\u0010^3t\u0015%\u0011\u0015\u0010^3BeJ\f\u0017PC\u0004qe>\u001cWm]:\u000b\u0013\rd\u0017m]:OC6,'\u0002\u0004&w[\u000ec\u0017m]:OC6,'b\u0002:fg>dg/\u001a\u0006\u0004UZl'b\u0002\"p_2,\u0017M\u001c\u0006\u0004aV$(\u0002D2p]N$\u0018M\u001c;t\u001b\u0006\u0004(B\u0002:f[>4XM\u0003\u0003V]&$\b:\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0019AQ\u0001E\u0004\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011!\u0001\u0002\u0002\u0007\u0001\u000b\r!A\u0001#\u0003\r\u0001\u0015\u0019A\u0001\u0002\u0005\u0006\u0019\u0001)!\u0001\u0002\u0002\t\u0002\u0015\t\u0001bB\u0003\u0003\t\u001bAy!\u0002\u0002\u0005\u000f!AQA\u0001C\b\u0011#)1\u0001\u0002\u0005\t\u000e1\u0001QA\u0001\u0003\t\u0011\u001b)\u0011\u0001\u0003\u0006\u0006\u0005\u0011M\u0001RC\u0003\u0003\t)AI!\u0002\u0002\u0005\u0014!AQA\u0001\u0003\f\u0011\u0011)1\u0001\u0002\u0003\t\u00191\u0001QA\u0001\u0003\u0002\u00119)!\u0001\"\u0007\t\u001e\u0015\u0019A!\u0004E\u000e\u0019\u0001)1\u0001\u0002\u0003\t\u001f1\u0001QA\u0001\u0003\u000e\u00117)1\u0001\u0002\u0003\t#1\u0001A!\u0011\u0002\r\u0007eqQ!\u0001E\u0004\u0013-I!\"B\u0001\t\n%\u0019\u0011BA\u0003\u0002\u0011\u0015I1!\u0003\u0002\u0006\u0003!-Q6\u0007\u0003\u000b1\u0019\t##B\u0001\t\u0012%\u0019\u0011BA\u0003\u0002\u0011\u0015I1\"\u0003\u0006\u0006\u0003!%\u0011bA\u0005\u0003\u000b\u0005AQ!C\u0002\n\u0005\u0015\t\u00012B)\u0004\u0007\u00111\u0011\"\u0001\u0005\n[m!!\u0002G\u0005\u001e\u001e\u0011\u0001\u00012C\u0007\u000b\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001\"B\u0005\u0004\u0013\t)\u0011\u0001c\u0003Q\u0007\u0001\t#!B\u0001\t\u000bE\u001bQ\u0001B\u0005\n\u0003!UQ\"\u0001E\f[u!\u0011\u0001G\u0006\u001e\u000e\u0011\u0001\u0001rC\u0007\u0003\u000b\u0005AA\u0002U\u0002\u0001C-)\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001\u0005\u0006\u0013\rI!!B\u0001\t\f1\u0005\u0011k\u0001\u0004\u0005\u0017%\t\u0001rC\u0007\u0003\t\u0007a\t!l\u000f\u0005\u0007aeQT\u0002\u0003\u0001\u00115i!!B\u0001\t\u001cA\u001b\u0001!(\u0004\u0005\u0001!]QBA\u0003\u0002\u00111\u00016\u0011A\u0011\u0003\u000b\u0005Aa\"U\u0002\t\t3I\u0011\u0001\"\u0001\u000e\u0003!uQB\u0001C\u0002\u0019\u0003i[\u0005B\u0001\u0019 u5A\u0001\u0001\u0005\u000e\u001b\t)\u0011\u0001c\u0007Q\u0007\u0001iz\u0002\u0002\u0001\t!5YQ!\u0001E\u0005\u0013\rI!!B\u0001\t\u000b%\u0019\u0011BA\u0003\u0002\u0011\u0017a\t\u0001UB\u0001C\t)\u0011\u0001\u0003\bR\u0007\u001d!y\"C\u0001\u0005\u00025\t\u0001RD\u0007\u0002\u0011/i3\u0003B\u0002\u0019\"u5A\u0001\u0001\u0005\u000e\u001b\t)\u0011\u0001c\u0007Q\u0007\u0001\t#!B\u0001\t\u001fE\u001bQ\u0001\"\t\n\u0003\u0011\u0001Q\"\u0001E\u000fk5)A\u0002Br\u00011\u0017\t#!B\u0001\t\u0007E\u001bQ\u0001b\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\u0007"})
    private final class ConstantsMap
    extends BasicMap<Map<String, ? extends Object>> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(ConstantsMap.class);
        }

        @Override
        @NotNull
        protected PersistentHashMap<String, Map<String, ? extends Object>> createMap() {
            return new PersistentHashMap(new File(IncrementalCacheImpl.this.baseDir, Companion.getCONSTANTS_MAP()), (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)ConstantsMapExternalizer.INSTANCE$);
        }

        private final Map<String, Object> getConstantsMap(@JetValueParameter(name="bytes") byte[] bytes) {
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result, Opcodes.ASM5){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ HashMap $result;

                static {
                    $kotlinClass = Reflection.createKotlinClass(getConstantsMap.1.class);
                }

                @Nullable
                public FieldVisitor visitField(@JetValueParameter(name="access") int access, @JetValueParameter(name="name") @NotNull String name, @JetValueParameter(name="desc") @NotNull String desc, @JetValueParameter(name="signature", type="?") @Nullable String signature, @JetValueParameter(name="value", type="?") @Nullable Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    int staticFinal = Opcodes.ACC_STATIC | Opcodes.ACC_FINAL;
                    if (value != null && (access & staticFinal) == staticFinal) {
                        KotlinPackage.set((Map)this.$result, (Object)name, (Object)value);
                    }
                    return null;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, ClassReader.SKIP_CODE | ClassReader.SKIP_DEBUG | ClassReader.SKIP_FRAMES);
            return result.isEmpty() ? (HashMap)null : result;
        }

        public final boolean process(@JetValueParameter(name="className") @NotNull JvmClassName className, @JetValueParameter(name="bytes") @NotNull byte[] bytes) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            return this.put(className, this.getConstantsMap(bytes));
        }

        private final boolean put(@JetValueParameter(name="className") JvmClassName className, @JetValueParameter(name="constantsMap", type="?") Map<String, ? extends Object> constantsMap) {
            String key = className.getInternalName();
            Map oldMap = (Map)this.getStorage().get((Object)key);
            if (Intrinsics.areEqual((Object)oldMap, constantsMap)) {
                return false;
            }
            if (constantsMap != null) {
                this.getStorage().put((Object)key, constantsMap);
            } else {
                this.getStorage().remove((Object)key);
            }
            return true;
        }

        public final void remove(@JetValueParameter(name="className") @NotNull JvmClassName className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            this.put(className, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected String dumpValue(@JetValueParameter(name="value") @NotNull Map<String, ? extends Object> value) {
            void var2_2;
            StringBuilder sb;
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            StringBuilder $receiver = sb = new StringBuilder();
            $receiver.append("{");
            for (String key : KotlinPackage.sort((Iterable)value.keySet())) {
                if ($receiver.length() != 1) {
                    $receiver.append(", ");
                }
                $receiver.append(key + " -> " + value.get(key));
            }
            $receiver.append("}");
            String string = var2_2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder {\n        \u2026\n            }.toString()");
            return string;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"[\u0004)A2i\u001c8ti\u0006tGo]'ba\u0016CH/\u001a:oC2L'0\u001a:\u000b)%s7M]3nK:$\u0018\r\\\"bG\",\u0017*\u001c9m\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u00016qg*Y\u0011N\\2sK6,g\u000e^1m\u0015A!\u0015\r^1FqR,'O\\1mSj,'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0005kRLGN\u0003\u0002j_*\u0019Q*\u00199\u000b\rM#(/\u001b8h\u0015\r\te.\u001f\u0006\u0005e\u0016\fGM\u0003\u0002j]*IA)\u0019;b\u0013:\u0004X\u000f\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003tCZ,'bA8vi*QA)\u0019;b\u001fV$\b/\u001e;\u000b\u00075\f\u0007O\u0003\u0003V]&$(\u0002B&j]\u0012\u0004\u001bA\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\tA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005AA!\u0002\u0002\u0005\b!%QA\u0001\u0003\u0005\u0011\u0015)!\u0001\"\u0003\t\f\u0015\u0019A!\u0002E\u0004\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u00111\u0001B\u0002\u0007\u0001\u000b\r!a\u0001#\u0004\r\u0001\u0015\u0019AA\u0002\u0005\b\u0019\u0001)\u0011\u0001C\u0005\u0006\u0005\u0011A\u00012B\u0003\u0004\t#A\t\u0002\u0004\u0001\u0006\u0005\u0011A\u0001\"B\u0003\u0003\t'Aa!\u0002\u0002\u0005\u0012!EQa\u0001C\t\u0011+a\u0001!B\u0002\u0005\r!]A\u0002A\u0003\u0003\t#A)\u0002B1\u0002\u0019\rIb\"B\u0001\t\f%Y\u0011BC\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!9\u0011bA\u0005\u0003\u000b\u0005Ay\u0001\b\u0007.9\u0011Y\u0001tBO\u0007\t\u0001A\u0001\"\u0004\u0002\u0006\u0003!I\u0001k\u0001\u0001\"\u0017\u0015\t\u0001RB\u0005\u0004\u0013\t)\u0011\u0001C\u0004\n\u0007%\u0011Q!\u0001E\b\u0019\u0003\t6!\u0002C\b\u0013\u0005A!\"D\u0001\t\u00165.Ca\u0003M\n;\u001b!\u0001\u0001\u0003\u0006\u000e\u0005\u0015\t\u0001b\u0003)\u0004\u0001u}A\u0001\u0001\u0005\f\u001b-)\u0011\u0001#\u0004\n\u0007%\u0011Q!\u0001\u0005\b\u0013\rI!!B\u0001\t\u00101\u0005\u0001k!\u0001\"\u0005\u0015\t\u0001rC)\u0004\u000f\u0011M\u0011\"\u0001\u0003\u0001\u001b\u0005AA\"D\u0001\t\u0015U\u0002\u0001"})
    private static final class ConstantsMapExternalizer
    implements DataExternalizer<Map<String, ? extends Object>> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final ConstantsMapExternalizer INSTANCE$;

        static {
            $kotlinClass = Reflection.createKotlinClass(ConstantsMapExternalizer.class);
            new ConstantsMapExternalizer();
        }

        public void save(@JetValueParameter(name="out") @NotNull DataOutput out, @JetValueParameter(name="map", type="?") @Nullable Map<String, ? extends Object> map) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Map<String, ? extends Object> map2 = map;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            out.writeInt(map2.size());
            for (String name : KotlinPackage.toSortedList((Iterable)map.keySet())) {
                Object value;
                Object object;
                IOUtil.writeString((String)name, (DataOutput)out);
                if (map.get(name) == null) {
                    Intrinsics.throwNpe();
                }
                if ((object = value) instanceof Integer) {
                    out.writeByte(Kind.INT.ordinal());
                    out.writeInt(((Number)value).intValue());
                    continue;
                }
                if (object instanceof Float) {
                    out.writeByte(Kind.FLOAT.ordinal());
                    out.writeFloat(((Number)value).floatValue());
                    continue;
                }
                if (object instanceof Long) {
                    out.writeByte(Kind.LONG.ordinal());
                    out.writeLong(((Number)value).longValue());
                    continue;
                }
                if (object instanceof Double) {
                    out.writeByte(Kind.DOUBLE.ordinal());
                    out.writeDouble(((Number)value).doubleValue());
                    continue;
                }
                if (object instanceof String) {
                    out.writeByte(Kind.STRING.ordinal());
                    IOUtil.writeString((String)((String)value), (DataOutput)out);
                    continue;
                }
                throw (Throwable)new IllegalStateException("Unexpected constant class: " + value.getClass());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Map<String, Object> read(@JetValueParameter(name="in") @NotNull DataInput in) {
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            int size = in.readInt();
            HashMap map = new HashMap(size);
            IntRange intRange = KotlinPackage.getIndices((int)size);
            int n = ((Number)intRange.getStart()).intValue();
            int n2 = ((Number)intRange.getEnd()).intValue();
            if (n <= n2) {
                while (true) {
                    void i;
                    String name;
                    Comparable<Integer> comparable;
                    if (IOUtil.readString((DataInput)in) == null) {
                        Intrinsics.throwNpe();
                    }
                    Kind kind = Kind.values()[in.readByte()];
                    switch (IncrementalCacheImpl$ConstantsMapExternalizer$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                        case 1: {
                            comparable = in.readInt();
                            break;
                        }
                        case 2: {
                            comparable = Float.valueOf(in.readFloat());
                            break;
                        }
                        case 3: {
                            comparable = in.readLong();
                            break;
                        }
                        case 4: {
                            comparable = in.readDouble();
                            break;
                        }
                        case 5: {
                            String string = IOUtil.readString((DataInput)in);
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            comparable = (Comparable)((Object)string);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    Number value = comparable;
                    KotlinPackage.set((Map)map, (Object)name, (Object)value);
                    if (i == n2) break;
                    ++i;
                }
            }
            return map;
        }

        ConstantsMapExternalizer() {
            INSTANCE$ = this;
        }

        @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"%\u0004)!1*\u001b8e\u0015a\u0019uN\\:uC:$8/T1q\u000bb$XM\u001d8bY&TXM\u001d\u0006\u0015\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015-Ign\u0019:f[\u0016tG/\u00197\u000b\t\u0015sW/\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0004TiJLgn\u001a\u0006\u0004\u0013:#&\"\u0002$M\u001f\u0006#&\u0002\u0002'P\u001d\u001eSa\u0001R(V\u00052+%BB*U%&su\t\u0015\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0011A!\u0001\u0005\u0004\u000b\t!\u0019\u0001c\u0002\u0006\u0007\u0011\u0011\u0001\"\u0001\u0007\u0001\u000b\r!)\u0001#\u0001\r\u0001\u0015\u0019Aa\u0001\u0005\u0001\u0019\u0001)\u0011\u0001#\u0002\u0006\u0007\u0011!\u0001\u0002\u0002\u0007\u0001\u000b\u0005AQ!\u0002\u0002\u0005\u000b!-QA\u0001C\u0006\u0011\u0019!\u0011\u0019\u0001G\u00043\u0019)\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001E\u0004a\u001b\u0001t\u0001m\u00041\u0011AFQgD\u0003\u000f\t\u0005\b\u0001\u0014B\u0011\u0003\u000b\u0005A9!U\u0002\b\t\u0013I\u0011\u0001\u0002\u0001\u000e\u0003!1Q\"\u0001C\u0003"})
        private static final class Kind
        extends Enum<Kind> {
            public static final /* synthetic */ KClass $kotlinClass;
            public static final /* enum */ Kind INT;
            public static final /* enum */ Kind FLOAT;
            public static final /* enum */ Kind LONG;
            public static final /* enum */ Kind DOUBLE;
            public static final /* enum */ Kind STRING;
            private static final /* synthetic */ Kind[] $VALUES;

            static {
                $kotlinClass = Reflection.createKotlinClass(Kind.class);
                Kind[] kindArray = new Kind[5];
                Kind[] kindArray2 = kindArray;
                kindArray[0] = INT = new Kind();
                kindArray[1] = FLOAT = new Kind();
                kindArray[2] = LONG = new Kind();
                kindArray[3] = DOUBLE = new Kind();
                kindArray[4] = STRING = new Kind();
                $VALUES = kindArray;
            }

            public static Kind[] values() {
                return (Kind[])$VALUES.clone();
            }

            public static Kind valueOf(String string) {
                return Enum.valueOf(Kind.class, string);
            }
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"X\u0006)\u0011\u0012J\u001c7j]\u00164UO\\2uS>t7/T1q\u0015QIen\u0019:f[\u0016tG/\u00197DC\u000eDW-S7qY*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0002kaNT1\"\u001b8de\u0016lWM\u001c;bY*A!)Y:jG6\u000b\u0007OC\u0002NCBTaa\u0015;sS:<'\u0002\u0002'p]\u001eTa\u0001P5oSRt$\"C2sK\u0006$X-T1q\u0015E\u0001VM]:jgR,g\u000e\u001e%bg\"l\u0015\r\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\tU$\u0018\u000e\u001c\u0006\u0003S>T\u0011\u0002Z;naZ\u000bG.^3\u000b\u000bY\fG.^3\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\u000bhKRLe\u000e\\5oK\u001a+hn\u0019;j_:\u001cX*\u00199\u000b\u000b\tLH/Z:\u000b\u0013\tKH/Z!se\u0006L(b\u00029s_\u000e,7o\u001d\u0006\nG2\f7o\u001d(b[\u0016TAB\u0013<n\u00072\f7o\u001d(b[\u0016TqA]3t_24XMC\u0002km6TqAQ8pY\u0016\fgNC\u0002qkRT!#\u001b8mS:,g)\u001e8di&|gn]'ba*1!/Z7pm\u0016TA!\u00168ji\"\u000f!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001r\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\t!!A\u0002A\u0003\u0004\t\u0011AI\u0001\u0004\u0001\u0006\u0007\u0011!\u0001\"\u0002\u0007\u0001\u000b\t!!\u0001#\u0001\u0006\u0003!9QA\u0001C\u0007\u0011\u001f)!\u0001B\u0004\t\u0011\u0015\u0011Aq\u0002E\t\u000b\r!\u0001\u0002#\u0004\r\u0001\u0015\u0011A\u0001\u0003E\u0007\u000b\u0005A!\"\u0002\u0002\u0005\u0014!UQA\u0001\u0003\u000b\u0011\u0013)!\u0001b\u0005\t\u0011\u0015\u0011Aa\u0003\u0005\u0005\u000b\r!A\u0001\u0003\u0007\r\u0001\u0015\u0011A!\u0001\u0005\u000f\u000b\t!I\u0002#\b\u0006\u0007\u0011i\u00012\u0004\u0007\u0001\u000b\r!A\u0001C\b\r\u0001\u0015\u0011A!\u0004E\u000e\u000b\r!A\u0001C\t\r\u0001\u0011\t%\u0001D\u0002\u001a\u001d\u0015\t\u0001rA\u0005\f\u0013))\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001\u0005\u0006\u0013\rI!!B\u0001\t\f5NBA\u0003\r\u0007CI)\u0011\u0001#\u0005\n\u0007%\u0011Q!\u0001\u0005\u0006\u0013-I!\"B\u0001\t\n%\u0019\u0011BA\u0003\u0002\u0011\u0015I1!\u0003\u0002\u0006\u0003!-\u0011kA\u0002\u0005\r%\t\u0001\"C\u0017\u001c\t)A\u0012\"(\b\u0005\u0001!MQBC\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!)\u0011bA\u0005\u0003\u000b\u0005AY\u0001U\u0002\u0001C\t)\u0011\u0001C\u0003R\u0007\u0015!\u0011\"C\u0001\t\u00165\t\u0001rC\u0017\u001e\t\u0005A2\"(\u0004\u0005\u0001!]QBA\u0003\u0002\u00111\u00016\u0001A\u0011\f\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001\"B\u0005\u0004\u0013\t)\u0011\u0001c\u0003\r\u0002E\u001ba\u0001B\u0006\n\u0003!]QB\u0001C\u0002\u0019\u0003i[\u0004B\u0002\u0019\u001au5A\u0001\u0001\u0005\u000e\u001b\t)\u0011\u0001c\u0007Q\u0007\u0001ij\u0001\u0002\u0001\t\u00185\u0011Q!\u0001\u0005\r!\u000e\u0005\u0011EA\u0003\u0002\u00119\t6\u0001\u0003C\r\u0013\u0005!\t!D\u0001\t\u001e5\u0011A1\u0001G\u0001[\u0017\"\u0011\u0001g\b\u001e\u000e\u0011\u0001\u0001\"D\u0007\u0003\u000b\u0005AY\u0002U\u0002\u0001;?!\u0001\u0001\u0003\t\u000e\u0017\u0015\t\u0001\u0012B\u0005\u0004\u0013\t)\u0011\u0001C\u0003\n\u0007%\u0011Q!\u0001E\u0006\u0019\u0003\u00016\u0011A\u0011\u0003\u000b\u0005Aa\"U\u0002\b\t?I\u0011\u0001\"\u0001\u000e\u0003!uQ\"\u0001E\f[M!1\u0001'\t\u001e\u000e\u0011\u0001\u0001\"D\u0007\u0003\u000b\u0005AY\u0002U\u0002\u0001C\t)\u0011\u0001C\bR\u0007\u0015!\t#C\u0001\u0005\u00015\t\u0001RD\u001b\u000e\u000b1!1\u001d\u0001M\u0006C\t)\u0011\u0001C\u0002R\u0007\u0015!Y!C\u0001\u0005\u00015\t\u0001B\u0002"})
    private final class InlineFunctionsMap
    extends BasicMap<Map<String, ? extends Long>> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(InlineFunctionsMap.class);
        }

        @Override
        @NotNull
        protected PersistentHashMap<String, Map<String, ? extends Long>> createMap() {
            return new PersistentHashMap(new File(IncrementalCacheImpl.this.baseDir, Companion.getINLINE_FUNCTIONS()), (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)InlineFunctionsMapExternalizer.INSTANCE$);
        }

        private final Map<String, Long> getInlineFunctionsMap(@JetValueParameter(name="bytes") byte[] bytes) {
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result, Opcodes.ASM5){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ HashMap $result;

                static {
                    $kotlinClass = Reflection.createKotlinClass(getInlineFunctionsMap.1.class);
                }

                @Nullable
                public MethodVisitor visitMethod(@JetValueParameter(name="access") int access, @JetValueParameter(name="name") @NotNull String name, @JetValueParameter(name="desc") @NotNull String desc, @JetValueParameter(name="signature", type="?") @Nullable String signature, @JetValueParameter(name="exceptions", type="?") @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    ClassWriter dummyClassWriter = new ClassWriter(Opcodes.ASM5);
                    return new MethodVisitor(this, dummyClassWriter, name, desc, Opcodes.ASM5, dummyClassWriter.visitMethod(0, name, desc, (String)null, exceptions)){
                        public static final /* synthetic */ KClass $kotlinClass;
                        private boolean hasInlineAnnotation;
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ ClassWriter $dummyClassWriter;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;

                        static {
                            $kotlinClass = Reflection.createKotlinClass(getInlineFunctionsMap.visitMethod.1.class);
                        }

                        public final boolean getHasInlineAnnotation() {
                            return this.hasInlineAnnotation;
                        }

                        public final void setHasInlineAnnotation(@JetValueParameter(name="<set-?>") boolean bl) {
                            this.hasInlineAnnotation = bl;
                        }

                        @Nullable
                        public AnnotationVisitor visitAnnotation(@JetValueParameter(name="desc") @NotNull String desc, @JetValueParameter(name="visible") boolean visible) {
                            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                            if (Intrinsics.areEqual((Object)desc, (Object)IncrementalPackage$IncrementalCacheImpl$6579148b.getINLINE_ANNOTATION_DESC())) {
                                this.hasInlineAnnotation = true;
                            }
                            return null;
                        }

                        public void visitEnd() {
                            if (this.hasInlineAnnotation) {
                                byte[] byArray = this.$dummyClassWriter.toByteArray();
                                if (byArray == null) {
                                    Intrinsics.throwNpe();
                                }
                                byte[] dummyBytes = byArray;
                                long hash = IncrementalPackage$IncrementalCacheImpl$6579148b.md5(dummyBytes);
                                KotlinPackage.set((Map)this.this$0.$result, (Object)(this.$name + this.$desc), (Object)hash);
                            }
                        }
                        {
                            this.this$0 = $outer;
                            this.$dummyClassWriter = $captured_local_variable$1;
                            this.$name = $captured_local_variable$2;
                            this.$desc = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5);
                        }
                    };
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, 0);
            return result.isEmpty() ? (HashMap)null : result;
        }

        public final boolean process(@JetValueParameter(name="className") @NotNull JvmClassName className, @JetValueParameter(name="bytes") @NotNull byte[] bytes) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            return this.put(className, this.getInlineFunctionsMap(bytes));
        }

        private final boolean put(@JetValueParameter(name="className") JvmClassName className, @JetValueParameter(name="inlineFunctionsMap", type="?") Map<String, ? extends Long> inlineFunctionsMap) {
            String key = className.getInternalName();
            Map oldMap = (Map)this.getStorage().get((Object)key);
            if (Intrinsics.areEqual((Object)oldMap, inlineFunctionsMap)) {
                return false;
            }
            if (inlineFunctionsMap != null) {
                this.getStorage().put((Object)key, inlineFunctionsMap);
            } else {
                this.getStorage().remove((Object)key);
            }
            return true;
        }

        public final void remove(@JetValueParameter(name="className") @NotNull JvmClassName className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            this.put(className, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected String dumpValue(@JetValueParameter(name="value") @NotNull Map<String, ? extends Long> value) {
            void var2_2;
            StringBuilder sb;
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            StringBuilder $receiver = sb = new StringBuilder();
            $receiver.append("{");
            for (String key : KotlinPackage.sort((Iterable)value.keySet())) {
                if ($receiver.length() != 1) {
                    $receiver.append(", ");
                }
                StringBuilder stringBuilder = new StringBuilder().append(key).append(" -> ");
                Long l = value.get(key);
                if (l == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.append(stringBuilder.append(Long.toHexString(((Number)l).longValue())).toString());
            }
            $receiver.append("}");
            String string = var2_2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder {\n        \u2026\n            }.toString()");
            return string;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\\\u0004)q\u0012J\u001c7j]\u00164UO\\2uS>t7/T1q\u000bb$XM\u001d8bY&TXM\u001d\u0006\u0015\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015-Ign\u0019:f[\u0016tG/\u00197\u000b!\u0011\u000bG/Y#yi\u0016\u0014h.\u00197ju\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'N\u0003\u0003vi&d'BA5p\u0015\ri\u0015\r\u001d\u0006\u0007'R\u0014\u0018N\\4\u000b\t1{gn\u001a\u0006\u0005e\u0016\fGM\u0003\u0002j]*IA)\u0019;b\u0013:\u0004X\u000f\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003tCZ,'bA8vi*QA)\u0019;b\u001fV$\b/\u001e;\u000b\u00075\f\u0007O\u0003\u0003V]&$\b5\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001\u0002B\u0003\u0003\t\u000fAI!\u0002\u0002\u0005\t!)QA\u0001C\u0005\u0011\u0017)1\u0001B\u0003\t\b1\u0001Q!\u0001\u0005\u0003\u000b\r!a\u0001\u0003\u0004\r\u0001\u0015\u0019AA\u0002E\u0007\u0019\u0001)1\u0001\u0002\u0004\t\u000f1\u0001Q!\u0001\u0005\n\u000b\t!\u0001\u0002c\u0003\u0006\u0007\u0011E\u0001\u0012\u0003\u0007\u0001\u000b\t!\u0001\u0002C\u0003\u0006\u0005\u0011M\u0001BB\u0003\u0003\t#A\t\"B\u0002\u0005\u0012!UA\u0002A\u0003\u0004\t\u0019A9\u0002\u0004\u0001\u0006\u0005\u0011E\u0001R\u0003\u0003b\u00031\u0019\u0011DD\u0003\u0002\u0011\u0017I1\"\u0003\u0006\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005Aq!C\u0002\n\u0005\u0015\t\u0001rB\u0017\u001d\t-Az!(\u0004\u0005\u0001!AQBA\u0003\u0002\u0011%\u00016\u0001A\u0011\f\u000b\u0005Ai!C\u0002\n\u0005\u0015\t\u0001bB\u0005\u0004\u0013\t)\u0011\u0001c\u0004\r\u0002E\u001bQ\u0001b\u0004\n\u0003!QQ\"\u0001E\u000b[\u0017\"1\u0002g\u0005\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A1\u0002U\u0002\u0001;?!\u0001\u0001C\u0006\u000e\u0017\u0015\t\u0001RB\u0005\u0004\u0013\t)\u0011\u0001C\u0004\n\u0007%\u0011Q!\u0001E\b\u0019\u0003\u00016\u0011A\u0011\u0003\u000b\u0005A9\"U\u0002\b\t'I\u0011\u0001\u0002\u0001\u000e\u0003!aQ\"\u0001\u0005\u000bk\u0001\u0001"})
    private static final class InlineFunctionsMapExternalizer
    implements DataExternalizer<Map<String, ? extends Long>> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final InlineFunctionsMapExternalizer INSTANCE$;

        static {
            $kotlinClass = Reflection.createKotlinClass(InlineFunctionsMapExternalizer.class);
            new InlineFunctionsMapExternalizer();
        }

        public void save(@JetValueParameter(name="out") @NotNull DataOutput out, @JetValueParameter(name="map", type="?") @Nullable Map<String, ? extends Long> map) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Map<String, ? extends Long> map2 = map;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            out.writeInt(map2.size());
            for (String name : map.keySet()) {
                IOUtil.writeString((String)name, (DataOutput)out);
                Long l = map.get(name);
                if (l == null) {
                    Intrinsics.throwNpe();
                }
                out.writeLong(((Number)l).longValue());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Map<String, Long> read(@JetValueParameter(name="in") @NotNull DataInput in) {
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            int size = in.readInt();
            HashMap map = new HashMap(size);
            IntRange intRange = KotlinPackage.getIndices((int)size);
            int n = ((Number)intRange.getStart()).intValue();
            int n2 = ((Number)intRange.getEnd()).intValue();
            if (n <= n2) {
                while (true) {
                    void i;
                    String name;
                    if (IOUtil.readString((DataInput)in) == null) {
                        Intrinsics.throwNpe();
                    }
                    long value = in.readLong();
                    KotlinPackage.set((Map)map, (Object)name, (Object)value);
                    if (i == n2) break;
                    ++i;
                }
            }
            return map;
        }

        InlineFunctionsMapExternalizer() {
            INSTANCE$ = this;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u001d\u0006)q\u0001+Y2lC\u001e,\u0007+\u0019:u\u001b\u0006\u0004(\u0002F%oGJ,W.\u001a8uC2\u001c\u0015m\u00195f\u00136\u0004HNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\rQ\u0007o\u001d\u0006\fS:\u001c'/Z7f]R\fGN\u0003\u0005CCNL7-T1q\u0015\u001d\u0011un\u001c7fC:Ta\u0001P5oSRt$BD1eIB\u000b7m[1hKB\u000b'\u000f\u001e\u0006\nG2\f7o\u001d(b[\u0016TAB\u0013<n\u00072\f7o\u001d(b[\u0016TqA]3t_24XMC\u0002km6TA!\u00168ji*I1M]3bi\u0016l\u0015\r\u001d\u0006\u0012!\u0016\u00148/[:uK:$\b*Y:i\u001b\u0006\u0004(bA2p[*A\u0011N\u001c;fY2L'N\u0003\u0003vi&d'BA5p\u0015\u0019\u0019FO]5oO*IA-^7q-\u0006dW/\u001a\u0006\u0006m\u0006dW/\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\"D5t!\u0006\u001c7.Y4f!\u0006\u0014HO\u0003\u0004sK6|g/\u001aS\u0002\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0019AA\u0001E\u0001\u0019\u0001)1\u0001\"\u0002\t\u00011\u0001Qa\u0001C\u0003\u0011\u000fa\u0001!B\u0001\t\u0005\u0015\u0019A\u0001\u0002\u0005\u0005\u0019\u0001)!\u0001\u0002\u0002\t\u0002\u0015\u0011A!\u0001E\u0007\u000b\t!Y\u0001C\u0004\u0006\u0007\u00111\u0001B\u0002\u0007\u0001\u000b\r!A\u0001c\u0004\r\u0001\u0015\u0011AA\u0002\u0005\u0007\u000b\u0005A\u0011\"\u0002\u0002\u0005\u0011!MQA\u0001C\t\u0011))!\u0001B\u0005\t\u0016\u0015\u0019A1\u0003E\t\u0019\u0001)1\u0001\u0002\u0003\t\u00171\u0001QA\u0001C\n\u0011#)\u0011\u0001#\u0007\u0006\u0005\u0011]\u0001\"D\u0003\u0003\t1A1\u0002B!\u0003\u0019\rIb!B\u0001\t\b%\u0019\u0011BA\u0003\u0002\u0011\u0013i3\u0003B\u0002\u0019\u000bu5A\u0001\u0001E\u0006\u001b\t)\u0011\u0001#\u0004Q\u0007\u0001\t#!B\u0001\t\u000fE\u001bQ\u0001B\u0003\n\u0003\u0011\u0001Q\"\u0001E\b[G!!\u0002\u0007\u0005\"\u0015\u0015\t\u0001BC\u0005\u0004\u0013\t)\u0011\u0001#\u0006\n\u0007%\u0011Q!\u0001E\u0005#\u000e\u0019A\u0001C\u0005\u0002\u0011-i3\u0003\u0002\u0006\u0019\u0018u5A\u0001\u0001\u0005\r\u001b\t)\u0011\u0001#\u0003Q\u0007\u0001\t#!B\u0001\t\u0016E\u001bQ\u0001b\u0006\n\u0003!eQ\"\u0001C\u0001[M!1\u0001g\u0007\u001e\u000e\u0011\u0001\u00012B\u0007\u0003\u000b\u0005Ai\u0001U\u0002\u0001C\t)\u0011\u0001#\u0003R\u0007\u0015!Y\"C\u0001\u0005\u00025\t\u0001rB\u0017\u0014\t\rAb\"(\u0004\u0005\u0001!-QBA\u0003\u0002\u0011\u001b\u00016\u0001A\u0011\u0003\u000b\u0005Aq!U\u0002\u0006\t9I\u0011\u0001\u0002\u0001\u000e\u0003!=Q'D\u0003\r\t\r\b\u0001\u0014B\u0011\u0003\u000b\u0005A1!U\u0002\u0006\t\u0013I\u0011\u0001\u0002\u0001\u000e\u0003!)\u0001"})
    private final class PackagePartMap
    extends BasicMap<Boolean> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(PackagePartMap.class);
        }

        @Override
        @NotNull
        protected PersistentHashMap<String, Boolean> createMap() {
            return new PersistentHashMap(new File(IncrementalCacheImpl.this.baseDir, Companion.getPACKAGE_PARTS()), (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)BooleanDataDescriptor.INSTANCE);
        }

        public final void addPackagePart(@JetValueParameter(name="className") @NotNull JvmClassName className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            this.getStorage().put((Object)className.getInternalName(), (Object)true);
        }

        public final void remove(@JetValueParameter(name="className") @NotNull JvmClassName className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            this.getStorage().remove((Object)className.getInternalName());
        }

        public final boolean isPackagePart(@JetValueParameter(name="className") @NotNull JvmClassName className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            return this.getStorage().containsMapping((Object)className.getInternalName());
        }

        @Override
        @NotNull
        protected String dumpValue(@JetValueParameter(name="value") boolean value) {
            return "";
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"C\u0006)\u00112k\\;sG\u0016$vn\u00117bgN,7/T1q\u0015QIen\u0019:f[\u0016tG/\u00197DC\u000eDW-S7qY*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0002kaNT1\"\u001b8de\u0016lWM\u001c;bY*A!)Y:jG6\u000b\u0007O\u0003\u0003MSN$(BB*ue&twM\u0003\u0004=S:LGO\u0010\u0006\u0011C\u0012$7k\\;sG\u0016$vn\u00117bgNT!b]8ve\u000e,g)\u001b7f\u0015\u00111\u0015\u000e\\3\u000b\t)\fg/\u0019\u0006\u0003S>T\u0011b\u00197bgNt\u0015-\\3\u000b\u0019)3Xn\u00117bgNt\u0015-\\3\u000b\u000fI,7o\u001c7wK*\u0019!N^7\u000b\tUs\u0017\u000e\u001e\u0006\u0016G2,\u0017M](viB,Ho\u001d$peN{WO]2f\u0015%\u0019'/Z1uK6\u000b\u0007OC\tQKJ\u001c\u0018n\u001d;f]RD\u0015m\u001d5NCBT1aY8n\u0015!Ig\u000e^3mY&T'\u0002B;uS2T\u0011\u0002Z;naZ\u000bG.^3\u000b\u000bY\fG.^3\u000b\t1\fgn\u001a\u0006\u0004O\u0016$(BC\"pY2,7\r^5p]J\u000f!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001r\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\t!!A\u0002A\u0003\u0004\t\u0011AI\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0012A\u0003\u0002\u0011\u001d)!\u0001\u0002\u0004\t\u0010\u0015\u0019AQ\u0002E\u0007\u0019\u0001)!\u0001B\u0001\t\u0013\u0015\u0011Aq\u0002E\n\u000b\r!\u0001\u0002#\u0005\r\u0001\u0015\u0019A\u0001\u0002\u0005\u000b\u0019\u0001)!\u0001\"\u0004\t\u000e\u0015\u0011A\u0001\u0003E\t\u000b\u0005AA\"\u0002\u0002\u0005\u0016!eQA\u0001\u0003\f\u00115)!\u0001b\u0006\t\u0010\u0015\u0019A\u0001\u0004E\f\u0019\u0001)!\u0001\u0002\u0007\t\u0018\u0015\u0011AA\u0002E\u000f\u000b\t!Y\u0002#\u0003\u0006\u0005\u00111\u0001\"D\u0003\u0003\t;AA!B\u0002\u0005\t!}A\u0002A\u0003\u0003\t;Ay\u0002B!\u0003\u0019\rI\"\"B\u0001\t\b%9\u0011BB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!)Q\u0016\b\u0003\u00041\u0017ij\u0001\u0002\u0001\t\r5\u0011Q!\u0001\u0005\b!\u000e\u0001QT\u0002\u0003\u0001\u0011!i!!B\u0001\t\u0012A\u001b\t!\t\u0002\u0006\u0003!I\u0011kA\u0004\u0005\f%\tA\u0001A\u0007\u0002\u0011'i\u0011\u0001\u0003\u0006.'\u0011\u0019\u0001TCO\u0007\t\u0001Aa!\u0004\u0002\u0006\u0003!9\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\"C)\u0004\u000b\u0011U\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0019\"l\u000b\u0005\u0015aY\u0011ED\u0003\u0002\u00113I1!\u0003\u0002\u0006\u0003!)\u0011bB\u0005\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001\"B)\u0004\u0007\u0011Y\u0011\"\u0001\u0005\u000e[]!!\u0002g\u0007\u001e\u0016\u0011\u0001\u0001BD\u0007\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001\"\u0002)\u0004\u0001\u0005\u0012Q!\u0001\u0005\u0006#\u000e)A1D\u0005\u0002\u00119i\u0011\u0001C\b./\u0011\u0019\u0001dDO\u0007\t\u0001Aa!\u0004\u0002\u0006\u0003!9\u0001k\u0001\u0001\"\r\u0015\t\u0001rD\u0005\u0004\u0013\t)\u0011\u0001#\u0005R\u0007\u0015!q\"C\u0001\t!5\t\u00012C\u001b\u000e\u000b1!1\u001d\u0001\r\u0006C\t)\u0011\u0001C\u0002R\u0007\u0015!Q!C\u0001\u0005\u00015\t\u00012\u0002"})
    private final class SourceToClassesMap
    extends BasicMap<List<? extends String>> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(SourceToClassesMap.class);
        }

        @Override
        @NotNull
        protected PersistentHashMap<String, List<? extends String>> createMap() {
            return new PersistentHashMap(new File(IncrementalCacheImpl.this.baseDir, Companion.getSOURCE_TO_CLASSES()), (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)StringListExternalizer.INSTANCE$);
        }

        public final void clearOutputsForSource(@JetValueParameter(name="sourceFile") @NotNull File sourceFile) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            this.getStorage().remove((Object)sourceFile.getAbsolutePath());
        }

        public final void addSourceToClass(@JetValueParameter(name="sourceFile") @NotNull File sourceFile, @JetValueParameter(name="className") @NotNull JvmClassName className) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            this.getStorage().appendData((Object)sourceFile.getAbsolutePath(), new PersistentHashMap.ValueDataAppender(className){
                final /* synthetic */ JvmClassName $className;

                public final void append(@JetValueParameter(name="out") DataOutput out) {
                    IOUtil.writeUTF((DataOutput)out, (String)this.$className.getInternalName());
                }
                {
                    this.$className = jvmClassName;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<JvmClassName> get(@JetValueParameter(name="sourceFile") @NotNull File sourceFile) {
            void destination;
            void $receiver;
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            Iterable $receiver2 = KotlinPackage.orEmpty((List)((List)this.getStorage().get((Object)sourceFile.getAbsolutePath())));
            Iterable iterable = $receiver2;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                String string = (String)item;
                void var8_8 = destination;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
                var8_8.add(jvmClassName);
            }
            return (List)destination;
        }

        @Override
        @NotNull
        protected String dumpValue(@JetValueParameter(name="value") @NotNull List<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return value.toString();
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={" \u0006))B)\u001b:us>+H\u000f];u\u00072\f7o]3t\u001b\u0006\u0004(\u0002F%oGJ,W.\u001a8uC2\u001c\u0015m\u00195f\u00136\u0004HNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\rQ\u0007o\u001d\u0006\fS:\u001c'/Z7f]R\fGN\u0003\u0005CCNL7-T1q\u0015\u001d\u0011un\u001c7fC:Ta\u0001P5oSRt$\"B2mK\u0006\u0014(\u0002B+oSRT\u0011b\u0019:fCR,W*\u00199\u000b#A+'o]5ti\u0016tG\u000fS1tQ6\u000b\u0007OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0005kRLGN\u0003\u0002j_*11\u000b\u001e:j]\u001eT\u0011\u0002Z;naZ\u000bG.^3\u000b\u000bY\fG.^3\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\u000bhKR$\u0015N\u001d;z\u001fV$\b/\u001e;DY\u0006\u001c8/Z:\u000b\u0015\r{G\u000e\\3di&|gNC\u0005nCJ\\G)\u001b:us*I1\r\\1tg:\u000bW.\u001a\u0006\t]>$H)\u001b:usz\r!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001r\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\t!!A\u0002A\u0003\u0003\t\tA\t!B\u0002\u0005\t!-A\u0002A\u0003\u0002\u0011\u001d)!\u0001\u0002\u0004\t\u0010\u0015\u0011AQ\u0002\u0005\t\u000b\t!q\u0001#\u0005\u0006\u0007\u0011=\u0001R\u0002\u0007\u0001\u000b\r!A\u0001C\u0005\r\u0001\u0015\u0011Aq\u0002E\u0007\u000b\u0005A)\"\u0002\u0002\u0005\u0014!YQA\u0001\u0003\u000b\u0011%)1\u0001\u0002\u0003\t\u00191\u0001QA\u0001C\n\u0011!)!\u0001b\u0006\t\u0019\u0011\t%\u0001D\u0002\u001a\r\u0015\t\u0001rA\u0005\u0004\u0013\t)\u0011\u0001#\u0003.\u0014\u0011\u0019\u0001$B\u0011\u0003\u000b\u0005AY!U\u0002\u0004\t\u0015I\u0011\u0001\u0002\u0001.$\u0011Q\u0001DB\u0011\u000b\u000b\u0005A\u0001\"C\u0002\n\u0005\u0015\t\u0001\u0012C\u0005\u0004\u0013\t)\u0011\u0001#\u0003R\u0007\r!a!C\u0001\t\u00135\u001aBA\u0003M\n;\u001b!\u0001\u0001\u0003\u0006\u000e\u0005\u0015\t\u0001\u0012\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\t#\u000e)A1C\u0005\u0002\u0011+i\u0011\u0001\"\u0001.\u001c\u0011\u0019\u0001tC\u0011\u0007\u000b\u0005A1\"C\u0002\n\u0005\u0015\t\u0001\u0012C)\u0004\u0007\u0011]\u0011\"\u0001\u0005\r[M!1\u0001'\u0007\u001e\u000e\u0011\u0001\u0001\"D\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0001C\t)\u0011\u0001c\u0003R\u0007\u0015!I\"C\u0001\u0005\u00015\t\u0001RC\u0017\u0014\t\rAZ\"(\u0004\u0005\u0001!iQBA\u0003\u0002\u0011#\u00016\u0001A\u0011\u0003\u000b\u0005AY!U\u0002\u0006\t7I\u0011\u0001\u0002\u0001\u000e\u0003!UQ'D\u0003\r\t\r\b\u0001\u0014B\u0011\u0003\u000b\u0005A1!U\u0002\u0006\t\u0013I\u0011\u0001\u0002\u0001\u000e\u0003!)\u0001"})
    private final class DirtyOutputClassesMap
    extends BasicMap<Boolean> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(DirtyOutputClassesMap.class);
        }

        @Override
        @NotNull
        protected PersistentHashMap<String, Boolean> createMap() {
            return new PersistentHashMap(new File(IncrementalCacheImpl.this.baseDir, Companion.getDIRTY_OUTPUT_CLASSES()), (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)BooleanDataDescriptor.INSTANCE);
        }

        public final void markDirty(@JetValueParameter(name="className") @NotNull String className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            this.getStorage().put((Object)className, (Object)true);
        }

        public final void notDirty(@JetValueParameter(name="className") @NotNull String className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            this.getStorage().remove((Object)className);
        }

        @NotNull
        public final Collection<String> getDirtyOutputClasses() {
            Collection collection = this.getStorage().getAllKeysWithExistingMapping();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"storage.getAllKeysWithExistingMapping()");
            return collection;
        }

        public final void clear() {
            Iterable $receiver = this.getStorage().getAllKeysWithExistingMapping();
            for (Object element : $receiver) {
                String it = (String)element;
                this.getStorage().remove((Object)it);
            }
        }

        @Override
        @NotNull
        protected String dumpValue(@JetValueParameter(name="value") boolean value) {
            return "";
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"1\u0006))\"+Z2p[BLG.\u0019;j_:$UmY5tS>t'\u0002F%oGJ,W.\u001a8uC2\u001c\u0015m\u00195f\u00136\u0004HNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\rQ\u0007o\u001d\u0006\fS:\u001c'/Z7f]R\fGN\u0003\u0003F]Vl'B\u0002\u001fj]&$hH\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTaa\u0015;sS:<'\"B7fe\u001e,'\"B8uQ\u0016\u0014(BK%oGJ,W.\u001a8uC2\u001c\u0015m\u00195f\u00136\u0004H\u000e\n*fG>l\u0007/\u001b7bi&|g\u000eR3dSNLwN\u001c\u0006\u000b\t>{fj\u0014+I\u0013:;%b\b*F\u0007>k\u0005+\u0013'F?>#\u0006*\u0012*`\u0017>#F*\u0013(`\u0013:{6\tS+O\u0017*9#+R\"P\u001bBKE*R0P)\"+%kX%O?\u000eCUKT&`\u0003:#u\fR#Q\u000b:#\u0015I\u0014+T\u0015\u0015\u0012ViQ(N!&cUiX!M\u0019~KejX\"I+:[u,\u0011(E?\u0012+\u0005+\u0012(E\u0003:#6K\u0014\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0003!%QA\u0001C\u0005\u0011\u0015)!\u0001B\u0003\t\f\u0015\u0011AA\u0001\u0005\b\t\u0001\u0007AbA\r\u0007\u000b\u0005AA!C\u0002\n\u0005\u0015\t\u0001bA\u0017\u0014\t\u0001Ab!(\u0004\u0005\u0001!5QBA\u0003\u0002\u0011\r\u00016\u0001A\u0011\u0003\u000b\u0005A1!U\u0002\u0006\t\u0019I\u0011\u0001\u0003\u0004\u000e\u0003!1\u0001w\u0002\u0019\ta#\u0001\u0014\"N\b\u0006\u001d\u0011\t\u000f\u0001\u0007\u0003\"\u0005\u0015\t\u0001bA)\u0004\u000f\u0011!\u0011\"\u0001\u0003\u0001\u001b\u0005AY!D\u0001\u0005\u0006\u0001"})
    public static final class RecompilationDecision
    extends Enum<RecompilationDecision> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ RecompilationDecision DO_NOTHING;
        public static final /* enum */ RecompilationDecision RECOMPILE_OTHER_KOTLIN_IN_CHUNK;
        public static final /* enum */ RecompilationDecision RECOMPILE_OTHER_IN_CHUNK_AND_DEPENDANTS;
        public static final /* enum */ RecompilationDecision RECOMPILE_ALL_IN_CHUNK_AND_DEPENDANTS;
        private static final /* synthetic */ RecompilationDecision[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(RecompilationDecision.class);
            RecompilationDecision[] recompilationDecisionArray = new RecompilationDecision[4];
            RecompilationDecision[] recompilationDecisionArray2 = recompilationDecisionArray;
            recompilationDecisionArray[0] = DO_NOTHING = new RecompilationDecision();
            recompilationDecisionArray[1] = RECOMPILE_OTHER_KOTLIN_IN_CHUNK = new RecompilationDecision();
            recompilationDecisionArray[2] = RECOMPILE_OTHER_IN_CHUNK_AND_DEPENDANTS = new RecompilationDecision();
            recompilationDecisionArray[3] = RECOMPILE_ALL_IN_CHUNK_AND_DEPENDANTS = new RecompilationDecision();
            $VALUES = recompilationDecisionArray;
        }

        @NotNull
        public final RecompilationDecision merge(@JetValueParameter(name="other") @NotNull RecompilationDecision other) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)other), (String)"other");
            return other.ordinal() > this.ordinal() ? other : this;
        }

        public static RecompilationDecision[] values() {
            return (RecompilationDecision[])$VALUES.clone();
        }

        public static RecompilationDecision valueOf(String string) {
            return Enum.valueOf(RecompilationDecision.class, string);
        }
    }
}

